/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.Processor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.UnsupportedPythonSdkTypeException;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdaterOld;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkUpdater
implements StartupActivity.Background {
    private static final Logger LOG = Logger.getInstance(PythonSdkUpdater.class);
    private static final Object ourLock = new Object();
    private static final Set<String> ourUnderRefresh = new HashSet<String>();
    private static final Map<String, PyUpdateSdkRequestData> ourToBeRefreshed = new HashMap<String, PyUpdateSdkRequestData>();
    static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Python SDK Updater", (String)PyBundle.message("python.sdk.updater.notifications.group.title", new Object[0]));

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"python.use.new.sdk.updater")) {
            PythonSdkUpdaterOld.updateProjectSdksOnStartup(project);
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        if (project.isDisposed()) {
            return;
        }
        for (Sdk sdk : PythonSdkUpdater.getPythonSdks(project)) {
            PythonSdkUpdater.scheduleUpdate(sdk, project);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean update(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"python.use.new.sdk.updater")) {
            return PythonSdkUpdaterOld.update(sdk, project, ownerComponent);
        }
        return PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk, project);
    }

    @ApiStatus.Internal
    public static boolean updateVersionAndPathsSynchronouslyAndScheduleRemaining(@NotNull Sdk sdk, @Nullable Project project) {
        boolean isSavedSdk;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"python.use.new.sdk.updater")) {
            return PythonSdkUpdaterOld.update(sdk, project, null);
        }
        Application application = ApplicationManager.getApplication();
        try {
            if (application.isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk, project);
                    return null;
                }, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false, project);
            } else {
                LOG.assertTrue(!application.isReadAccessAllowed(), (Object)"Synchronous SDK update should not be run under read action");
                PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk, project);
            }
        }
        catch (InvalidSdkException e) {
            LOG.warn("Error while evaluating path and version: ", (Throwable)e);
            return false;
        }
        if (project == null) {
            return true;
        }
        PyUpdateSdkRequestData request = new PyUpdateSdkRequestData();
        boolean bl = isSavedSdk = PythonSdkUtil.findSdkByKey(PythonSdkType.getSdkKey(sdk)) != null;
        if (application.isWriteThread() && !isSavedSdk) {
            application.invokeLaterOnWriteThread(() -> PythonSdkUpdater.scheduleUpdate(sdk, project, request));
        } else {
            PythonSdkUpdater.scheduleUpdate(sdk, project, request);
        }
        return true;
    }

    @ApiStatus.Experimental
    public static void scheduleUpdate(@NotNull Sdk sdk, @NotNull Project project) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(4);
        }
        if (!Registry.is((String)"python.use.new.sdk.updater")) {
            PythonSdkUpdaterOld.update(sdk, project, null);
            return;
        }
        PythonSdkUpdater.scheduleUpdate(sdk, project, new PyUpdateSdkRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleUpdate(@NotNull Sdk sdk, @NotNull Project project, @NotNull PyUpdateSdkRequestData requestData) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(6);
        }
        if (requestData == null) {
            PythonSdkUpdater.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("Skipping background update for '" + sdk + "' in unit test mode");
            return;
        }
        String key = PythonSdkType.getSdkKey(sdk);
        Object object = ourLock;
        synchronized (object) {
            if (ourUnderRefresh.contains(key)) {
                PyUpdateSdkRequestData previousRequest;
                if (Trigger.LOG.isDebugEnabled() && (previousRequest = ourToBeRefreshed.get(key)) != null) {
                    String cause = Trigger.getCauseByTrace(previousRequest.myTraceback);
                    Trigger.LOG.debug("Discarding previous update for " + sdk + " triggered by " + cause);
                }
                ourToBeRefreshed.merge(key, requestData, (x$0, x$1) -> PyUpdateSdkRequestData.merge(x$0, x$1));
                return;
            }
            ourUnderRefresh.add(key);
        }
        ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(project, key, requestData));
    }

    @ApiStatus.Internal
    public static void updateOrShowError(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(8);
        }
        if (!Registry.is((String)"python.use.new.sdk.updater")) {
            PythonSdkUpdaterOld.updateOrShowError(sdk, project, ownerComponent);
            return;
        }
        boolean versionAndPathsUpdated = PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk, project);
        if (!versionAndPathsUpdated) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)PyBundle.message("python.sdk.cannot.setup.sdk", PythonSdkUpdater.getSdkPresentableName(sdk)), (String)PyBundle.message("python.sdk.invalid.python.sdk", new Object[0])));
        }
    }

    private static void updateLocalSdkVersionAndPaths(@NotNull Sdk sdk, @Nullable Project project) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(9);
        }
        PythonSdkUpdater.updateLocalSdkVersion(sdk);
        PythonSdkUpdater.updateLocalSdkPaths(sdk, project);
    }

    private static void updateLocalSdkVersion(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(10);
        }
        if (!PythonSdkUtil.isRemote(sdk)) {
            ProgressManager.progress((String)PyBundle.message("sdk.updating.interpreter.version", new Object[0]));
            String versionString = sdk.getSdkType().getVersionString(sdk);
            if (!StringUtil.equals((CharSequence)versionString, (CharSequence)sdk.getVersionString())) {
                PythonSdkUpdater.changeSdkModificator(sdk, (Processor<? super SdkModificator>)((Processor)modificatorToWrite -> {
                    modificatorToWrite.setVersionString(versionString);
                    return true;
                }));
            }
        }
    }

    private static void updateLocalSdkPaths(@NotNull Sdk sdk, @Nullable Project project) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(11);
        }
        if (!PythonSdkUtil.isRemote(sdk)) {
            boolean forceCommit = PythonSdkUpdater.ensureBinarySkeletonsDirectoryExists(sdk);
            List<VirtualFile> localSdkPaths = PythonSdkUpdater.getLocalSdkPaths(sdk, project);
            PythonSdkUpdater.commitSdkPathsIfChanged(sdk, localSdkPaths, forceCommit);
        }
    }

    private static void updateRemoteSdkPaths(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(12);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            boolean forceCommit = PythonSdkUpdater.ensureBinarySkeletonsDirectoryExists(sdk);
            List<VirtualFile> remoteSdkPaths = PythonSdkUpdater.getRemoteSdkPaths(sdk, project);
            PythonSdkUpdater.commitSdkPathsIfChanged(sdk, remoteSdkPaths, forceCommit);
        }
    }

    private static boolean ensureBinarySkeletonsDirectoryExists(Sdk sdk) {
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
        return skeletonsPath != null && new File(skeletonsPath).mkdirs();
    }

    @NotNull
    private static List<VirtualFile> getLocalSdkPaths(@NotNull Sdk sdk, @Nullable Project project) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(13);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(PythonSdkUpdater.filterRootPaths(sdk, PythonSdkUpdater.evaluateSysPath(sdk), project)).addAll(PythonSdkUpdater.getSkeletonsPaths(sdk)).addAll(PythonSdkUpdater.getUserAddedPaths(sdk)).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> getRemoteSdkPaths(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(15);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(PythonSdkUpdater.getRemoteSdkMappedPaths(sdk, project)).addAll(PythonSdkUpdater.getSkeletonsPaths(sdk)).addAll(PythonSdkUpdater.getUserAddedPaths(sdk)).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(16);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> getUserAddedPaths(@NotNull Sdk sdk) {
        SdkAdditionalData additionalData;
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(17);
        }
        ArrayList arrayList = (pythonAdditionalData = PyUtil.as(additionalData = sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? Lists.newArrayList(pythonAdditionalData.getAddedPathFiles()) : Collections.emptyList();
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getRemoteSdkMappedPaths(@NotNull Sdk sdk, @Nullable Project project) {
        SdkAdditionalData additionalData;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(19);
        }
        if ((additionalData = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)additionalData;
            ArrayList<String> paths2 = new ArrayList<String>();
            for (PathMappingSettings.PathMapping mapping : remoteSdkData.getPathMappings().getPathMappings()) {
                paths2.add(mapping.getLocalRoot());
            }
            return PythonSdkUpdater.filterRootPaths(sdk, paths2, project);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            PythonSdkUpdater.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> filterRootPaths(@NotNull Sdk sdk, @NotNull List<String> paths2, @Nullable Project project) {
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(21);
        }
        if (paths2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(22);
        }
        Collection<Object> excludedPaths = (pythonAdditionalData = PyUtil.as(sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? pythonAdditionalData.getExcludedPathFiles() : Collections.emptyList();
        HashSet<VirtualFile> moduleRoots = new HashSet<VirtualFile>();
        if (project != null) {
            Module[] modules;
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                moduleRoots.addAll(PyUtil.getSourceRoots(module));
            }
        }
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        VirtualFile condaFolder = PythonSdkUtil.isConda(sdk) ? PythonSdkUtil.getCondaDirectory(sdk) : null;
        for (String path : paths2) {
            if (path != null && !FileUtilRt.extensionEquals((String)path, (String)"egg-info")) {
                VirtualFile rootFile;
                String normalizedPath = (String)ObjectUtils.notNull((Object)PythonSdkUpdater.restorePathCapitalization(path), (Object)path);
                VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(normalizedPath);
                if (!(virtualFile == null || virtualFile.equals(condaFolder) || excludedPaths.contains(rootFile = PythonSdkType.getSdkRootVirtualFile(virtualFile)) || moduleRoots.contains(rootFile))) {
                    results.add(rootFile);
                    continue;
                }
            }
            LOG.info("Bogus sys.path entry " + path);
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Nullable
    private static String restorePathCapitalization(@NotNull String path) {
        if (path == null) {
            PythonSdkUpdater.$$$reportNull$$$0(24);
        }
        try {
            return Paths.get(path, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static List<VirtualFile> getSkeletonsPaths(@NotNull Sdk sdk) {
        VirtualFile userSkeletonsDir;
        VirtualFile skeletonsDir;
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(25);
        }
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
        if (skeletonsPath != null && (skeletonsDir = StandardFileSystems.local().refreshAndFindFileByPath(skeletonsPath)) != null) {
            results.add(skeletonsDir);
            LOG.info("Binary skeletons directory for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk) + "): " + skeletonsDir.getPath());
        }
        if ((userSkeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
            results.add(userSkeletonsDir);
            LOG.info("User skeletons directory for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk) + "): " + userSkeletonsDir.getPath());
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            PythonSdkUpdater.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static String getSdkPresentableName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(27);
        }
        String homePath = sdk.getHomePath();
        String name = sdk.getName();
        Object object = homePath != null ? name + " (" + homePath + ")" : name;
        if (object == null) {
            PythonSdkUpdater.$$$reportNull$$$0(28);
        }
        return object;
    }

    @NotNull
    private static List<String> evaluateSysPath(@NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(29);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            throw new IllegalArgumentException("Cannot evaluate sys.path for remote Python interpreter " + sdk);
        }
        long startTime = System.currentTimeMillis();
        ProgressManager.progress((String)PyBundle.message("sdk.updating.interpreter.paths", new Object[0]));
        List<String> sysPath = PythonSdkType.getSysPath(sdk);
        LOG.info("Updating sys.path took " + (System.currentTimeMillis() - startTime) + " ms");
        List<String> list = sysPath;
        if (list == null) {
            PythonSdkUpdater.$$$reportNull$$$0(30);
        }
        return list;
    }

    private static void commitSdkPathsIfChanged(@NotNull Sdk sdk, @NotNull List<VirtualFile> sdkPaths, boolean forceCommit) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(31);
        }
        if (sdkPaths == null) {
            PythonSdkUpdater.$$$reportNull$$$0(32);
        }
        List<VirtualFile> currentSdkPaths = Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        if (forceCommit || !Sets.newHashSet(sdkPaths).equals(Sets.newHashSet(currentSdkPaths))) {
            PythonSdkUpdater.changeSdkModificator(sdk, (Processor<? super SdkModificator>)((Processor)effectiveModificator -> {
                effectiveModificator.removeAllRoots();
                for (VirtualFile sdkPath : sdkPaths) {
                    effectiveModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(sdkPath), OrderRootType.CLASSES);
                }
                return true;
            }));
        }
    }

    private static void changeSdkModificator(@NotNull Sdk sdk, @NotNull Processor<? super SdkModificator> processor2) {
        if (sdk == null) {
            PythonSdkUpdater.$$$reportNull$$$0(33);
        }
        if (processor2 == null) {
            PythonSdkUpdater.$$$reportNull$$$0(34);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            SdkModificator effectiveModificator = sdk.getSdkModificator();
            if (processor2.process((Object)effectiveModificator)) {
                effectiveModificator.commitChanges();
            }
        });
    }

    @NotNull
    private static Set<Sdk> getPythonSdks(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdater.$$$reportNull$$$0(35);
        }
        LinkedHashSet<Sdk> pythonSdks = new LinkedHashSet<Sdk>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) continue;
            pythonSdks.add(sdk);
        }
        LinkedHashSet<Sdk> linkedHashSet = pythonSdks;
        if (linkedHashSet == null) {
            PythonSdkUpdater.$$$reportNull$$$0(36);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestData";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPaths";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSdkPaths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkPaths";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAddedPaths";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkMappedPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRootPaths";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPaths";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPresentableName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSysPath";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateVersionAndPathsSynchronouslyAndScheduleRemaining";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateOrShowError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersionAndPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkPaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateRemoteSdkPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSdkPaths";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 36: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserAddedPaths";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkMappedPaths";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filterRootPaths";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "restorePathCapitalization";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPaths";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPresentableName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSysPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkPathsIfChanged";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "changeSdkModificator";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Trigger {
        STARTUP_ACTIVITY("com.jetbrains.python.sdk.PythonSdkUpdater.runActivity"),
        CHANGE_UNDER_INTERPRETER_ROOTS("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$subscribeToLocalChanges"),
        REFRESH_AFTER_PACKAGING_OPERATION("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$refresh"),
        NEW_SDK_GENERATION("com.jetbrains.python.sdk.PySdkExtKt.createSdkByGenerateTask"),
        CHANGED_SDK_CONFIGURATION("com.jetbrains.python.configuration.PyActiveSdkConfigurable.apply"),
        SDK_RELOAD_IN_SETTINGS("com.jetbrains.python.configuration.PythonSdkDetailsDialog.reloadSdk"),
        START_SDK_UPDATES_ACTION("com.jetbrains.python.sdk.PyUpdateProjectSdkAction.lambda$actionPerformed");

        private static final Logger LOG;
        private final String myFrameMarker;

        private Trigger(String frameMarker) {
            if (frameMarker == null) {
                Trigger.$$$reportNull$$$0(0);
            }
            this.myFrameMarker = frameMarker;
        }

        @NotNull
        public static String getCauseByTrace(@NotNull Throwable trace) {
            Trigger trigger;
            if (trace == null) {
                Trigger.$$$reportNull$$$0(1);
            }
            if ((trigger = Trigger.findTriggerByTrace(trace)) != null) {
                String string = trigger.name();
                if (string == null) {
                    Trigger.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = "Unknown trigger:\n" + ExceptionUtil.getThrowableText((Throwable)trace);
            if (string == null) {
                Trigger.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public static Trigger findTriggerByTrace(@NotNull Throwable trace) {
            if (trace == null) {
                Trigger.$$$reportNull$$$0(4);
            }
            String traceText = ExceptionUtil.getThrowableText((Throwable)trace);
            for (Trigger value : Trigger.values()) {
                if (!traceText.contains(value.myFrameMarker)) continue;
                return value;
            }
            return null;
        }

        static {
            LOG = Logger.getInstance(Trigger.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameMarker";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdater$Trigger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$Trigger";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCauseByTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCauseByTrace";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findTriggerByTrace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyUpdateSdkTask
    extends Task.Backgroundable {
        @NotNull
        private final String mySdkKey;
        @NotNull
        private final PyUpdateSdkRequestData myRequestData;

        PyUpdateSdkTask(@NotNull Project project, @NotNull String key, @NotNull PyUpdateSdkRequestData requestData) {
            if (project == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(0);
            }
            if (key == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(1);
            }
            if (requestData == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(2);
            }
            super(project, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false);
            this.mySdkKey = key;
            this.myRequestData = requestData;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(3);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            @Nullable Sdk sdk = PythonSdkUtil.findSdkByKey(this.mySdkKey);
            if (sdk == null) {
                LOG.warn("SDK for " + this.mySdkKey + " was removed from the SDK list");
                return;
            }
            if (Trigger.LOG.isDebugEnabled()) {
                Trigger.LOG.debug("Starting SDK refresh for '" + this.mySdkKey + "' triggered by " + Trigger.getCauseByTrace(this.myRequestData.myTraceback));
            }
            try {
                PythonSdkUpdater.updateLocalSdkVersionAndPaths(sdk, this.myProject);
                this.generateSkeletons(sdk, indicator);
                this.refreshPackages(sdk, indicator);
            }
            catch (InvalidSdkException e) {
                LOG.warn("Update for SDK " + sdk + " failed", (Throwable)e);
            }
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(), this.myProject.getDisposed());
        }

        private void refreshPackages(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator) {
            if (sdk == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                PyUpdateSdkTask.$$$reportNull$$$0(5);
            }
            try {
                LOG.info("Performing background scan of packages for SDK " + PythonSdkUpdater.getSdkPresentableName(sdk));
                indicator.setIndeterminate(true);
                indicator.setText(PyBundle.message("python.sdk.scanning.installed.packages", new Object[0]));
                indicator.setText2("");
                PyPackageManager.getInstance(sdk).refreshAndGetPackages(true);
            }
            catch (ExecutionException e) {
                if (LOG.isDebugEnabled()) {
                    e.initCause(this.myRequestData.myTraceback);
                    LOG.debug((Throwable)e);
                }
                LOG.warn(e.getMessage());
            }
        }

        private void generateSkeletons(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator) {
            block6: {
                if (sdk == null) {
                    PyUpdateSdkTask.$$$reportNull$$$0(6);
                }
                if (indicator == null) {
                    PyUpdateSdkTask.$$$reportNull$$$0(7);
                }
                String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
                try {
                    String sdkPresentableName = PythonSdkUpdater.getSdkPresentableName(sdk);
                    LOG.info("Performing background update of skeletons for SDK " + sdkPresentableName);
                    indicator.setText(PyBundle.message("python.sdk.updating.skeletons", new Object[0]));
                    PySkeletonRefresher.refreshSkeletonsOfSdk(this.myProject, null, skeletonsPath, sdk);
                    PythonSdkUpdater.updateRemoteSdkPaths(sdk, this.getProject());
                }
                catch (UnsupportedPythonSdkTypeException e) {
                    NOTIFICATION_GROUP.createNotification(PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), null, PyBundle.message("remote.interpreter.support.is.not.available", sdk.getName()), NotificationType.WARNING).notify(this.myProject);
                }
                catch (InvalidSdkException e) {
                    if (PythonSdkUtil.isRemote(PythonSdkUtil.findSdkByKey(this.mySdkKey))) {
                        PythonSdkType.notifyRemoteSdkSkeletonsFail(e, () -> {
                            Sdk revalidatedSdk = PythonSdkUtil.findSdkByKey(this.mySdkKey);
                            if (revalidatedSdk != null) {
                                PythonSdkUpdater.update(revalidatedSdk, this.myProject, null);
                            }
                        });
                    }
                    if (PythonSdkUtil.isInvalid(sdk)) break block6;
                    LOG.error((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFinished() {
            PyUpdateSdkRequestData requestData;
            if (Trigger.LOG.isDebugEnabled()) {
                Trigger.LOG.debug("Finishing SDK refresh for '" + this.mySdkKey + "' originally scheduled at " + this.myRequestData.myTimestamp + " by " + Trigger.getCauseByTrace(this.myRequestData.myTraceback));
            }
            Object object = ourLock;
            synchronized (object) {
                boolean existed = ourUnderRefresh.remove(this.mySdkKey);
                LOG.assertTrue(existed, (Object)"Error in SDK refresh scheduling: refreshed SDK is not in the set.");
                requestData = ourToBeRefreshed.remove(this.mySdkKey);
                if (requestData != null) {
                    ourUnderRefresh.add(this.mySdkKey);
                }
            }
            if (requestData != null) {
                ProgressManager.getInstance().run((Task)new PyUpdateSdkTask(this.myProject, this.mySdkKey, requestData));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestData";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$PyUpdateSdkTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshPackages";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateSkeletons";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PyUpdateSdkRequestData {
        final Instant myTimestamp;
        final Throwable myTraceback;

        private PyUpdateSdkRequestData() {
            this(Instant.now(), new Throwable());
        }

        private PyUpdateSdkRequestData(@NotNull Instant timestamp, @NotNull Throwable traceback) {
            if (timestamp == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(0);
            }
            if (traceback == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(1);
            }
            this.myTimestamp = timestamp;
            this.myTraceback = traceback;
        }

        @NotNull
        private static PyUpdateSdkRequestData merge(@NotNull PyUpdateSdkRequestData oldRequest, @NotNull PyUpdateSdkRequestData newRequest) {
            if (oldRequest == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(2);
            }
            if (newRequest == null) {
                PyUpdateSdkRequestData.$$$reportNull$$$0(3);
            }
            return new PyUpdateSdkRequestData(oldRequest.myTimestamp, newRequest.myTraceback);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traceback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRequest";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRequest";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdater$PyUpdateSdkRequestData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

