/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonEnvUtil {
    public static final String PYTHONPATH = "PYTHONPATH";
    public static final String PYTHONUNBUFFERED = "PYTHONUNBUFFERED";
    public static final String PYTHONIOENCODING = "PYTHONIOENCODING";
    public static final String IPYTHONENABLE = "IPYTHONENABLE";
    public static final String PYTHONDONTWRITEBYTECODE = "PYTHONDONTWRITEBYTECODE";
    public static final String PYVENV_LAUNCHER = "__PYVENV_LAUNCHER__";

    private PythonEnvUtil() {
    }

    public static Map<String, String> setPythonUnbuffered(@NotNull Map<String, String> env) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(0);
        }
        env.put(PYTHONUNBUFFERED, "1");
        return env;
    }

    public static Map<String, String> setPythonIOEncoding(@NotNull Map<String, String> env, @NotNull String encoding) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            PythonEnvUtil.$$$reportNull$$$0(2);
        }
        env.put(PYTHONIOENCODING, encoding);
        return env;
    }

    public static Map<String, String> resetHomePathChanges(@NotNull String homePath, @NotNull Map<String, String> env) {
        if (homePath == null) {
            PythonEnvUtil.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(4);
        }
        if (System.getenv(PYVENV_LAUNCHER) != null || EnvironmentUtil.getEnvironmentMap().containsKey(PYVENV_LAUNCHER)) {
            env.put(PYVENV_LAUNCHER, homePath);
        }
        return env;
    }

    @NotNull
    public static String addToPathEnvVar(@Nullable String source, @NotNull String value, boolean asPrefix) {
        if (value == null) {
            PythonEnvUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)source)) {
            String string = value;
            if (string == null) {
                PythonEnvUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        HashSet paths2 = Sets.newHashSet((Object[])source.split(File.pathSeparator));
        if (!paths2.contains(value)) {
            if (asPrefix) {
                String string = value + File.pathSeparator + source;
                if (string == null) {
                    PythonEnvUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = source + File.pathSeparator + value;
            if (string == null) {
                PythonEnvUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = source;
        if (string == null) {
            PythonEnvUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static void addPathsToEnv(@NotNull Map<String, String> env, String key, @NotNull Collection<String> values) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(10);
        }
        if (values == null) {
            PythonEnvUtil.$$$reportNull$$$0(11);
        }
        for (String val : values) {
            PythonEnvUtil.addPathToEnv(env, key, val);
        }
    }

    public static void addPathToEnv(@NotNull Map<String, String> env, String key, String value) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(12);
        }
        if (!StringUtil.isEmpty((String)value)) {
            if (env.containsKey(key)) {
                env.put(key, PythonEnvUtil.addToPathEnvVar(env.get(key), value, false));
            } else {
                env.put(key, value);
            }
        }
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, @NotNull Collection<String> values) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(13);
        }
        if (values == null) {
            PythonEnvUtil.$$$reportNull$$$0(14);
        }
        PythonEnvUtil.addPathsToEnv(env, PYTHONPATH, values);
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, String value) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(15);
        }
        PythonEnvUtil.addPathToEnv(env, PYTHONPATH, value);
    }

    public static void mergePythonPath(@NotNull Map<String, String> from, @NotNull Map<String, String> to) {
        String value;
        if (from == null) {
            PythonEnvUtil.$$$reportNull$$$0(16);
        }
        if (to == null) {
            PythonEnvUtil.$$$reportNull$$$0(17);
        }
        if ((value = from.get(PYTHONPATH)) != null) {
            HashSet paths2 = Sets.newHashSet((Object[])value.split(File.pathSeparator));
            PythonEnvUtil.addToPythonPath(to, paths2);
        }
    }

    @NotNull
    public static Map<String, String> setPythonDontWriteBytecode(@NotNull Map<String, String> env) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(18);
        }
        env.put(PYTHONDONTWRITEBYTECODE, "1");
        Map<String, String> map2 = env;
        if (map2 == null) {
            PythonEnvUtil.$$$reportNull$$$0(19);
        }
        return map2;
    }

    public static Collection<String> appendSystemPythonPath(@NotNull Collection<String> pythonPath) {
        if (pythonPath == null) {
            PythonEnvUtil.$$$reportNull$$$0(20);
        }
        return PythonEnvUtil.appendSystemEnvPaths(pythonPath, PYTHONPATH);
    }

    public static Collection<String> appendSystemEnvPaths(@NotNull Collection<String> pythonPath, String envname) {
        String syspath;
        if (pythonPath == null) {
            PythonEnvUtil.$$$reportNull$$$0(21);
        }
        if ((syspath = System.getenv(envname)) != null) {
            pythonPath.addAll(Lists.newArrayList((Object[])syspath.split(File.pathSeparator)));
        }
        return pythonPath;
    }

    public static void initPythonPath(@NotNull Map<String, String> envs, boolean passParentEnvs, @NotNull Collection<String> pythonPathList) {
        if (envs == null) {
            PythonEnvUtil.$$$reportNull$$$0(22);
        }
        if (pythonPathList == null) {
            PythonEnvUtil.$$$reportNull$$$0(23);
        }
        if (passParentEnvs && !envs.containsKey(PYTHONPATH)) {
            pythonPathList = PythonEnvUtil.appendSystemPythonPath(pythonPathList);
        }
        PythonEnvUtil.addToPythonPath(envs, pythonPathList);
    }

    public static void addToEnv(String key, String value, Map<String, String> envs) {
        PythonEnvUtil.addPathToEnv(envs, key, value);
    }

    public static void setupEncodingEnvs(Map<String, String> envs, @NotNull Charset charset) {
        if (charset == null) {
            PythonEnvUtil.$$$reportNull$$$0(24);
        }
        String encoding = charset.name();
        PythonEnvUtil.setPythonIOEncoding(envs, encoding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonEnvUtil";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPathList";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonEnvUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addToPathEnvVar";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setPythonDontWriteBytecode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPythonUnbuffered";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPythonIOEncoding";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetHomePathChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addToPathEnvVar";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPathsToEnv";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPathToEnv";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mergePythonPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setPythonDontWriteBytecode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemPythonPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemEnvPaths";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupEncodingEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

