/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.SyntaxTreeBuilder;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;

public class ParsingContext {
    private final StatementParsing stmtParser;
    private final ExpressionParsing expressionParser;
    private final FunctionParsing functionParser;
    private final SyntaxTreeBuilder myBuilder;
    private final LanguageLevel myLanguageLevel;
    private final Deque<ParsingScope> myScopes;

    public ParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel) {
        this.myBuilder = builder;
        this.myLanguageLevel = languageLevel;
        this.stmtParser = new StatementParsing(this);
        this.expressionParser = new ExpressionParsing(this);
        this.functionParser = new FunctionParsing(this);
        this.myScopes = new ArrayDeque<ParsingScope>();
        this.myScopes.push(this.emptyParsingScope());
    }

    @NotNull
    public ParsingScope popScope() {
        ParsingScope prevScope = this.myScopes.pop();
        this.resetBuilderCache(prevScope);
        ParsingScope parsingScope = prevScope;
        if (parsingScope == null) {
            ParsingContext.$$$reportNull$$$0(0);
        }
        return parsingScope;
    }

    public void pushScope(@NotNull ParsingScope scope) {
        if (scope == null) {
            ParsingContext.$$$reportNull$$$0(1);
        }
        ParsingScope prevScope = this.getScope();
        this.myScopes.push(scope);
        this.resetBuilderCache(prevScope);
    }

    @NotNull
    public ParsingScope getScope() {
        ParsingScope parsingScope = this.myScopes.peek();
        if (parsingScope == null) {
            ParsingContext.$$$reportNull$$$0(2);
        }
        return parsingScope;
    }

    public StatementParsing getStatementParser() {
        return this.stmtParser;
    }

    public ExpressionParsing getExpressionParser() {
        return this.expressionParser;
    }

    public FunctionParsing getFunctionParser() {
        return this.functionParser;
    }

    public SyntaxTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public ParsingScope emptyParsingScope() {
        return new ParsingScope();
    }

    private void resetBuilderCache(@NotNull ParsingScope prevScope) {
        if (prevScope == null) {
            ParsingContext.$$$reportNull$$$0(3);
        }
        if (!this.getScope().equals(prevScope)) {
            this.getBuilder().mark().rollbackTo();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/parsing/ParsingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "popScope";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/parsing/ParsingContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pushScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetBuilderCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

