/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.analysis.AnalysisScope;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.facet.PythonFacetType;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PythonPluginCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "python";
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        String string = PyBundle.message("py.commandline.configure", new Object[0]);
        if (string == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isApplicable(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        List<Sdk> sdks;
        if (context == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (!(sdks = PythonSdkUtil.getAllSdks()).isEmpty()) {
            return false;
        }
        try {
            boolean hasAnyPythonFiles = Files.walk(context.getProjectPath(), new FileVisitOption[0]).anyMatch(f -> f.toString().endsWith(".py"));
            if (!hasAnyPythonFiles) {
                context.getLogger().reportMessage(3, "Skipping Python interpreter autodetection because the project doesn't contain any Python files");
            }
            return hasAnyPythonFiles;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        if (context == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        CommandLineInspectionProgressReporter logger = context.getLogger();
        logger.reportMessage(3, "Python environment configuration...");
        List<Sdk> sdks = PythonSdkUtil.getAllSdks();
        logger.reportMessage(3, "Python interpreters detected:");
        for (Sdk sdk : sdks) {
            logger.reportMessage(3, sdk.getHomePath());
        }
        if (sdks.isEmpty()) {
            List<Sdk> detectedSdks = PySdkExtKt.findAllPythonSdks(context.getProjectPath());
            if (detectedSdks.size() > 0) {
                for (Sdk sdk2 : detectedSdks) {
                    logger.reportMessage(3, sdk2.getHomePath());
                }
                Sdk sdk = detectedSdks.get(0);
                WriteAction.runAndWait(() -> {
                    logger.reportMessage(1, "Settings up interpreter " + sdk.getName());
                    ProjectJdkTable.getInstance().addJdk(sdk);
                });
                PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(sdk, null);
            } else {
                logger.reportMessage(1, "ERROR: Can't find Python interpreter");
            }
        }
    }

    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        List<Sdk> sdks;
        if (project == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(4);
        }
        if ((sdks = PythonSdkUtil.getAllSdks()).isEmpty()) {
            return;
        }
        AnalysisScope scope = context.getAnalyzerScope();
        if (scope == null) {
            return;
        }
        PythonFacetType facetType = PythonFacetType.getInstance();
        for (VirtualFile f : scope.getFiles()) {
            Module m;
            if (!FileTypeRegistry.getInstance().isFileOfType(f, (FileType)PythonFileType.INSTANCE) || (m = ModuleUtilCore.findModuleForFile((VirtualFile)f, (Project)project)) == null || FacetManager.getInstance((Module)m).getFacetByType(facetType.getId()) != null) continue;
            WriteAction.runAndWait(() -> FacetManager.getInstance((Module)m).addFacet((FacetType)facetType, facetType.getPresentableName(), null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PythonPluginCommandLineInspectionProjectConfigurator";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PythonPluginCommandLineInspectionProjectConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

