/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyMandatoryEncodingInspection
extends PyInspection {
    @NlsSafe
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;
    public boolean myAllPythons = false;

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    public JComponent createOptionsPanel() {
        JPanel main = new JPanel(new GridBagLayout());
        main.add((Component)this.onlyPython2Box(), PyMandatoryEncodingInspection.fixedIn(0));
        main.add((Component)PyMandatoryEncodingInspection.defaultEncodingLabel(), PyMandatoryEncodingInspection.fixedIn(1));
        main.add(this.defaultEncodingBox(), PyMandatoryEncodingInspection.resizableIn(1));
        main.add((Component)PyMandatoryEncodingInspection.encodingFormatLabel(), PyMandatoryEncodingInspection.fixedIn(2));
        main.add(this.encodingFormatBox(), PyMandatoryEncodingInspection.resizableIn(2));
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)main, "North");
        return result;
    }

    @NotNull
    private static GridBagConstraints fixedIn(int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = y;
        GridBagConstraints gridBagConstraints = c;
        if (gridBagConstraints == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(2);
        }
        return gridBagConstraints;
    }

    @NotNull
    private static GridBagConstraints resizableIn(int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = y;
        GridBagConstraints gridBagConstraints = c;
        if (gridBagConstraints == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(3);
        }
        return gridBagConstraints;
    }

    @NotNull
    private JPanel onlyPython2Box() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        JCheckBox checkBox = PythonUiService.getInstance().createInspectionCheckBox(PyPsiBundle.message("INSP.mandatory.encoding.checkbox.enable.in.python.3", new Object[0]), (InspectionProfileEntry)this, "myAllPythons");
        if (checkBox != null) {
            panel2.add(checkBox);
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel defaultEncodingLabel() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(new JLabel(PyPsiBundle.message("INSP.mandatory.encoding.label.select.default.encoding", new Object[0])));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    private JComboBox<String> defaultEncodingBox() {
        JComboBox<String> box = PythonUiService.getInstance().createComboBox(PyEncodingUtil.POSSIBLE_ENCODINGS);
        box.setSelectedItem(this.myDefaultEncoding);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyMandatoryEncodingInspection.this.myDefaultEncoding = (String)cb.getSelectedItem();
            }
        });
        JComboBox<String> jComboBox = box;
        if (jComboBox == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(6);
        }
        return jComboBox;
    }

    @NotNull
    private static JPanel encodingFormatLabel() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(new JLabel(PyPsiBundle.message("INSP.mandatory.encoding.label.encoding.comment.format", new Object[0])));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    private JComboBox<String> encodingFormatBox() {
        JComboBox<String> box = PythonUiService.getInstance().createComboBox(PyEncodingUtil.ENCODING_FORMAT, 250);
        box.setSelectedIndex(this.myEncodingFormatIndex);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyMandatoryEncodingInspection.this.myEncodingFormatIndex = cb.getSelectedIndex();
            }
        });
        JComboBox<String> jComboBox = box;
        if (jComboBox == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(8);
        }
        return jComboBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fixedIn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resizableIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyPython2Box";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingBox";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!PyMandatoryEncodingInspection.this.myAllPythons && !LanguageLevel.forElement((PsiElement)node).isPython2()) {
                return;
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(node);
            if (charsetString == null) {
                TextRange tr = new TextRange(0, 0);
                ProblemsHolder holder = this.getHolder();
                if (holder != null) {
                    holder.registerProblem((PsiElement)node, tr, PyPsiBundle.message("INSP.mandatory.encoding.no.encoding.specified.for.file", new Object[0]), new LocalQuickFix[]{new AddEncodingQuickFix(PyMandatoryEncodingInspection.this.myDefaultEncoding, PyMandatoryEncodingInspection.this.myEncodingFormatIndex)});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

