/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyTypeModelBuilder;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocumentationProvider
implements DocumentationProvider {
    public static final String DOCUMENTATION_CONFIGURABLE_ID = "com.jetbrains.python.documentation.PythonDocumentationConfigurable";
    private static final int RETURN_TYPE_WRAPPING_THRESHOLD = 80;
    private static final String BULLET_POINT = "\u2022";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, @NotNull PsiElement originalElement) {
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(0);
        }
        for (PythonDocumentationQuickInfoProvider point : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            String info = point.getQuickInfo(originalElement);
            if (info == null) continue;
            return info;
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(originalElement.getProject(), originalElement.getContainingFile());
        if (element instanceof PyFunction) {
            String clsName;
            PyFunction function = (PyFunction)element;
            ChainIterable<String> result = new ChainIterable<String>();
            PyClass cls = function.getContainingClass();
            if (cls != null && (clsName = cls.getName()) != null) {
                result.addItem("class ").addItem(clsName).addItem("\n");
            }
            result.add(PythonDocumentationProvider.describeDecorators(function, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeFunction(function, context, true));
            String docStringSummary = PythonDocumentationProvider.getDocStringSummary(function);
            if (docStringSummary != null) {
                result.addItem("\n").addItem(PythonDocumentationProvider.escaped(docStringSummary));
            }
            return result.toString();
        }
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            ChainIterable<String> result = new ChainIterable<String>();
            result.add(PythonDocumentationProvider.describeDecorators(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeClass(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, false, false, context));
            String docStringSummary = PythonDocumentationProvider.getDocStringSummary(cls);
            if (docStringSummary != null) {
                result.addItem("\n").addItem(PythonDocumentationProvider.escaped(docStringSummary));
            } else {
                Optional.ofNullable(cls.findInitOrNew(false, context)).map(PythonDocumentationProvider::getDocStringSummary).ifPresent(summary -> result.addItem("\n").addItem(PythonDocumentationProvider.escaped(summary)));
            }
            return result.toString();
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.describeExpression((PyExpression)element, originalElement, DocumentationBuilderKit.ESCAPE_ONLY, context);
        }
        return null;
    }

    @Nullable
    private static String getDocStringSummary(@NotNull PyDocStringOwner owner) {
        PyStringLiteralExpression docStringExpression;
        if (owner == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((docStringExpression = PyDocumentationBuilder.getEffectiveDocStringExpression(owner)) != null) {
            StructuredDocString docString = DocStringUtil.parse(docStringExpression.getStringValue(), docStringExpression);
            return docString.getSummary();
        }
        return null;
    }

    @NotNull
    static ChainIterable<String> describeFunction(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(3);
        }
        return new ChainIterable<String>(PythonDocumentationProvider.describeFunctionWithTypes(function, context, forTooltip));
    }

    @NotNull
    static ChainIterable<String> describeTarget(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        if (target == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(5);
        }
        ChainIterable<String> result = new ChainIterable<String>();
        result.addItem(StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)target.getName())));
        result.addItem(": ");
        PythonDocumentationProvider.describeTypeWithLinks(context.getType(target), target, context, target, result);
        PyExpression value = target.findAssignedValue();
        if (value != null) {
            result.addItem(" = ");
            String initializerText = value.getText();
            int index = initializerText.indexOf("\n");
            if (index < 0) {
                result.addItem(StringUtil.escapeXmlEntities((String)initializerText));
            } else {
                result.addItem(StringUtil.escapeXmlEntities((String)initializerText.substring(0, index))).addItem("...");
            }
        }
        ChainIterable<String> chainIterable = result;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(6);
        }
        return chainIterable;
    }

    @NotNull
    static ChainIterable<String> describeParameter(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        if (parameter == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(8);
        }
        ChainIterable<String> result = new ChainIterable<String>();
        result.addItem(StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)parameter.getName())));
        result.addItem(": ");
        PythonDocumentationProvider.describeTypeWithLinks(context.getType(parameter), parameter, context, parameter, result);
        ChainIterable<String> chainIterable = result;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(9);
        }
        return chainIterable;
    }

    @NotNull
    private static String describeFunctionWithTypes(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(11);
        }
        StringBuilder result = new StringBuilder();
        if (function.isAsync()) {
            result.append("async ");
        }
        result.append("def ");
        String funcName = StringUtil.notNullize((String)function.getName(), (String)"<unnamed>");
        int firstParamOffset = result.length() + funcName.length();
        int lastLineOffset = 0;
        if (forTooltip) {
            result.append(PythonDocumentationProvider.escaped(funcName));
        } else {
            PythonDocumentationProvider.appendWithTags(result, PythonDocumentationProvider.escaped(funcName), "b");
        }
        result.append("(");
        ++firstParamOffset;
        boolean first = true;
        boolean firstIsSelf = false;
        List parameters = function.getParameters(context);
        for (PyCallableParameter parameter : parameters) {
            if (!first) {
                result.append(",");
                if (forTooltip || firstIsSelf && parameters.size() == 2) {
                    result.append(" ");
                } else {
                    result.append("\n");
                    lastLineOffset = result.length();
                    StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)firstParamOffset);
                }
            } else {
                firstIsSelf = parameter.isSelf();
            }
            Object paramName = parameter.getName();
            PyType paramType = parameter.getType(context);
            PyNamedParameter named = PyUtil.as(parameter.getParameter(), PyNamedParameter.class);
            boolean showType = true;
            if (parameter.isPositionalContainer()) {
                paramName = "*" + StringUtil.notNullize((String)paramName, (String)"args");
                PyTupleType tupleType = PyUtil.as(paramType, PyTupleType.class);
                if (tupleType != null) {
                    paramType = tupleType.getIteratedItemType();
                }
            } else if (parameter.isKeywordContainer()) {
                paramName = "**" + StringUtil.notNullize((String)paramName, (String)"kwargs");
                PyCollectionType genericType = PyUtil.as(paramType, PyCollectionType.class);
                if (genericType != null && genericType.getPyClass() == PyBuiltinCache.getInstance(function).getClass("dict")) {
                    List<PyType> typeParams = genericType.getElementTypes();
                    paramType = typeParams.size() == 2 ? typeParams.get(1) : null;
                }
            } else if (parameter.getParameter() instanceof PySlashParameter) {
                paramName = "/";
                showType = false;
            } else if (parameter.getParameter() instanceof PySingleStarParameter) {
                paramName = "*";
                showType = false;
            } else {
                paramName = StringUtil.notNullize((String)paramName, (String)"<unnamed>");
                showType = !parameter.isSelf() || named != null && new PyTypingTypeProvider().getParameterType(named, function, context) != null;
            }
            result.append(PythonDocumentationProvider.escaped((String)paramName));
            if (showType) {
                result.append(": ");
                result.append(PythonDocumentationProvider.formatTypeWithLinks(paramType, named, function, context));
            }
            String defaultValue = parameter.getDefaultValueText();
            result.append(PythonDocumentationProvider.escaped((String)ObjectUtils.notNull((Object)ParamHelper.getDefaultValuePartInSignature(defaultValue, showType), (Object)"")));
            first = false;
        }
        result.append(")");
        if (!forTooltip && StringUtil.stripHtml((String)result.substring(lastLineOffset), (boolean)false).length() > 80) {
            result.append("\n ");
        }
        result.append(PythonDocumentationProvider.escaped(" -> ")).append(PythonDocumentationProvider.formatTypeWithLinks(context.getReturnType(function), function, function, context));
        String string = result.toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static String describeExpression(@NotNull PyExpression expression, @NotNull PsiElement originalElement, @NotNull Function<String, String> escaper, @NotNull TypeEvalContext context) {
        String name;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(16);
        }
        if ((name = expression.getName()) != null) {
            PyFunction function;
            StringBuilder result = new StringBuilder(expression instanceof PyNamedParameter ? "parameter" : "variable");
            result.append(String.format(" \"%s\"", name));
            if (expression instanceof PyNamedParameter && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class)) != null) {
                result.append(" of ").append(function.getContainingClass() == null ? "function" : "method").append(String.format(" \"%s\"", function.getName()));
            }
            if (originalElement instanceof PyTypedElement) {
                String typeName = PythonDocumentationProvider.getTypeName(context.getType((PyTypedElement)originalElement), context);
                result.append("\n").append(String.format("Inferred type: %s", typeName));
            }
            return escaper.apply(result.toString());
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(17);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String getTypeHint(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(19);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asPep484TypeHint();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(20);
        }
        return string;
    }

    public static void describeTypeWithLinks(@Nullable PyType type, @Nullable PyTypedElement typeOwner, @NotNull TypeEvalContext context, @NotNull PsiElement anchor, @NotNull ChainIterable<String> body) {
        PyAssignmentStatement assignment;
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(22);
        }
        if (body == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (typeOwner instanceof PyTargetExpression && type == null && (assignment = PyUtil.as(typeOwner.getParent(), PyAssignmentStatement.class)) != null && PyTypingTypeProvider.isExplicitTypeAlias(assignment, context)) {
            body.addItem("TypeAlias");
            return;
        }
        PythonDocumentationProvider.buildTypeModel(type, context).toBodyWithLinks(body, anchor);
    }

    @NotNull
    public static String getTypeDescription(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(24);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asDescription();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static PyTypeModelBuilder.TypeModel buildTypeModel(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(26);
        }
        PyTypeModelBuilder.TypeModel typeModel = new PyTypeModelBuilder(context).build(type, true);
        if (typeModel == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(27);
        }
        return typeModel;
    }

    @NotNull
    static ChainIterable<String> describeDecorators(@NotNull PyDecoratable decoratable, @NotNull Function<String, String> escapedCalleeMapper, @NotNull @NotNull Function<@NotNull String, @NotNull String> escaper, @NotNull String separator, @NotNull String suffix) {
        if (decoratable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (separator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(31);
        }
        if (suffix == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(32);
        }
        ChainIterable<String> result = new ChainIterable<String>();
        PyDecoratorList decoratorList = decoratable.getDecoratorList();
        if (decoratorList != null) {
            boolean first = true;
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                if (!first) {
                    result.addItem(separator);
                }
                result.add(PythonDocumentationProvider.describeDecorator(decorator, escapedCalleeMapper, escaper));
                first = false;
            }
        }
        if (!result.isEmpty()) {
            result.addItem(suffix);
        }
        ChainIterable<String> chainIterable = result;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(33);
        }
        return chainIterable;
    }

    @NotNull
    static ChainIterable<String> describeClass(@NotNull PyClass cls, @NotNull Function<? super String, String> escapedNameMapper, @NotNull @NotNull Function<@NotNull ? super String, @NotNull String> escaper, boolean link, boolean linkAncestors, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (escapedNameMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(35);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(37);
        }
        ChainIterable<String> result = new ChainIterable<String>();
        String name = escapedNameMapper.apply(escaper.apply(StringUtil.notNullize((String)cls.getName(), (String)"<unnamed>")));
        result.addItem(escaper.apply("class "));
        result.addItem(link ? PyDocumentationLink.toContainingClass(name) : name);
        PyExpression[] superClasses = cls.getSuperClassExpressions();
        if (superClasses.length > 0) {
            result.addItem(escaper.apply("("));
            boolean isNotFirst = false;
            for (PyExpression superClass : superClasses) {
                if (isNotFirst) {
                    result.addItem(escaper.apply(", "));
                } else {
                    isNotFirst = true;
                }
                result.addItem(PythonDocumentationProvider.describeSuperClass(superClass, escaper, linkAncestors, context));
            }
            result.addItem(escaper.apply(")"));
        }
        ChainIterable<String> chainIterable = result;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(38);
        }
        return chainIterable;
    }

    @NotNull
    private static String describeSuperClass(@NotNull PyExpression expression, @NotNull Function<? super String, String> escaper, boolean link, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(39);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(40);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (link) {
            PyCallExpression callExpression;
            PyExpression callee;
            if (expression instanceof PyReferenceExpression) {
                PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                if (!referenceExpression.isQualified()) {
                    PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
                    for (ResolveResult result : referenceExpression.getReference(resolveContext).multiResolve(false)) {
                        String qualifiedName;
                        PsiElement element = result.getElement();
                        if (!(element instanceof PyClass) || (qualifiedName = ((PyClass)element).getQualifiedName()) == null) continue;
                        String string = PyDocumentationLink.toPossibleClass(escaper.apply(expression.getText()), qualifiedName, element, context);
                        if (string == null) {
                            PythonDocumentationProvider.$$$reportNull$$$0(42);
                        }
                        return string;
                    }
                }
            } else if (expression instanceof PySubscriptionExpression) {
                PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
                PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
                if (indexExpression != null) {
                    String string = PythonDocumentationProvider.describeSuperClass(operand, escaper, true, context) + escaper.apply("[") + PythonDocumentationProvider.describeSuperClass(indexExpression, escaper, true, context) + escaper.apply("]");
                    if (string == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(43);
                    }
                    return string;
                }
            } else if (expression instanceof PyKeywordArgument) {
                String keyword = ((PyKeywordArgument)expression).getKeyword();
                PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
                if ("metaclass".equals(keyword) && valueExpression != null) {
                    String string = escaper.apply("metaclass=") + PythonDocumentationProvider.describeSuperClass(valueExpression, escaper, true, context);
                    if (string == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(44);
                    }
                    return string;
                }
            } else if (PyClassImpl.isSixWithMetaclassCall(expression) && (callee = (callExpression = (PyCallExpression)expression).getCallee()) != null) {
                String string = StreamEx.of((Object[])callExpression.getArguments()).map(argument -> PythonDocumentationProvider.describeSuperClass(argument, escaper, true, context)).joining((CharSequence)escaper.apply(", "), (CharSequence)escaper.apply(callee.getText() + "("), (CharSequence)escaper.apply(")"));
                if (string == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(45);
                }
                return string;
            }
        }
        String string = escaper.apply(expression.getText());
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    private static Iterable<String> describeDecorator(@NotNull PyDecorator decorator, @NotNull Function<String, String> escapedCalleeMapper, @NotNull @NotNull Function<@NotNull String, @NotNull String> escaper) {
        if (decorator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(48);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(49);
        }
        ChainIterable<String> result = new ChainIterable<String>();
        result.addItem(escaper.apply("@")).addItem(escapedCalleeMapper.apply(escaper.apply(PyUtil.getReadableRepr((PsiElement)decorator.getCallee(), false))));
        PyArgumentList argumentList = decorator.getArgumentList();
        if (argumentList != null) {
            result.addItem(escaper.apply(PyUtil.getReadableRepr((PsiElement)argumentList, false)));
        }
        ChainIterable<String> chainIterable = result;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(50);
        }
        return chainIterable;
    }

    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        PythonRuntimeService runtimeService;
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(51);
        }
        if ((runtimeService = PythonRuntimeService.getInstance()).isInPydevConsole(element) || originalElement != null && runtimeService.isInPydevConsole(originalElement)) {
            return runtimeService.createPydevDoc(element, originalElement);
        }
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(52);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(53);
        }
        return PyDocumentationLink.elementForLink(link, context, TypeEvalContext.userInitiated(context.getProject(), context.getContainingFile()));
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url = PythonDocumentationProvider.getOnlyUrlFor(element, originalElement);
        return url == null ? null : Collections.singletonList(url);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(54);
        }
        if (file == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(55);
        }
        if (contextElement != null) {
            PyDocStringOwner docstringOwner;
            PsiReference reference;
            PyExpression callee;
            PyExpression expression;
            IElementType elementType = contextElement.getNode().getElementType();
            if (PythonDialectsTokenSetProvider.getInstance().getKeywordTokens().contains(elementType)) {
                return contextElement;
            }
            PsiElement parent = contextElement.getParent();
            if (parent instanceof PyArgumentList && (PyTokenTypes.LPAR == elementType || PyTokenTypes.RPAR == elementType) && (expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyCallExpression.class)) != null && (callee = expression.getCallee()) != null && (reference = callee.getReference()) != null) {
                return reference.resolve();
            }
            expression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyExpression.class);
            if (expression != null && DocStringUtil.isDocStringExpression(expression) && (docstringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyDocStringOwner.class)) != null) {
                return docstringOwner;
            }
        }
        return null;
    }

    private static void appendWithTags(@NotNull StringBuilder result, @NotNull String escapedContent, String ... tags) {
        if (result == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(56);
        }
        if (escapedContent == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(57);
        }
        if (tags == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(58);
        }
        for (String tag : tags) {
            result.append("<").append(tag).append(">");
        }
        result.append(escapedContent);
        for (int i = tags.length - 1; i >= 0; --i) {
            result.append("</").append(tags[i]).append(">");
        }
    }

    @NotNull
    private static String escaped(@NotNull String unescaped) {
        if (unescaped == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(59);
        }
        String string = StringUtil.escapeXmlEntities((String)unescaped);
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    private static String formatTypeWithLinks(@Nullable PyType type, @Nullable PyTypedElement typeOwner, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(62);
        }
        ChainIterable<String> holder = new ChainIterable<String>();
        PythonDocumentationProvider.describeTypeWithLinks(type, typeOwner, context, anchor, holder);
        String string = holder.toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Nullable
    public static QualifiedName getFullQualifiedName(@Nullable PsiElement element) {
        String name;
        String string = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (name = element != null ? element.getText() : null);
        if (name != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(element);
            if (owner instanceof PyClass) {
                QualifiedName importQName = QualifiedNameFinder.findCanonicalImportPath(element, element);
                if (importQName != null) {
                    return QualifiedName.fromDottedString((String)(importQName.toString() + "." + owner.getName() + "." + name));
                }
            } else if (PyUtil.isInitOrNewMethod((PsiElement)owner)) {
                QualifiedName importQName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)owner, element);
                if (importQName != null) {
                    return QualifiedName.fromDottedString((String)(importQName.toString() + "." + ((PyFunction)owner).getContainingClass().getName() + "." + name));
                }
            } else if (owner instanceof PyFile) {
                QualifiedName fileQName;
                if (builtinCache.isBuiltin(element)) {
                    return QualifiedName.fromDottedString((String)name);
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null) {
                    return QualifiedName.fromDottedString((String)(fileQName.toString() + "." + name));
                }
            } else if (element instanceof PyFile) {
                return QualifiedNameFinder.findCanonicalImportPath(element, element);
            }
        }
        return null;
    }

    @Nullable
    protected static PsiFileSystemItem getFile(PsiElement element) {
        PsiFileSystemItem file = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        return (PsiFileSystemItem)PyUtil.turnInitIntoDir((PsiElement)file);
    }

    @Nullable
    public static PsiNamedElement getNamedElement(@Nullable PsiElement element) {
        Object namedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        PyClass containingClass = PyUtil.turnConstructorIntoClass(PyUtil.as(namedElement, PyFunction.class));
        namedElement = containingClass != null ? containingClass : (PsiNamedElement)PyUtil.turnInitIntoDir((PsiElement)namedElement);
        return namedElement;
    }

    @Nullable
    public static String getOnlyUrlFor(PsiElement element, PsiElement originalElement) {
        PsiFileSystemItem file = PythonDocumentationProvider.getFile(element);
        if (file == null) {
            return null;
        }
        Sdk sdk = PyBuiltinCache.findSdkForFile(file);
        if (sdk == null) {
            return null;
        }
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName == null) {
            return null;
        }
        PythonDocumentationMap map2 = PythonDocumentationMap.getInstance();
        String pyVersion = PythonDocumentationProvider.pyVersion(sdk.getVersionString());
        PsiNamedElement namedElement = PythonDocumentationProvider.getNamedElement(element);
        String url = map2.urlFor(qName, namedElement, pyVersion);
        if (url != null) {
            return url;
        }
        for (PythonDocumentationLinkProvider provider : PythonDocumentationLinkProvider.EP_NAME.getExtensionList()) {
            String providerUrl = provider.getExternalDocumentationUrl(element, originalElement);
            if (providerUrl == null) continue;
            return providerUrl;
        }
        return null;
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String version;
        int dot;
        String prefix = "Python ";
        if (versionString != null && versionString.startsWith("Python ") && (dot = (version = versionString.substring("Python ".length())).indexOf(46)) > 0) {
            if ((dot = version.indexOf(46, dot + 1)) > 0) {
                return version.substring(0, dot);
            }
            return version;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 60: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 60: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 37: 
            case 41: 
            case 53: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 13: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: 
            case 30: 
            case 36: 
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 22: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 29: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCalleeMapper";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedNameMapper";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedContent";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescaped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describeParameter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunctionWithTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDescription";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeModel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorators";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "describeClass";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "describeSuperClass";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorator";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "escaped";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeWithLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringSummary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "describeFunction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "describeTarget";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 60: 
            case 63: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "describeParameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "describeFunctionWithTypes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "describeExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeWithLinks";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescription";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeModel";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorators";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "describeClass";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "describeSuperClass";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorator";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "appendWithTags";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "escaped";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeWithLinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 20: 
            case 25: 
            case 27: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 60: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

