/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.array.AbstractDataViewTable;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDataViewerPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(PyDataViewerPanel.class);
    protected final Project myProject;
    @NotNull
    protected final PyFrameAccessor myFrameAccessor;
    private EditorTextField mySliceTextField;
    protected AbstractDataViewTable myTable;
    private EditorTextField myFormatTextField;
    private JPanel myMainPanel;
    private JBLabel myErrorLabel;
    private JBScrollPane myScrollPane;
    protected JPanel bottomPanel;
    private boolean myColored;
    List<Listener> myListeners;
    @NlsSafe
    private String myOriginalVarName;
    private String myModifiedVarName;
    private static final String MODIFIED_VARIABLE_FORMAT = "%s*";
    protected PyDebugValue myDebugValue;
    private boolean myModified;

    public PyDataViewerPanel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor) {
        if (project == null) {
            PyDataViewerPanel.$$$reportNull$$$0(0);
        }
        if (frameAccessor == null) {
            PyDataViewerPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myModified = false;
        this.myProject = project;
        this.myFrameAccessor = frameAccessor;
        this.$$$setupUI$$$();
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.setBorder(JBUI.Borders.empty((int)5));
        this.add((Component)this.myMainPanel, "Center");
        this.myColored = PropertiesComponent.getInstance((Project)this.myProject).getBoolean("python.debugger.dataview.coloredbydefault", true);
        this.myListeners = new CopyOnWriteArrayList<Listener>();
        this.setupChangeListener();
    }

    private void setupChangeListener() {
        this.myFrameAccessor.addFrameListener(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.updateModel()));
    }

    private void updateModel() {
        AsyncArrayTableModel model = this.getModel();
        if (model == null) {
            return;
        }
        model.invalidateCache();
        if (this.isModified()) {
            this.apply(this.getModifiedVarName(), true);
        } else {
            this.updateDebugValue(model);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.isShowing()) {
                    model.fireTableDataChanged();
                }
            });
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    private void updateDebugValue(@NotNull AsyncArrayTableModel model) {
        PyDebugValue oldValue;
        if (model == null) {
            PyDataViewerPanel.$$$reportNull$$$0(2);
        }
        if ((oldValue = model.getDebugValue()) != null && !oldValue.isTemporary() || this.mySliceTextField.getText().isEmpty()) {
            return;
        }
        PyDebugValue newValue = this.getDebugValue(this.mySliceTextField.getText(), false, false);
        if (newValue != null) {
            model.setDebugValue(newValue);
        }
    }

    public String getOriginalVarName() {
        return this.myOriginalVarName;
    }

    public String getModifiedVarName() {
        return this.myModifiedVarName;
    }

    @NotNull
    public PyFrameAccessor getFrameAccessor() {
        PyFrameAccessor pyFrameAccessor = this.myFrameAccessor;
        if (pyFrameAccessor == null) {
            PyDataViewerPanel.$$$reportNull$$$0(3);
        }
        return pyFrameAccessor;
    }

    public AbstractDataViewTable getTable() {
        return this.myTable;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    protected AbstractDataViewTable createMainTable() {
        return new JBTableWithRowHeaders(PropertiesComponent.getInstance((Project)this.myProject).getBoolean("python.debugger.dataview.autoresize", true));
    }

    protected void createUIComponents() {
        this.mySliceTextField = this.createEditorField();
        this.mySliceTextField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.addCompletion();
        this.myFormatTextField = this.createEditorField();
        this.myFormatTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
        this.myTable = this.createMainTable();
        this.myScrollPane = this.myTable.getScrollPane();
    }

    private void addCompletion() {
        new PyDataViewCompletionProvider().apply(this.mySliceTextField);
    }

    @NotNull
    private EditorTextField createEditorField() {
        return new EditorTextField(EditorFactory.getInstance().createDocument((CharSequence)""), this.myProject, (FileType)PythonFileType.INSTANCE, false, true){

            protected EditorEx createEditor() {
                EditorEx editor2 = super.createEditor();
                editor2.getContentComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            PyDataViewerPanel.this.apply(PyDataViewerPanel.this.mySliceTextField.getText(), false);
                        }
                    }
                });
                return editor2;
            }
        };
    }

    public void apply(String name, boolean modifier) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PyDebugValue debugValue = this.getDebugValue(name, true, modifier);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (debugValue != null) {
                    this.apply(debugValue, modifier);
                }
            });
        });
    }

    public void apply(@NotNull PyDebugValue debugValue, boolean modifier) {
        if (debugValue == null) {
            PyDataViewerPanel.$$$reportNull$$$0(4);
        }
        this.myErrorLabel.setVisible(false);
        String type = debugValue.getType();
        DataViewStrategy strategy = DataViewStrategy.getStrategy(type);
        if (strategy == null) {
            this.setError(PyBundle.message("debugger.data.view.type.is.not.supported", type), modifier);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.doStrategyInitExecution(debugValue.getFrameAccessor(), strategy);
                ArrayChunk arrayChunk = debugValue.getFrameAccessor().getArrayItems(debugValue, 0, 0, 0, 0, this.getFormat());
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.updateUI(arrayChunk, debugValue, strategy, modifier);
                    this.myModified = modifier;
                    this.myDebugValue = debugValue;
                });
            }
            catch (IllegalArgumentException e) {
                ApplicationManager.getApplication().invokeLater(() -> this.setError(e.getLocalizedMessage(), modifier));
            }
            catch (PyDebuggerException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    protected void doStrategyInitExecution(PyFrameAccessor frameAccessor, DataViewStrategy strategy) throws PyDebuggerException {
    }

    private void updateUI(@NotNull ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, @NotNull DataViewStrategy strategy, boolean modifier) {
        if (chunk == null) {
            PyDataViewerPanel.$$$reportNull$$$0(5);
        }
        if (originalDebugValue == null) {
            PyDataViewerPanel.$$$reportNull$$$0(6);
        }
        if (strategy == null) {
            PyDataViewerPanel.$$$reportNull$$$0(7);
        }
        PyDebugValue debugValue = chunk.getValue();
        AsyncArrayTableModel model = strategy.createTableModel(chunk.getRows(), chunk.getColumns(), this, debugValue);
        model.addToCache(chunk);
        UIUtil.invokeLaterIfNeeded(() -> {
            String realName;
            this.myTable.setModel(model, modifier);
            String shownName = realName = debugValue.getName().equals(originalDebugValue.getTempName()) ? originalDebugValue.getName() : chunk.getSlicePresentation();
            if (modifier && !this.myOriginalVarName.equals(shownName)) {
                shownName = String.format(MODIFIED_VARIABLE_FORMAT, this.myOriginalVarName);
            } else {
                this.myOriginalVarName = realName;
            }
            this.mySliceTextField.setText(this.myOriginalVarName);
            this.myModifiedVarName = realName;
            if (this.mySliceTextField.getEditor() != null) {
                this.mySliceTextField.getCaretModel().moveToOffset(this.myOriginalVarName.length());
            }
            for (Listener listener2 : this.myListeners) {
                listener2.onNameChanged(shownName);
            }
            this.myFormatTextField.setText(chunk.getFormat());
            ColoredCellRenderer cellRenderer = strategy.createCellRenderer(Double.MIN_VALUE, Double.MAX_VALUE, chunk);
            cellRenderer.setColored(this.myColored);
            ((AsyncArrayTableModel)this.myTable.getModel()).fireTableDataChanged();
            ((AsyncArrayTableModel)this.myTable.getModel()).fireTableCellUpdated(0, 0);
            if (this.myTable.getColumnCount() > 0) {
                this.myTable.setDefaultRenderer(this.myTable.getColumnClass(0), cellRenderer);
            }
            this.myTable.setShowColumns(strategy.showColumnHeader());
        });
    }

    private PyDebugValue getDebugValue(@NlsSafe String expression, boolean pooledThread, boolean modifier) {
        try {
            PyDebugValue value = this.myFrameAccessor.evaluate(expression, false, true);
            if (value == null || value.isErrorOnEval()) {
                Runnable runnable = () -> this.setError(value != null ? value.getValue() : PyBundle.message("debugger.data.view.failed.to.evaluate.expression", expression), modifier);
                if (pooledThread) {
                    ApplicationManager.getApplication().invokeLater(runnable);
                } else {
                    runnable.run();
                }
                return null;
            }
            return value;
        }
        catch (PyDebuggerException e) {
            Runnable runnable = () -> this.setError(e.getTracebackError(), modifier);
            if (pooledThread) {
                ApplicationManager.getApplication().invokeLater(runnable);
            } else {
                runnable.run();
            }
            return null;
        }
    }

    public void resize(boolean autoResize) {
        this.myTable.setAutoResize(autoResize);
        this.apply(this.getSliceTextField().getText(), false);
    }

    private void setError(@NlsContexts.Label String text2, boolean modifier) {
        if (modifier) {
            text2 = PyBundle.message("debugger.dataviewer.modifier.error", text2);
        }
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setText(text2);
        if (!modifier) {
            this.myTable.setEmpty();
            for (Listener listener2 : this.myListeners) {
                listener2.onNameChanged(PyBundle.message("debugger.data.view.empty.tab", new Object[0]));
            }
        }
    }

    public String getFormat() {
        String format = this.myFormatTextField.getText();
        return format.isEmpty() ? "%" : format;
    }

    public boolean isColored() {
        return this.myColored;
    }

    public void setColored(boolean state2) {
        this.myColored = state2;
        if (!this.myTable.isEmpty()) {
            ((ColoredCellRenderer)this.myTable.getDefaultRenderer(this.myTable.getColumnClass(0))).setColored(state2);
        }
    }

    public EditorTextField getSliceTextField() {
        return this.mySliceTextField;
    }

    @Nullable
    public AsyncArrayTableModel getModel() {
        TableModel model = this.myTable.getModel();
        if (model instanceof AsyncArrayTableModel) {
            return (AsyncArrayTableModel)this.myTable.getModel();
        }
        return null;
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void closeEditorTabs() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDebugValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDebugValue";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = this.myScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(0, 330), null));
        EditorTextField editorTextField = this.mySliceTextField;
        editorTextField.setToolTipText(ResourceBundle.getBundle("messages/PyBundle").getString("form.data.viewer.current.slice"));
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.bottomPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 0, 0, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, true));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyDataViewerPanel.class).getString("form.data.viewer.format"));
        jLabel.setVerticalAlignment(3);
        jLabel.setVerticalTextPosition(3);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myFormatTextField;
        editorTextField2.setToolTipText(ResourceBundle.getBundle("messages/PyBundle").getString("form.data.viewer.dialog.show.svn.map.table.header.column.format.title"));
        jPanel3.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(70, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 1, new Dimension(10, -1), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class PyDataViewCompletionProvider
    extends TextFieldCompletionProvider {
        private PyDataViewCompletionProvider() {
        }

        protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text2 == null) {
                PyDataViewCompletionProvider.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                PyDataViewCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PyDataViewCompletionProvider.$$$reportNull$$$0(2);
            }
            List<PyDebugValue> values = this.getAvailableValues();
            values.sort(Comparator.comparing(XNamedValue::getName));
            for (int i = 0; i < values.size(); ++i) {
                PyDebugValue value = values.get(i);
                LookupElementBuilder element = LookupElementBuilder.create((String)value.getName()).withTypeText(value.getType(), true);
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)(-i)));
            }
        }

        private List<PyDebugValue> getAvailableValues() {
            ArrayList<PyDebugValue> values = new ArrayList<PyDebugValue>();
            try {
                XValueChildrenList list = PyDataViewerPanel.this.myFrameAccessor.loadFrame();
                if (list == null) {
                    return values;
                }
                for (int i = 0; i < list.size(); ++i) {
                    PyDebugValue value = (PyDebugValue)list.getValue(i);
                    String type = value.getType();
                    if (DataViewStrategy.getStrategy(type) == null) continue;
                    values.add(value);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return values;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider";
            objectArray[2] = "addCompletionVariants";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        public void onNameChanged(@NlsContexts.TabTitle String var1);
    }
}

