/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.imports.PyRelativeImportData;
import com.jetbrains.python.codeInsight.intentions.PyConvertImportIntentionAction;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/codeInsight/intentions/PyAbsoluteToRelativeImportIntention;", "Lcom/jetbrains/python/codeInsight/intentions/PyConvertImportIntentionAction;", "()V", "doInvoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "intellij.python.psi.impl"})
public final class PyAbsoluteToRelativeImportIntention
extends PyConvertImportIntentionAction {
    @Override
    public void doInvoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PyFromImportStatement pyFromImportStatement = this.findStatement(file, editor2);
        if (pyFromImportStatement == null) {
            return;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        QualifiedName qualifiedName = statement.getImportSourceQName();
        if (qualifiedName == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"statement.importSourceQName ?: return");
        QualifiedName targetPath = qualifiedName;
        String string = targetPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetPath.toString()");
        PyRelativeImportData pyRelativeImportData = PyRelativeImportData.Companion.fromString(string, (PyFile)file);
        if (pyRelativeImportData == null) {
            return;
        }
        PyRelativeImportData importData = pyRelativeImportData;
        this.replaceImportStatement(statement, file, importData.getLocationWithDots());
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyFromImportStatement pyFromImportStatement = this.findStatement(file, editor2);
        if (pyFromImportStatement == null) {
            return false;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        if (statement.getRelativeLevel() != 0) {
            return false;
        }
        QualifiedName qualifiedName = statement.getImportSourceQName();
        if (qualifiedName == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"statement.importSourceQName ?: return false");
        QualifiedName targetPath = qualifiedName;
        QualifiedName qualifiedName2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, null);
        if (qualifiedName2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"QualifiedNameFinder.find\u2026le, null) ?: return false");
        QualifiedName filePath = qualifiedName2;
        return Intrinsics.areEqual((Object)targetPath.getFirstComponent(), (Object)filePath.getFirstComponent());
    }

    public PyAbsoluteToRelativeImportIntention() {
        super("INTN.convert.absolute.to.relative");
    }
}

