/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public PyHighlightExitPointsHandler(Editor editor2, PsiFile file, PsiElement target) {
        super(editor2, file);
        this.myTarget = target;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            PyHighlightExitPointsHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            PyHighlightExitPointsHandler.$$$reportNull$$$0(1);
        }
        if (selectionConsumer == null) {
            PyHighlightExitPointsHandler.$$$reportNull$$$0(2);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiElement parent;
        if (targets == null) {
            PyHighlightExitPointsHandler.$$$reportNull$$$0(3);
        }
        if (!((parent = this.myTarget.getParent()) instanceof PyReturnStatement)) {
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, PyFunction.class);
        if (function == null) {
            return;
        }
        this.highlightExitPoints((PyReturnStatement)parent, function);
    }

    @Nullable
    private static PsiElement getExitTarget(PsiElement exitStatement) {
        if (exitStatement instanceof PyReturnStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)exitStatement, PyFunction.class);
        }
        if (exitStatement instanceof PyBreakStatement) {
            return ((PyBreakStatement)exitStatement).getLoopStatement();
        }
        if (exitStatement instanceof PyContinueStatement) {
            return ((PyContinueStatement)exitStatement).getLoopStatement();
        }
        if (exitStatement instanceof PyRaiseStatement) {
            return null;
        }
        return null;
    }

    private void highlightExitPoints(PyReturnStatement statement, PyFunction function) {
        ControlFlow flow = ControlFlowCache.getControlFlow(function);
        Collection<PsiElement> exitStatements = PyHighlightExitPointsHandler.findExitPointsAndStatements(flow);
        if (!exitStatements.contains(statement)) {
            return;
        }
        PsiElement originalTarget = PyHighlightExitPointsHandler.getExitTarget((PsiElement)statement);
        for (PsiElement exitStatement : exitStatements) {
            if (PyHighlightExitPointsHandler.getExitTarget(exitStatement) != originalTarget) continue;
            this.addOccurrence(exitStatement);
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{exitStatements.size(), HighlightUsagesHandler.getShortcutText()});
    }

    private static Collection<PsiElement> findExitPointsAndStatements(ControlFlow flow) {
        ArrayList<PsiElement> statements = new ArrayList<PsiElement>();
        Instruction[] instructions = flow.getInstructions();
        for (Instruction instruction : instructions[instructions.length - 1].allPred()) {
            PsiElement statement;
            PsiElement element = instruction.getElement();
            if (element == null || (statement = PyPsiUtils.getStatement(element)) == null) continue;
            statements.add(statement);
        }
        return statements;
    }

    @Nullable
    public String getFeatureId() {
        return super.getFeatureId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/highlighting/PyHighlightExitPointsHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/highlighting/PyHighlightExitPointsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

