/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u0002H\u00012\b\u0012\u0004\u0012\u0002H\u00030\u0004B)\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeDataHolderImpl;", "T", "", "MUTABLE_SCHEME", "Lcom/intellij/configurationStore/SchemeDataHolder;", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "bytes", "", "externalInfo", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "(Lcom/intellij/openapi/options/SchemeProcessor;[BLcom/intellij/configurationStore/schemeManager/ExternalInfo;)V", "read", "Lorg/jdom/Element;", "updateDigest", "", "scheme", "(Ljava/lang/Object;)V", "data", "intellij.platform.configurationStore.impl"})
public final class SchemeDataHolderImpl<T, MUTABLE_SCHEME extends T>
implements SchemeDataHolder<MUTABLE_SCHEME> {
    private final SchemeProcessor<T, MUTABLE_SCHEME> processor;
    private final byte[] bytes;
    private final ExternalInfo externalInfo;

    @NotNull
    public Element read() {
        try {
            byte[] byArray = this.bytes;
            boolean bl = false;
            Element element = JDOMUtil.load((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)new ByteArrayInputStream(byArray)));
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"JDOMUtil.load(CharsetToo\u2026BOM(bytes.inputStream()))");
            return element;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Cannot read " + this.externalInfo.getFileName(), e);
        }
    }

    public void updateDigest(@NotNull MUTABLE_SCHEME scheme2) {
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        try {
            Parent parent = this.processor.writeScheme(scheme2);
            if (parent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jdom.Element");
            }
            this.updateDigest((Element)parent);
        }
        catch (WriteExternalException e) {
            ComponentStoreImplKt.getLOG().error("Cannot update digest for " + this.externalInfo.getFileName(), (Throwable)e);
        }
    }

    public void updateDigest(@Nullable Element data) {
        Object object;
        block3: {
            block2: {
                object = data;
                if (object == null) break block2;
                byte[] byArray = Scheme_implKt.digest$default((Element)object, null, (int)1, null);
                object = byArray;
                if (byArray != null) break block3;
            }
            object = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        this.externalInfo.setDigest((byte[])object);
    }

    public SchemeDataHolderImpl(@NotNull SchemeProcessor<T, ? super MUTABLE_SCHEME> processor2, @NotNull byte[] bytes, @NotNull ExternalInfo externalInfo) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)externalInfo, (String)"externalInfo");
        this.processor = processor2;
        this.bytes = bytes;
        this.externalInfo = externalInfo;
    }
}

