/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.constructor;

import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.util.Accessibles;
import org.fest.reflect.util.Throwables;
import org.fest.util.Preconditions;
import org.fest.util.ToString;

public final class ConstructorInvoker<T> {
    private final Constructor<T> constructor;

    ConstructorInvoker(@Nonnull Class<T> target, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(parameterTypes);
        try {
            this.constructor = target.getDeclaredConstructor(parameterTypes);
        }
        catch (Throwable t) {
            String format = "Failed to find constructor in type %s with parameter types %s";
            String msg = String.format(format, target.getName(), ToString.toStringOf(parameterTypes));
            throw new ReflectionError(msg);
        }
    }

    public T newInstance(Object ... args) {
        Constructor<T> c = this.constructor;
        boolean accessible = this.constructor.isAccessible();
        try {
            Accessibles.makeAccessible(c);
            T t = c.newInstance(args);
            return t;
        }
        catch (Throwable t) {
            Throwable cause = Throwables.targetOf(t);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionError("Unable to create a new object from the enclosed constructor", cause);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(c, accessible);
        }
    }

    @Nonnull
    public Constructor<T> target() {
        return this.constructor;
    }
}

