/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.reference.EditorConfigVirtualFileDescriptor;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceLoading;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.services.impl.EditorConfigFileHierarchyServiceImpl;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\rH\u0002J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl;", "Lorg/editorconfig/language/services/EditorConfigFileHierarchyService;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cacheDropsCount", "", "cacheLocker", "", "parentFilesCache", "Lcom/intellij/util/containers/FixedHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/lang/ref/Reference;", "", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "after", "", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "afterValueChanged", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "beforeValueChanged", "findApplicableFiles", "virtualFile", "findParentFiles", "file", "findParentPsiFiles", "getParentEditorConfigFiles", "Lorg/editorconfig/language/services/EditorConfigServiceResult;", "startBackgroundTask", "updateHandlers", "Companion", "intellij.editorconfig"})
public final class EditorConfigFileHierarchyServiceImpl
extends EditorConfigFileHierarchyService
implements BulkFileListener,
RegistryValueListener {
    private final ExecutorService taskExecutor;
    private final MergingUpdateQueue updateQueue;
    private volatile int cacheDropsCount;
    private final Object cacheLocker;
    private final FixedHashMap<VirtualFile, Reference<List<EditorConfigPsiFile>>> parentFilesCache;
    private final Project project;
    private static final Logger Log;
    private static final int CacheSize = 10;
    private static final Companion Companion;

    private final void updateHandlers(Project project) {
        this.updateQueue.queue(Update.create((Object)"editorconfig hierarchy update", (Runnable)new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                CodeStyleSettingsManager.getInstance((Project)this.$project).notifyCodeStyleSettingsChanged();
            }
            {
                this.$project = project;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        List editorConfigs2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)after.editorConfigs.1.INSTANCE));
        Object object = editorConfigs2;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = this.cacheLocker;
            bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                ++this.cacheDropsCount;
                this.parentFilesCache.clear();
                Unit unit = Unit.INSTANCE;
            }
            this.updateHandlers(this.project);
        }
    }

    public void beforeValueChanged(@NotNull RegistryValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterValueChanged(@NotNull RegistryValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = this.cacheLocker;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ++this.cacheDropsCount;
            this.parentFilesCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EditorConfigServiceResult getParentEditorConfigFiles(@NotNull VirtualFile virtualFile) {
        Reference reference;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Object object = this.cacheLocker;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            reference = (Reference)this.parentFilesCache.get((Object)virtualFile);
        }
        List cachedResult = (List)SoftReference.dereference((Reference)reference);
        if (cachedResult != null) {
            return new EditorConfigServiceLoaded(cachedResult);
        }
        this.startBackgroundTask(virtualFile);
        return EditorConfigServiceLoading.INSTANCE;
    }

    private final void startBackgroundTask(VirtualFile virtualFile) {
        int expectedCacheDropsCount = this.cacheDropsCount;
        ReadAction.nonBlocking((Callable)new Callable<List<? extends EditorConfigPsiFile>>(this, virtualFile){
            final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;
            final /* synthetic */ VirtualFile $virtualFile;

            public final List<EditorConfigPsiFile> call() {
                return EditorConfigFileHierarchyServiceImpl.access$findApplicableFiles(this.this$0, this.$virtualFile);
            }
            {
                this.this$0 = editorConfigFileHierarchyServiceImpl;
                this.$virtualFile = virtualFile;
            }
        }).expireWith((Disposable)this.project).finishOnUiThread(ModalityState.any(), (Consumer)new Consumer<List<? extends EditorConfigPsiFile>>(this, expectedCacheDropsCount, virtualFile){
            final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;
            final /* synthetic */ int $expectedCacheDropsCount;
            final /* synthetic */ VirtualFile $virtualFile;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(List<EditorConfigPsiFile> affectingFiles) {
                if (affectingFiles == null) {
                    return;
                }
                Object object = EditorConfigFileHierarchyServiceImpl.access$getCacheLocker$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (this.$expectedCacheDropsCount != EditorConfigFileHierarchyServiceImpl.access$getCacheDropsCount$p(this.this$0)) {
                        return;
                    }
                    ((Map)EditorConfigFileHierarchyServiceImpl.access$getParentFilesCache$p(this.this$0)).put(this.$virtualFile, new SoftReference(affectingFiles));
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = editorConfigFileHierarchyServiceImpl;
                this.$expectedCacheDropsCount = n;
                this.$virtualFile = virtualFile;
            }
        }).submit((Executor)this.taskExecutor);
    }

    private final List<EditorConfigPsiFile> findApplicableFiles(VirtualFile virtualFile) {
        List<EditorConfigPsiFile> list;
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        Log.assertTrue(!application.isDispatchThread());
        app.assertReadAccessAllowed();
        if (!EditorConfigRegistry.shouldStopAtProjectRoot()) {
            list = this.findParentPsiFiles(virtualFile);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026rtualFile) ?: return null");
            list = EditorConfigPsiTreeUtil.INSTANCE.findAllParentsFiles(psiFile);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigPsiFile> findParentPsiFiles(VirtualFile file) {
        int firstRoot;
        Sequence parents2;
        int expectedCacheDropsCount;
        block8: {
            int n;
            Sequence sequence;
            block10: {
                block9: {
                    void $this$sortedBy$iv;
                    Application app;
                    Application application = app = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                    Log.assertTrue(!application.isDispatchThread());
                    app.assertReadAccessAllowed();
                    expectedCacheDropsCount = this.cacheDropsCount;
                    sequence = this.findParentFiles(file);
                    if (sequence == null || (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) == null) break block9;
                    Sequence sequence2 = sequence;
                    EditorConfigVirtualFileDescriptor editorConfigVirtualFileDescriptor = new EditorConfigVirtualFileDescriptor(file);
                    boolean $i$f$sortedBy = false;
                    boolean bl = false;
                    sequence = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(editorConfigVirtualFileDescriptor){
                        final /* synthetic */ EditorConfigVirtualFileDescriptor receiver$0$inlined;
                        {
                            this.receiver$0$inlined = editorConfigVirtualFileDescriptor;
                        }

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            VirtualFile p1 = (VirtualFile)a;
                            boolean bl2 = false;
                            Comparable comparable = Integer.valueOf(this.receiver$0$inlined.distanceToParent(p1));
                            p1 = (VirtualFile)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Integer n = this.receiver$0$inlined.distanceToParent(p1);
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                    if (sequence != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<VirtualFile, EditorConfigPsiFile>(this){
                        final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;

                        @Nullable
                        public final EditorConfigPsiFile invoke(@NotNull VirtualFile it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            PsiFile psiFile = PsiManager.getInstance((Project)EditorConfigFileHierarchyServiceImpl.access$getProject$p(this.this$0)).findFile(it);
                            if (!(psiFile instanceof EditorConfigPsiFile)) {
                                psiFile = null;
                            }
                            return (EditorConfigPsiFile)psiFile;
                        }
                        {
                            this.this$0 = editorConfigFileHierarchyServiceImpl;
                            super(1);
                        }
                    }))) != null) break block10;
                }
                return null;
            }
            Sequence $this$indexOfFirst$iv = parents2 = sequence;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                boolean bl = false;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object receiver = item$iv;
                boolean bl2 = false;
                if (((EditorConfigPsiFile)((Object)receiver)).getHasValidRootDeclaration()) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = firstRoot = -1;
        }
        if (this.cacheDropsCount != expectedCacheDropsCount) {
            return null;
        }
        ProgressManager.checkCanceled();
        return firstRoot < 0 ? SequencesKt.toList((Sequence)parents2) : SequencesKt.toList((Sequence)SequencesKt.take((Sequence)parents2, (int)(firstRoot + 1)));
    }

    private final List<VirtualFile> findParentFiles(VirtualFile file) {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        Log.assertTrue(!application.isDispatchThread());
        app.assertReadAccessAllowed();
        String fileName = ".editorconfig";
        int expectedCacheDropsCount = this.cacheDropsCount;
        boolean bl = false;
        List result2 = new ArrayList();
        for (VirtualFile currentFolder = file.getParent(); currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (this.cacheDropsCount != expectedCacheDropsCount) {
                return null;
            }
            ProgressManager.checkCanceled();
            VirtualFile child = currentFolder.findChild(fileName);
            if (child == null || child.isDirectory()) continue;
            result2.add(child);
        }
        return result2;
    }

    public EditorConfigFileHierarchyServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"EditorConfig.notification.vfs.update.executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026ion.vfs.update.executor\")");
        this.taskExecutor = executorService;
        this.updateQueue = new MergingUpdateQueue("EditorConfigFileHierarchy UpdateQueue", 500, true, null, (Disposable)this.project);
        this.cacheLocker = new Object();
        this.parentFilesCache = new FixedHashMap(10);
        DumbService.getInstance((Project)this.project).runWhenSmart(new Runnable(){

            @Override
            public final void run() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                application.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
            }
        });
        Registry.get((String)"editor.config.stop.at.project.root").addListener((RegistryValueListener)this, (Disposable)this.project);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigFileHierarchyService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Log = logger;
    }

    public static final /* synthetic */ List access$findApplicableFiles(EditorConfigFileHierarchyServiceImpl $this, VirtualFile virtualFile) {
        return $this.findApplicableFiles(virtualFile);
    }

    public static final /* synthetic */ Object access$getCacheLocker$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.cacheLocker;
    }

    public static final /* synthetic */ int access$getCacheDropsCount$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.cacheDropsCount;
    }

    public static final /* synthetic */ void access$setCacheDropsCount$p(EditorConfigFileHierarchyServiceImpl $this, int n) {
        $this.cacheDropsCount = n;
    }

    public static final /* synthetic */ FixedHashMap access$getParentFilesCache$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.parentFilesCache;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl$Companion;", "", "()V", "CacheSize", "", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.editorconfig"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

