/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(@NotNull AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        if (fieldUpdater == null) {
            PromiseManager.$$$reportNull$$$0(0);
        }
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(@NotNull Class<HOST> ownerClass) {
        if (ownerClass == null) {
            PromiseManager.$$$reportNull$$$0(1);
        }
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        if (host == null) {
            PromiseManager.$$$reportNull$$$0(2);
        }
        if (value == null) {
            PromiseManager.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public abstract Promise<VALUE> load(@NotNull HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value);
        }
    }

    public final boolean has(HOST host) {
        Promise result = (Promise)this.fieldUpdater.get(host);
        return result != null && result.isSucceeded();
    }

    @Nullable
    public final Promise.State getState(HOST host) {
        Promise result = (Promise)this.fieldUpdater.get(host);
        return result == null ? null : result.getState();
    }

    @NotNull
    public final Promise<VALUE> get(HOST host) {
        return this.get(host, true);
    }

    @NotNull
    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    @NotNull
    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load) {
        AsyncPromise promise = (AsyncPromise)this.fieldUpdater.get(host);
        if (promise == null) {
            promise = new AsyncPromise();
            promise.onError(ignored -> {});
            if (!this.fieldUpdater.compareAndSet(host, null, promise)) {
                Promise promise2 = (Promise)this.fieldUpdater.get(host);
                if (promise2 == null) {
                    PromiseManager.$$$reportNull$$$0(4);
                }
                return promise2;
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                AsyncPromise asyncPromise = promise;
                if (asyncPromise == null) {
                    PromiseManager.$$$reportNull$$$0(5);
                }
                return asyncPromise;
            }
            if (state == Promise.State.SUCCEEDED) {
                block14: {
                    AsyncPromise asyncPromise;
                    try {
                        if (checkFreshness && !this.isUpToDate(host, promise.blockingGet(0))) break block14;
                        asyncPromise = promise;
                    }
                    catch (ExecutionException | TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                    if (asyncPromise == null) {
                        PromiseManager.$$$reportNull$$$0(6);
                    }
                    return asyncPromise;
                }
                if (!this.fieldUpdater.compareAndSet(host, promise, promise = new AsyncPromise())) {
                    Promise valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, promise)) {
                            return this.getPromise(host, load, promise);
                        }
                        valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    }
                    Promise promise3 = valueFromAnotherThread;
                    if (promise3 == null) {
                        PromiseManager.$$$reportNull$$$0(7);
                    }
                    return promise3;
                }
            }
        }
        return this.getPromise(host, load, promise);
    }

    @NotNull
    private Promise<VALUE> getPromise(HOST host, boolean load, Promise<VALUE> promise) {
        if (!load || promise.getState() != Promise.State.PENDING) {
            Promise<VALUE> promise2 = promise;
            if (promise2 == null) {
                PromiseManager.$$$reportNull$$$0(8);
            }
            return promise2;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise) {
            this.fieldUpdater.compareAndSet(host, promise, effectivePromise);
            effectivePromise.processed(promise);
        }
        Promise<VALUE> promise3 = effectivePromise;
        if (promise3 == null) {
            PromiseManager.$$$reportNull$$$0(9);
        }
        return promise3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldUpdater";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/concurrency/PromiseManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/concurrency/PromiseManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAsyncResult";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

