/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.pivotal.PivotalTrackerRepositoryType;
import com.intellij.tasks.pivotal.PivotalTrackerTask;
import com.intellij.tasks.pivotal.model.PivotalTrackerStory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="PivotalTracker")
public class PivotalTrackerRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(PivotalTrackerRepository.class);
    private static final String API_V5_PATH = "/services/v5";
    private static final String TOKEN_HEADER = "X-TrackerToken";
    private static final Pattern TASK_ID_REGEX = Pattern.compile("(?<projectId>\\d+)-(?<storyId>\\d+)");
    private static final List<String> STANDARD_STORY_STATES = Arrays.asList("accepted", "delivered", "finished", "started", "rejected", "planned", "unstarted", "unscheduled");
    private static final TypeToken<List<PivotalTrackerStory>> LIST_OF_STORIES_TYPE = new TypeToken<List<PivotalTrackerStory>>(){};
    public static final Gson ourGson = TaskGsonUtil.createDefaultBuilder().create();
    private String myProjectId;
    private String myAPIKey;

    public PivotalTrackerRepository() {
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
        this.myCommitMessageFormat = "[fixes #{number}] {summary}";
    }

    public PivotalTrackerRepository(PivotalTrackerRepositoryType type) {
        super((TaskRepositoryType)type);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
    }

    private PivotalTrackerRepository(PivotalTrackerRepository other) {
        super(other);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
        this.setProjectId(other.myProjectId);
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        return API_V5_PATH;
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader(PivotalTrackerRepository.TOKEN_HEADER, PivotalTrackerRepository.this.getPassword());
            }
        };
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void doTest() throws Exception {
                this.myCurrentRequest = PivotalTrackerRepository.this.createStoriesRequest("", 0, 10, false);
                super.doTest();
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getProjectId()) && StringUtil.isNotEmpty((String)this.getPassword());
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List stories = (List)this.getHttpClient().execute((HttpUriRequest)this.createStoriesRequest(query, offset, limit, withClosed), new TaskResponseUtil.GsonMultipleObjectsDeserializer<PivotalTrackerStory>(ourGson, LIST_OF_STORIES_TYPE));
        return (Task[])ContainerUtil.map2Array((Collection)stories, PivotalTrackerTask.class, story -> new PivotalTrackerTask(this, (PivotalTrackerStory)story));
    }

    @NotNull
    protected HttpGet createStoriesRequest(@Nullable String query, int offset, int limit, boolean withClosed) throws URISyntaxException {
        URI endpointUrl = new URIBuilder(this.getRestApiUrl("projects", this.myProjectId, "stories")).addParameter("filter", (withClosed ? "" : "state:started,unstarted,unscheduled,rejected") + (String)(StringUtil.isEmpty((String)query) ? "" : " \"" + query + "\"")).addParameter("offset", String.valueOf(offset)).addParameter("limit", String.valueOf(limit)).build();
        return new HttpGet(endpointUrl);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        Matcher matcher;
        if (id == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(0);
        }
        if (!(matcher = TASK_ID_REGEX.matcher(id)).matches()) {
            LOG.warn("Illegal PivotalTracker ID pattern " + id);
            return null;
        }
        String projectId = matcher.group("projectId");
        String storyId = matcher.group("storyId");
        PivotalTrackerStory story = (PivotalTrackerStory)this.getHttpClient().execute((HttpUriRequest)new HttpGet(this.getRestApiUrl("projects", projectId, "stories", storyId)), new TaskResponseUtil.GsonSingleObjectDeserializer<PivotalTrackerStory>(ourGson, PivotalTrackerStory.class, true));
        return story != null ? new PivotalTrackerTask(this, story) : null;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher;
        if (taskName == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(1);
        }
        return (matcher = TASK_ID_REGEX.matcher(taskName)).matches() ? taskName : null;
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        Matcher matcher;
        if (task == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(3);
        }
        if (!(matcher = TASK_ID_REGEX.matcher(task.getId())).matches()) {
            LOG.warn("Illegal PivotalTracker ID pattern " + task.getId());
            return;
        }
        String projectId = matcher.group("projectId");
        String storyId = matcher.group("storyId");
        HttpPut request = new HttpPut(this.getRestApiUrl("projects", projectId, "stories", storyId));
        String payload = ourGson.toJson((Object)ContainerUtil.newHashMap((Pair)Pair.create((Object)"current_state", (Object)state.getId()), (Pair[])new Pair[0]));
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        this.getHttpClient().execute((HttpUriRequest)request);
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(4);
        }
        Set set = ContainerUtil.map2Set(STANDARD_STORY_STATES, name -> new CustomTaskState(name, name));
        if (set == null) {
            PivotalTrackerRepository.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public BaseRepository clone() {
        return new PivotalTrackerRepository(this);
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(String projectId) {
        this.myProjectId = projectId;
    }

    @Deprecated
    public String getAPIKey() {
        return null;
    }

    @Deprecated
    public void setAPIKey(String APIKey) {
        this.setPassword(APIKey);
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (String)(!StringUtil.isEmpty((String)this.getProjectId()) ? "/" + this.getProjectId() : "");
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof PivotalTrackerRepository)) {
            return false;
        }
        PivotalTrackerRepository that = (PivotalTrackerRepository)((Object)o);
        return !(this.getProjectId() != null ? !this.getProjectId().equals(that.getProjectId()) : that.getProjectId() != null);
    }

    protected int getFeatures() {
        return super.getFeatures() | 1 | 8;
    }

    public void setUrl(String url) {
        if (((String)url).startsWith("http:")) {
            url = "https:" + StringUtil.trimStart((String)url, (String)"http:");
        }
        super.setUrl((String)url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/pivotal/PivotalTrackerRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/pivotal/PivotalTrackerRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

