/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.relaxNG.references.AddValueCondition;
import org.intellij.plugins.relaxNG.references.AttributeValueCondition;
import org.intellij.plugins.relaxNG.references.AttributeValueFunction;
import org.intellij.plugins.relaxNG.references.ResolvingVisitor;
import org.jetbrains.annotations.NotNull;

public class IdRefProvider
extends PsiReferenceProvider {
    public static final HasIdRefTypeCondition HAS_ID_REF_TYPE = new HasIdRefTypeCondition();
    public static final HasIdTypeCondition HAS_ID_TYPE = new HasIdTypeCondition();

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlAttributeValue value;
        if (element == null) {
            IdRefProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IdRefProvider.$$$reportNull$$$0(1);
        }
        if (IdRefProvider.hasIdRefType(value = (XmlAttributeValue)element)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new IdReference(value)};
            if (psiReferenceArray == null) {
                IdRefProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (IdRefProvider.hasIdType(value)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new AttributeValueSelfReference(element)};
            if (psiReferenceArray == null) {
                IdRefProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            IdRefProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean hasIdType(XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor = ((XmlAttribute)xmlAttributeValue.getParent()).getDescriptor();
        return descriptor != null && descriptor.hasIdType();
    }

    private static boolean hasIdRefType(XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor = ((XmlAttribute)xmlAttributeValue.getParent()).getDescriptor();
        return descriptor != null && descriptor.hasIdRefType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/references/IdRefProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/references/IdRefProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class HasIdRefTypeCondition
    extends PatternCondition<XmlAttributeValue> {
        HasIdRefTypeCondition() {
            super("IdRef");
        }

        public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
            if (xmlAttributeValue == null) {
                HasIdRefTypeCondition.$$$reportNull$$$0(0);
            }
            return IdRefProvider.hasIdRefType(xmlAttributeValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/intellij/plugins/relaxNG/references/IdRefProvider$HasIdRefTypeCondition", "accepts"));
        }
    }

    static class HasIdTypeCondition
    extends PatternCondition<XmlAttributeValue> {
        HasIdTypeCondition() {
            super("IdType");
        }

        public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
            if (xmlAttributeValue == null) {
                HasIdTypeCondition.$$$reportNull$$$0(0);
            }
            return IdRefProvider.hasIdType(xmlAttributeValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/intellij/plugins/relaxNG/references/IdRefProvider$HasIdTypeCondition", "accepts"));
        }
    }

    private static class IdReference
    extends PsiReferenceBase<XmlAttributeValue> {
        private static final Key<XmlAttributeValue> TARGET = Key.create((String)"target");
        private static final Key<Set<XmlAttributeValue>> VARIANTS = Key.create((String)"variants");
        private static final XmlAttributeValuePattern PATTERN = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute())).with((PatternCondition)HAS_ID_TYPE);
        private final AttributeValueCondition myCondition;

        IdReference(XmlAttributeValue element) {
            super((PsiElement)element, TextRange.from((int)1, (int)(element.getTextLength() - 2)), true);
            this.myCondition = new AttributeValueCondition(element.getValue());
        }

        public PsiElement resolve() {
            final ProcessingContext context = new ProcessingContext();
            ResolvingVisitor visitor = new ResolvingVisitor((XmlAttributeValuePattern)((XmlAttributeValuePattern)PATTERN.with((PatternCondition)this.myCondition)).save(TARGET), context){

                @Override
                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    if (this.shouldContinue()) {
                        this.visitSubTags(tag);
                    }
                }

                @Override
                protected boolean shouldContinue() {
                    return context.get(TARGET) == null;
                }
            };
            this.process(visitor);
            return (PsiElement)context.get(TARGET);
        }

        private void process(ResolvingVisitor visitor) {
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlDocument.class);
            if (document != null) {
                visitor.execute((PsiElement)document);
            }
        }

        public Object @NotNull [] getVariants() {
            ProcessingContext context = new ProcessingContext();
            context.put(VARIANTS, new HashSet());
            ResolvingVisitor visitor = new ResolvingVisitor((XmlAttributeValuePattern)PATTERN.with(AddValueCondition.create(VARIANTS)), context){

                @Override
                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    this.visitSubTags(tag);
                }
            };
            this.process(visitor);
            Object[] objectArray = AttributeValueFunction.toStrings((Set)context.get(VARIANTS));
            if (objectArray == null) {
                IdReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/IdRefProvider$IdReference", "getVariants"));
        }
    }
}

