/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsForm;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownSettingsConfigurable
implements SearchableConfigurable {
    @Nullable
    private MarkdownSettingsForm myForm = null;
    @NotNull
    private final MarkdownApplicationSettings myMarkdownApplicationSettings = MarkdownApplicationSettings.getInstance();

    @NotNull
    public String getId() {
        return "Settings.Markdown";
    }

    @Nls
    public String getDisplayName() {
        return MarkdownBundle.message("markdown.settings.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JLabel(MarkdownBundle.message("markdown.settings.no.providers", new Object[0])), "North");
            return panel2;
        }
        return form.getComponent();
    }

    @Nullable
    public MarkdownSettingsForm getForm() {
        if (!MarkdownHtmlPanelProvider.hasAvailableProviders()) {
            return null;
        }
        if (this.myForm == null) {
            this.myForm = new MarkdownSettingsForm();
        }
        return this.myForm;
    }

    public boolean isModified() {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            return false;
        }
        return !form.getMarkdownCssSettings().equals(this.myMarkdownApplicationSettings.getMarkdownCssSettings()) || !form.getMarkdownPreviewSettings().equals(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings()) || !form.getExtensionsEnabledState().equals(this.myMarkdownApplicationSettings.getExtensionsEnabledState()) || form.isDisableInjections() != this.myMarkdownApplicationSettings.isDisableInjections() || form.isHideErrors() != this.myMarkdownApplicationSettings.isHideErrors();
    }

    public void apply() throws ConfigurationException {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            return;
        }
        form.validate();
        this.myMarkdownApplicationSettings.setMarkdownCssSettings(form.getMarkdownCssSettings());
        this.myMarkdownApplicationSettings.setMarkdownPreviewSettings(form.getMarkdownPreviewSettings());
        this.myMarkdownApplicationSettings.setDisableInjections(form.isDisableInjections());
        this.myMarkdownApplicationSettings.setHideErrors(form.isHideErrors());
        this.myMarkdownApplicationSettings.setExtensionsEnabledState(form.getExtensionsEnabledState());
        ((MarkdownApplicationSettings.SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MarkdownApplicationSettings.SettingsChangedListener.TOPIC)).settingsChanged(this.myMarkdownApplicationSettings);
    }

    public void reset() {
        MarkdownSettingsForm form = this.getForm();
        if (form == null) {
            return;
        }
        form.setMarkdownCssSettings(this.myMarkdownApplicationSettings.getMarkdownCssSettings());
        form.setMarkdownPreviewSettings(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings());
        form.setDisableInjections(this.myMarkdownApplicationSettings.isDisableInjections());
        form.setHideErrors(this.myMarkdownApplicationSettings.isHideErrors());
        form.setExtensionsEnabledState(this.myMarkdownApplicationSettings.getExtensionsEnabledState());
    }

    public void disposeUIResources() {
        if (this.myForm != null) {
            Disposer.dispose((Disposable)this.myForm);
        }
        this.myForm = null;
    }

    @NotNull
    public String getHelpTopic() {
        return "Settings.Markdown";
    }
}

