/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.TransientWindowListener;
import org.fest.swing.hierarchy.WindowFilter;
import org.fest.swing.listener.WeakEventListener;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Lists;
import org.fest.util.VisibleForTesting;

public class NewHierarchy
extends ExistingHierarchy {
    private final WindowFilter filter;
    private final TransientWindowListener transientWindowListener;

    @Nonnull
    public static NewHierarchy ignoreExistingComponents() {
        return new NewHierarchy(true);
    }

    @Nonnull
    public static NewHierarchy includeExistingComponents() {
        return new NewHierarchy(false);
    }

    private NewHierarchy(boolean ignoreExisting) {
        this(ToolkitProvider.instance().defaultToolkit(), ignoreExisting);
    }

    private NewHierarchy(@Nonnull Toolkit toolkit, boolean ignoreExisting) {
        this.filter = new WindowFilter(this.parentFinder(), this.childrenFinder());
        this.transientWindowListener = new TransientWindowListener(this.filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @VisibleForTesting
    NewHierarchy(@Nonnull Toolkit toolkit, @Nonnull WindowFilter filter, boolean ignoreExisting) {
        this.filter = filter;
        this.transientWindowListener = new TransientWindowListener(filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @RunsInCurrentThread
    private void setUp(@Nonnull Toolkit toolkit, boolean ignoreExisting) {
        if (ignoreExisting) {
            this.ignoreExisting();
        }
        WeakEventListener.attachAsWeakEventListener(toolkit, this.transientWindowListener, 65L);
    }

    @RunsInCurrentThread
    public void ignoreExisting() {
        for (Container c : this.roots()) {
            if (c == null) continue;
            this.filter.ignore(c);
        }
    }

    @RunsInCurrentThread
    public void recognize(@Nonnull Component c) {
        this.filter.recognize(c);
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> childrenOf(@Nonnull Component c) {
        if (this.filter.isIgnored(c)) {
            return Lists.emptyList();
        }
        Collection<Component> children = super.childrenOf(c);
        children.removeAll(this.filter.filtered());
        return children;
    }

    @Override
    @RunsInCurrentThread
    public boolean contains(@Nonnull Component c) {
        return super.contains(c) && !this.filter.isIgnored(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(@Nonnull Window w) {
        if (!this.contains(w)) {
            return;
        }
        super.dispose(w);
        this.filter.ignore(w);
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        Collection<Container> roots = super.roots();
        roots.removeAll(this.filter.filtered());
        return roots;
    }
}

