/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.IntEnum;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public class JTreeFormatter
extends ComponentFormatterTemplate {
    private static final String[] EMPTY = new String[0];
    private static final IntEnum SELECTION_MODES = new IntEnum();

    @Override
    @Nonnull
    protected String doFormat(@Nonnull Component c) {
        JTree tree = (JTree)c;
        String format = "%s[name=%s, selectionCount=%d, selectionPaths=%s, selectionMode=%s, enabled=%b, visible=%b, showing=%b";
        return String.format(format, tree.getClass().getName(), Strings.quote((String)tree.getName()), tree.getSelectionCount(), Arrays.format((Object)this.selectionPaths(tree)), this.selectionMode(tree), tree.isEnabled(), tree.isVisible(), tree.isShowing());
    }

    @Nonnull
    private String[] selectionPaths(@Nonnull JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return EMPTY;
        }
        int count = paths.length;
        if (count == 0) {
            return EMPTY;
        }
        String[] pathArray = new String[count];
        for (int i = 0; i < count; ++i) {
            TreePath path = paths[i];
            pathArray[i] = path != null ? path.toString() : null;
        }
        return pathArray;
    }

    @Nullable
    private String selectionMode(JTree tree) {
        TreeSelectionModel model = tree.getSelectionModel();
        return SELECTION_MODES.get(model.getSelectionMode());
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JTree.class;
    }

    static {
        SELECTION_MODES.put(1, "SINGLE_TREE_SELECTION").put(2, "CONTIGUOUS_TREE_SELECTION").put(4, "DISCONTIGUOUS_TREE_SELECTION");
    }
}

