/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.IntEnum;
import org.fest.util.Strings;
import org.fest.util.ToString;

public class JFileChooserFormatter
extends ComponentFormatterTemplate {
    private static final IntEnum DIALOG_TYPES = new IntEnum();

    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JFileChooser fileChooser = (JFileChooser)c;
        String format = "%s[name=%s, dialogTitle=%s, dialogType=%s, currentDirectory=%s, enabled=%b, visible=%b, showing=%b";
        return String.format(format, fileChooser.getClass().getName(), Strings.quote((String)fileChooser.getName()), Strings.quote((String)fileChooser.getDialogTitle()), DIALOG_TYPES.get(fileChooser.getDialogType()), ToString.toStringOf((Object)fileChooser.getCurrentDirectory()), fileChooser.isEnabled(), fileChooser.isVisible(), fileChooser.isShowing());
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JFileChooser.class;
    }

    static {
        DIALOG_TYPES.put(0, "OPEN_DIALOG").put(1, "SAVE_DIALOG").put(2, "CUSTOM_DIALOG");
    }
}

