/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.fixture.ItemFixture;
import org.fest.swing.fixture.JListFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class JListItemFixture
implements ItemFixture<JListItemFixture> {
    private final JListFixture list;
    private final int index;

    public JListItemFixture(@Nonnull JListFixture list, int index) {
        this.list = (JListFixture)Preconditions.checkNotNull((Object)list);
        this.index = index;
    }

    @Override
    @Nonnull
    public final JListItemFixture select() {
        this.list.selectItem(this.index);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture click() {
        this.list.clickItem(this.index);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture click(@Nonnull MouseButton button) {
        this.list.clickItem(this.index, button, 1);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.list.clickItem(this.index, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture doubleClick() {
        this.list.clickItem(this.index, MouseButton.LEFT_BUTTON, 2);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture rightClick() {
        this.list.clickItem(this.index, MouseButton.RIGHT_BUTTON, 1);
        return this;
    }

    @Override
    @Nonnull
    public final JPopupMenuFixture showPopupMenu() {
        return this.list.showPopupMenuAt(this.index);
    }

    @Override
    @Nullable
    public final String value() {
        return this.list.valueAt(this.index);
    }

    @Override
    @Nonnull
    public final JListItemFixture drag() {
        this.list.drag(this.index);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture drop() {
        this.list.drop(this.index);
        return this;
    }

    public final int index() {
        return this.index;
    }

    @Nonnull
    @VisibleForTesting
    JListFixture listFixture() {
        return this.list;
    }
}

