/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JTreeAddRootIfInvisibleTask;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JTreeMatchingPathQuery {
    @Nonnull
    @RunsInEDT
    static TreePath verifyJTreeIsReadyAndFindMatchingPath(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        TreePath result = GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            @Nonnull
            protected TreePath executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                return JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
            }
        });
        return (TreePath)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    static TreePath matchingPathFor(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        TreePath result = GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            @Nonnull
            protected TreePath executeInEDT() {
                return JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
            }
        });
        return (TreePath)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInCurrentThread
    static TreePath matchingPathWithRootIfInvisible(@Nonnull JTree tree, @Nonnull String path, @Nonnull JTreePathFinder pathFinder) {
        TreePath matchingPath = pathFinder.findMatchingPath(tree, path);
        return JTreeAddRootIfInvisibleTask.addRootIfInvisible(tree, matchingPath);
    }

    private JTreeMatchingPathQuery() {
    }
}

