/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

final class JTableMatchingCellQuery {
    @Nonnull
    @RunsInEDT
    static TableCell cellWithValue(final @Nonnull JTable table, final @Nonnull TextMatcher matcher, final @Nonnull JTableCellReader cellReader) {
        TableCell result = GuiActionRunner.execute(new GuiQuery<TableCell>(){

            @Override
            protected TableCell executeInEDT() {
                return JTableMatchingCellQuery.findMatchingCell(table, matcher, cellReader);
            }
        });
        return (TableCell)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static TableCell findMatchingCell(@Nonnull JTable table, @Nonnull TextMatcher matcher, @Nonnull JTableCellReader cellReader) {
        int rCount = table.getRowCount();
        int cCount = table.getColumnCount();
        for (int r = 0; r < rCount; ++r) {
            for (int c = 0; c < cCount; ++c) {
                if (!JTableMatchingCellQuery.cellHasValue(table, r, c, matcher, cellReader)) continue;
                return TableCell.row(r).column(c);
            }
        }
        String msg = String.format("Unable to find cell matching %s %s", matcher.description(), matcher.formattedValues());
        throw ActionFailedException.actionFailure(msg);
    }

    @RunsInCurrentThread
    private static boolean cellHasValue(@Nonnull JTable table, int row, int column, @Nonnull TextMatcher matcher, @Nonnull JTableCellReader cellReader) {
        return matcher.isMatching(cellReader.valueAt(table, row, column));
    }

    private JTableMatchingCellQuery() {
    }
}

