/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public final class ComponentPreconditions {
    @RunsInCurrentThread
    public static void checkEnabledAndShowing(@Nonnull Component c) {
        ComponentPreconditions.checkEnabled(c);
        ComponentPreconditions.checkShowing(c);
    }

    @RunsInCurrentThread
    public static void checkEnabled(@Nonnull Component c) {
        if (!c.isEnabled()) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"Expecting component ", Formatting.format(c), " to be enabled"}));
        }
    }

    @RunsInCurrentThread
    public static void checkShowing(@Nonnull Component c) {
        if (!c.isShowing()) {
            String msg = String.format("Expecting component %s to be showing on the screen", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
    }

    private ComponentPreconditions() {
    }
}

