/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Preconditions;

public class TableCellInSelectedRow
implements TableCellFinder {
    private final int column;

    @Nonnull
    public static TableCellBuilder selectedRow() {
        return new TableCellBuilder();
    }

    protected TableCellInSelectedRow(int column) {
        this.column = column;
    }

    @Override
    @Nonnull
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        int selectedRow = TableCellInSelectedRow.selectedRowOf(table);
        if (selectedRow == -1) {
            throw ActionFailedException.actionFailure("The given JTable does not have any selection");
        }
        return new TableCell(selectedRow, this.column);
    }

    @RunsInEDT
    private static int selectedRowOf(final JTable table) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return table.getSelectedRow();
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    public String toString() {
        return String.format("%s[column=%d]", this.getClass().getName(), this.column);
    }

    public static class TableCellBuilder {
        @Nonnull
        public TableCellInSelectedRow column(int column) {
            return new TableCellInSelectedRow(column);
        }
    }
}

