/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.CommonBundle;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.CancelledConfigurationException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public abstract class UpdateOrStatusOptionsDialog
extends OptionsDialog {
    private final JComponent myMainPanel;
    private final List<Configurable> myConfigurables = new ArrayList<Configurable>();
    private final Action myHelpAction = new MyHelpAction();

    public UpdateOrStatusOptionsDialog(Project project, @NlsContexts.DialogTitle String title2, Map<Configurable, AbstractVcs> envToConfMap) {
        super(project);
        this.setTitle(title2);
        if (envToConfMap.size() == 1) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.addComponent(envToConfMap.keySet().iterator().next(), "Center");
            this.myMainPanel.add(Box.createVerticalStrut(10), "South");
        } else {
            this.myMainPanel = new JBTabbedPane();
            envToConfMap.entrySet().stream().sorted(Comparator.comparing(entry -> ((AbstractVcs)entry.getValue()).getDisplayName())).forEach(entry -> this.addComponent((Configurable)entry.getKey(), ((Configurable)entry.getKey()).getDisplayName()));
        }
        this.init();
    }

    @NlsSafe
    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog" + this.getActionNameForDimensions();
    }

    @NlsSafe
    protected abstract String getActionNameForDimensions();

    private void addComponent(Configurable configurable, String constraint) {
        this.myConfigurables.add(configurable);
        this.myMainPanel.add((Component)Objects.requireNonNull(configurable.createComponent()), constraint);
        configurable.reset();
    }

    protected void doOKAction() {
        for (Configurable configurable : this.myConfigurables) {
            try {
                configurable.apply();
            }
            catch (CancelledConfigurationException e) {
                return;
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"message.text.cannot.save.settings", (Object[])new Object[]{e.getLocalizedMessage()}), (String)this.getTitle());
                return;
            }
        }
        super.doOKAction();
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected Action getHelpAction() {
        Action action = this.myHelpAction;
        if (action == null) {
            UpdateOrStatusOptionsDialog.$$$reportNull$$$0(0);
        }
        return action;
    }

    private String helpTopic() {
        String helpTopic = null;
        if (this.myMainPanel instanceof JTabbedPane) {
            int idx = ((JTabbedPane)this.myMainPanel).getSelectedIndex();
            if (0 <= idx && idx < this.myConfigurables.size()) {
                helpTopic = this.myConfigurables.get(idx).getHelpTopic();
            }
        } else {
            helpTopic = this.myConfigurables.get(0).getHelpTopic();
        }
        return helpTopic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/UpdateOrStatusOptionsDialog", "getHelpAction"));
    }

    private final class MyHelpAction
    extends AbstractAction {
        private MyHelpAction() {
            super(CommonBundle.getHelpButtonText());
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && UpdateOrStatusOptionsDialog.this.helpTopic() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpManager.getInstance().invokeHelp(UpdateOrStatusOptionsDialog.this.helpTopic());
        }
    }
}

