/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.HandleTypeFactory;
import com.intellij.openapi.vcs.readOnlyHandler.VcsHandleType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.Nullable;

public class VcsHandleTypeFactory
implements HandleTypeFactory {
    private final Project myProject;

    public VcsHandleTypeFactory(Project project) {
        this.myProject = project;
    }

    @Nullable
    public HandleType createHandleType(VirtualFile file) {
        boolean fileExistsInVcs;
        if (!this.myProject.isInitialized()) {
            return null;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
        if (vcs != null && (fileExistsInVcs = vcs.fileExistsInVcs(VcsUtil.getFilePath((VirtualFile)file))) && vcs.getEditFileProvider() != null) {
            return new VcsHandleType(vcs);
        }
        return null;
    }
}

