/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.DynamicBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGeneralConfigurationPanel
implements Disposable {
    private JCheckBox myShowReadOnlyStatusDialog;
    private JRadioButton myShowDialogOnAddingFile;
    private JRadioButton myPerformActionOnAddingFile;
    private JRadioButton myDoNothingOnAddingFile;
    private JRadioButton myShowDialogOnRemovingFile;
    private JRadioButton myPerformActionOnRemovingFile;
    private JRadioButton myDoNothingOnRemovingFile;
    private JPanel myPanel;
    private final JRadioButton[] myOnFileAddingGroup;
    private final JRadioButton[] myOnFileRemovingGroup;
    private final Project myProject;
    private JPanel myPromptsPanel;
    Map<PersistentVcsShowSettingOption, JCheckBox> myPromptOptions;
    private JPanel myRemoveConfirmationPanel;
    private JPanel myAddConfirmationPanel;
    private JComboBox<ShowPatchAfterCreation> myOnPatchCreation;
    private JCheckBox myReloadContext;
    private JLabel myOnPatchCreationLabel;
    private JPanel myEmptyChangeListPanel;
    private JCheckBox myAddExternalFiles;
    private ButtonGroup myEmptyChangelistRemovingGroup;

    public VcsGeneralConfigurationPanel(Project project) {
        this.$$$setupUI$$$();
        this.myPromptOptions = new LinkedHashMap<PersistentVcsShowSettingOption, JCheckBox>();
        this.myProject = project;
        this.myOnPatchCreationLabel.setText(VcsBundle.message((String)"combobox.show.patch.in.explorer.after.creation", (Object[])new Object[]{RevealFileAction.getFileManagerName()}));
        this.myOnFileAddingGroup = new JRadioButton[]{this.myShowDialogOnAddingFile, this.myPerformActionOnAddingFile, this.myDoNothingOnAddingFile};
        this.myPerformActionOnAddingFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VcsGeneralConfigurationPanel.this.myAddExternalFiles.setEnabled(VcsGeneralConfigurationPanel.this.myPerformActionOnAddingFile.isSelected());
            }
        });
        this.myOnFileRemovingGroup = new JRadioButton[]{this.myShowDialogOnRemovingFile, this.myPerformActionOnRemovingFile, this.myDoNothingOnRemovingFile};
        this.myPromptsPanel.setLayout(new GridLayout(3, 0));
        List<PersistentVcsShowSettingOption> options = ProjectLevelVcsManagerEx.getInstanceEx(project).getAllOptions();
        for (PersistentVcsShowSettingOption setting : options) {
            if (!project.isDefault() && setting.getApplicableVcses(project).isEmpty()) continue;
            JCheckBox checkBox = new JCheckBox(setting.getDisplayName());
            this.myPromptsPanel.add(checkBox);
            this.myPromptOptions.put(setting, checkBox);
        }
        this.myPromptsPanel.setSize(this.myPromptsPanel.getPreferredSize());
        this.myOnPatchCreation.setModel((ComboBoxModel<ShowPatchAfterCreation>)new EnumComboBoxModel(ShowPatchAfterCreation.class));
        this.myOnPatchCreation.setName((SystemInfo.isMac ? "Reveal patch in" : "Show patch in ") + RevealFileAction.getFileManagerName() + " after creation:");
        ChangeListUtil.onChangeListAvailabilityChanged(this.myProject, this, true, () -> {
            boolean changeListsEnabled = ChangeListManager.getInstance((Project)this.myProject).areChangeListsEnabled();
            UIUtil.setEnabled((Component)this.myEmptyChangeListPanel, (boolean)changeListsEnabled, (boolean)true);
        });
    }

    public void apply() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        settings.REMOVE_EMPTY_INACTIVE_CHANGELISTS = VcsGeneralConfigurationPanel.getSelected(this.myEmptyChangelistRemovingGroup);
        settings.RELOAD_CONTEXT = this.myReloadContext.isSelected();
        settings.ADD_EXTERNAL_FILES_SILENTLY = this.myAddExternalFiles.isSelected();
        for (PersistentVcsShowSettingOption setting : this.myPromptOptions.keySet()) {
            setting.setValue(this.myPromptOptions.get(setting).isSelected());
        }
        this.getAddConfirmation().setValue(VcsGeneralConfigurationPanel.getSelected(this.myOnFileAddingGroup));
        this.getRemoveConfirmation().setValue(VcsGeneralConfigurationPanel.getSelected(this.myOnFileRemovingGroup));
        this.applyPatchOption(settings);
        this.getReadOnlyStatusHandler().getState().SHOW_DIALOG = this.myShowReadOnlyStatusDialog.isSelected();
    }

    private void applyPatchOption(VcsConfiguration settings) {
        settings.SHOW_PATCH_IN_EXPLORER = this.getShowPatchValue();
    }

    @Nullable
    private Boolean getShowPatchValue() {
        return ((ShowPatchAfterCreation)((Object)Objects.requireNonNull(this.myOnPatchCreation.getSelectedItem()))).getState();
    }

    private VcsShowConfirmationOption getAddConfirmation() {
        return ProjectLevelVcsManagerEx.getInstanceEx(this.myProject).getConfirmation(VcsConfiguration.StandardConfirmation.ADD);
    }

    private VcsShowConfirmationOption getRemoveConfirmation() {
        return ProjectLevelVcsManagerEx.getInstanceEx(this.myProject).getConfirmation(VcsConfiguration.StandardConfirmation.REMOVE);
    }

    private void createUIComponents() {
        this.myPanel = new JPanel(){

            @Override
            public void doLayout() {
                this.updateMinSize(VcsGeneralConfigurationPanel.this.myAddConfirmationPanel, VcsGeneralConfigurationPanel.this.myRemoveConfirmationPanel, VcsGeneralConfigurationPanel.this.myEmptyChangeListPanel, VcsGeneralConfigurationPanel.this.myPromptsPanel);
                super.doLayout();
            }

            private void updateMinSize(JPanel ... panels) {
                for (JPanel panel2 : panels) {
                    Border border = panel2.getBorder();
                    if (!(border instanceof IdeaTitledBorder)) continue;
                    ((IdeaTitledBorder)border).acceptMinimumSize((Component)panel2);
                }
            }
        };
    }

    private static VcsShowConfirmationOption.Value getSelected(JRadioButton[] group2) {
        if (group2[0].isSelected()) {
            return VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
        }
        if (group2[1].isSelected()) {
            return VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY;
        }
        return VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
    }

    private static VcsShowConfirmationOption.Value getSelected(ButtonGroup group2) {
        switch (UIUtil.getSelectedButton((ButtonGroup)group2)) {
            case 0: {
                return VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            }
            case 1: {
                return VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY;
            }
        }
        return VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
    }

    private ReadonlyStatusHandlerImpl getReadOnlyStatusHandler() {
        return (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
    }

    public boolean isModified() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        if (settings.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsGeneralConfigurationPanel.getSelected(this.myEmptyChangelistRemovingGroup)) {
            return true;
        }
        if (settings.RELOAD_CONTEXT != this.myReloadContext.isSelected()) {
            return true;
        }
        if (settings.ADD_EXTERNAL_FILES_SILENTLY != this.myAddExternalFiles.isSelected()) {
            return true;
        }
        if (this.getReadOnlyStatusHandler().getState().SHOW_DIALOG != this.myShowReadOnlyStatusDialog.isSelected()) {
            return true;
        }
        for (PersistentVcsShowSettingOption setting : this.myPromptOptions.keySet()) {
            if (setting.getValue() == this.myPromptOptions.get(setting).isSelected()) continue;
            return true;
        }
        if (VcsGeneralConfigurationPanel.getSelected(this.myOnFileAddingGroup) != this.getAddConfirmation().getValue()) {
            return true;
        }
        if (VcsGeneralConfigurationPanel.getSelected(this.myOnFileRemovingGroup) != this.getRemoveConfirmation().getValue()) {
            return true;
        }
        return !Comparing.equal((Object)settings.SHOW_PATCH_IN_EXPLORER, (Object)this.getShowPatchValue());
    }

    public void reset() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myReloadContext.setSelected(settings.RELOAD_CONTEXT);
        this.myAddExternalFiles.setSelected(settings.ADD_EXTERNAL_FILES_SILENTLY);
        this.myAddExternalFiles.setEnabled(this.myPerformActionOnAddingFile.isSelected());
        VcsShowConfirmationOption.Value value = settings.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
        UIUtil.setSelectedButton((ButtonGroup)this.myEmptyChangelistRemovingGroup, (int)(value == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION ? 0 : (value == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY ? 2 : 1)));
        this.myShowReadOnlyStatusDialog.setSelected(this.getReadOnlyStatusHandler().getState().SHOW_DIALOG);
        for (PersistentVcsShowSettingOption setting : this.myPromptOptions.keySet()) {
            this.myPromptOptions.get(setting).setSelected(setting.getValue());
        }
        VcsGeneralConfigurationPanel.selectInGroup(this.myOnFileAddingGroup, this.getAddConfirmation());
        VcsGeneralConfigurationPanel.selectInGroup(this.myOnFileRemovingGroup, this.getRemoveConfirmation());
        this.myOnPatchCreation.setSelectedItem((Object)ShowPatchAfterCreation.getByState(settings.SHOW_PATCH_IN_EXPLORER));
    }

    private static void selectInGroup(JRadioButton[] group2, VcsShowConfirmationOption confirmation) {
        int index;
        VcsShowConfirmationOption.Value value = confirmation.getValue();
        switch (value) {
            case SHOW_CONFIRMATION: {
                index = 0;
                break;
            }
            case DO_ACTION_SILENTLY: {
                index = 1;
                break;
            }
            default: {
                index = 2;
            }
        }
        group2[index].setSelected(true);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void updateAvailableOptions(Collection<? extends AbstractVcs> activeVcses) {
        for (PersistentVcsShowSettingOption setting : this.myPromptOptions.keySet()) {
            JCheckBox checkBox = this.myPromptOptions.get(setting);
            checkBox.setEnabled(setting.isApplicableTo(activeVcses) || this.myProject.isDefault());
            if (this.myProject.isDefault()) continue;
            checkBox.setToolTipText(VcsBundle.message((String)"tooltip.text.action.applicable.to.vcses", (Object[])new Object[]{VcsGeneralConfigurationPanel.composeText(setting.getApplicableVcses(this.myProject))}));
        }
        if (!this.myProject.isDefault()) {
            ProjectLevelVcsManagerEx vcsManager2 = ProjectLevelVcsManagerEx.getInstanceEx(this.myProject);
            PersistentVcsShowConfirmationOption addConfirmation = vcsManager2.getConfirmation(VcsConfiguration.StandardConfirmation.ADD);
            UIUtil.setEnabled((Component)this.myAddConfirmationPanel, (boolean)addConfirmation.isApplicableTo(activeVcses), (boolean)true);
            this.myAddConfirmationPanel.setToolTipText(VcsBundle.message((String)"tooltip.text.action.applicable.to.vcses", (Object[])new Object[]{VcsGeneralConfigurationPanel.composeText(addConfirmation.getApplicableVcses(this.myProject))}));
            PersistentVcsShowConfirmationOption removeConfirmation = vcsManager2.getConfirmation(VcsConfiguration.StandardConfirmation.REMOVE);
            UIUtil.setEnabled((Component)this.myRemoveConfirmationPanel, (boolean)removeConfirmation.isApplicableTo(activeVcses), (boolean)true);
            this.myRemoveConfirmationPanel.setToolTipText(VcsBundle.message((String)"tooltip.text.action.applicable.to.vcses", (Object[])new Object[]{VcsGeneralConfigurationPanel.composeText(removeConfirmation.getApplicableVcses(this.myProject))}));
        }
    }

    public void dispose() {
    }

    private static String composeText(List<? extends AbstractVcs> applicableVcses) {
        TreeSet<String> result2 = new TreeSet<String>();
        for (AbstractVcs abstractVcs : applicableVcses) {
            result2.add(abstractVcs.getDisplayName());
        }
        return StringUtil.join(result2, (String)", ");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        JPanel jPanel3;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel4;
        this.createUIComponents();
        JPanel jPanel5 = this.myPanel;
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), 32, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddConfirmationPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("settings.border.when.files.are.created"), (int)0, (int)0, null, null));
        this.myShowDialogOnAddingFile = jRadioButton6 = new JRadioButton();
        jRadioButton6.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.after.creation.show.options"));
        jPanel4.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPerformActionOnAddingFile = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.after.creation.add.silently"));
        jPanel4.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDoNothingOnAddingFile = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.after.creation.do.not.add"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAddExternalFiles = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("checkbox.including.external.files"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEmptyChangeListPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("settings.border.when.empty.changelist.becomes.inactive"), (int)0, (int)0, null, null));
        JRadioButton jRadioButton7 = new JRadioButton();
        jRadioButton7.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.inactive.show.options.before.removing"));
        jPanel3.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton8 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton8, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.remove.silently"));
        jPanel3.add((Component)jRadioButton8, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton9 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton9, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.do.not.remove"));
        jPanel3.add((Component)jRadioButton9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRemoveConfirmationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("settings.when.files.are.deleted"), (int)0, (int)0, null, null));
        this.myShowDialogOnRemovingFile = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.after.deletion.show.options"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPerformActionOnRemovingFile = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.after.deletion.remove.silently"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDoNothingOnRemovingFile = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.after.deletion.do.not.remove"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(97, 23), null));
        this.myPromptsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("border.display.dialog.when.commands.invoked"), (int)0, (int)0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myShowReadOnlyStatusDialog = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("checkbox.show.clear.read.only.status.dialog"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 5, 2));
        jPanel6.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOnPatchCreationLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("combobox.show.patch.in.explorer.after.creation"));
        Component component = jPanel7.add(jLabel);
        JComboBox jComboBox = new JComboBox();
        this.myOnPatchCreation = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        Component component2 = jPanel7.add(jComboBox);
        this.myReloadContext = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/VcsBundle", VcsGeneralConfigurationPanel.class).getString("radio.restore.workspace.on.branch.switching"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        this.myEmptyChangelistRemovingGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton9);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum ShowPatchAfterCreation {
        ASK(VcsBundle.getString((String)"settings.confirmation.option.text.ask"), null),
        YES(VcsBundle.getString((String)"settings.confirmation.option.text.yes"), true),
        NO(VcsBundle.getString((String)"settings.confirmation.option.text.no"), false);

        private final String myText;
        private final Boolean myState;

        private ShowPatchAfterCreation(String text2, Boolean state) {
            this.myText = text2;
            this.myState = state;
        }

        Boolean getState() {
            return this.myState;
        }

        @NotNull
        static ShowPatchAfterCreation getByState(Boolean state) {
            if (state == null) {
                ShowPatchAfterCreation showPatchAfterCreation = ASK;
                if (showPatchAfterCreation == null) {
                    ShowPatchAfterCreation.$$$reportNull$$$0(0);
                }
                return showPatchAfterCreation;
            }
            ShowPatchAfterCreation showPatchAfterCreation = state != false ? YES : NO;
            if (showPatchAfterCreation == null) {
                ShowPatchAfterCreation.$$$reportNull$$$0(1);
            }
            return showPatchAfterCreation;
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsGeneralConfigurationPanel$ShowPatchAfterCreation", "getByState"));
        }
    }
}

