/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsFacadeImpl
extends VcsFacade {
    @NotNull
    public static VcsFacadeImpl getVcsInstance() {
        VcsFacadeImpl vcsFacadeImpl = (VcsFacadeImpl)((Object)ApplicationManager.getApplication().getService(VcsFacade.class));
        if (vcsFacadeImpl == null) {
            VcsFacadeImpl.$$$reportNull$$$0(0);
        }
        return vcsFacadeImpl;
    }

    public boolean hasChanges(@NotNull PsiFile file) {
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(1);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public boolean hasChanges(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(2);
        }
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(3);
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getChangesIn(file);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public Boolean isFileUnderVcs(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            VcsFacadeImpl.$$$reportNull$$$0(4);
        }
        return VcsUtil.isFileUnderVcs((Project)psiFile.getProject(), (FilePath)VcsUtil.getFilePath((VirtualFile)psiFile.getVirtualFile()));
    }

    @NotNull
    public Set<String> getVcsIgnoreFileNames(@NotNull Project project) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(5);
        }
        Set set = VcsUtil.getVcsIgnoreFileNames((Project)project);
        if (set == null) {
            VcsFacadeImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file) {
        ChangedRangesInfo helper;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(7);
        }
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(8);
        }
        return (helper = this.getChangedRangesInfo(file)) != null ? helper.allChangedRanges : new ArrayList();
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file) {
        CharSequence testContent;
        Project project;
        Document document;
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(9);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file.getProject())).getDocument(file)) == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsFacadeImpl.getCachedChangedLines(project, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsFacadeImpl.calculateChangedRangesInfo(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsFacadeImpl.calculateChangedRangesInfo(document, contentFromVcs) : null;
    }

    @NotNull
    public List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<? extends PsiDirectory> dirs) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(10);
        }
        if (dirs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(11);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ArrayList changes = new ArrayList();
        for (PsiDirectory psiDirectory : dirs) {
            changes.addAll(changeListManager.getChangesIn(psiDirectory.getVirtualFile()));
        }
        return VcsFacadeImpl.getChangedFiles(project, changes);
    }

    @NotNull
    private static List<PsiFile> getChangedFiles(final @NotNull Project project, @NotNull Collection<? extends Change> changes) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(12);
        }
        if (changes == null) {
            VcsFacadeImpl.$$$reportNull$$$0(13);
        }
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private final PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        List list = ContainerUtil.mapNotNull(changes, (Function)changeToPsiFileMapper);
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, Change @NotNull [] changes, @NotNull Function<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(15);
        }
        if (elementsConvertor == null) {
            VcsFacadeImpl.$$$reportNull$$$0(16);
        }
        if (changes == null) {
            VcsFacadeImpl.$$$reportNull$$$0(17);
        }
        SmartList result2 = new SmartList();
        for (Change change : changes) {
            List elements;
            Document document;
            VirtualFile file;
            if (change.getType() == Change.Type.DELETED || !(change.getAfterRevision() instanceof CurrentContentRevision) || (file = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile()) == null || (document = FileDocumentManager.getInstance().getDocument(file)) == null) continue;
            List apply2 = (List)elementsConvertor.fun((Object)file);
            List list = elements = apply2 == null ? null : ContainerUtil.skipNulls((Collection)apply2);
            if (ContainerUtil.isEmpty((Collection)elements)) continue;
            BitSet changedLines = VcsFacadeImpl.getChangedLines(project, document, change);
            if (changedLines != null) {
                for (PsiElement element : elements) {
                    if (!VcsFacadeImpl.isElementChanged(element, document, changedLines)) continue;
                    result2.add(element);
                }
                continue;
            }
            result2.addAll(elements);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            VcsFacadeImpl.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @Nullable
    private static BitSet getChangedLines(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(19);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(20);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(21);
        }
        if (change.getType() == Change.Type.NEW) {
            return null;
        }
        List<? extends Range> ranges = VcsFacadeImpl.getChangedRanges(project, document, change);
        if (ranges == null) {
            return null;
        }
        BitSet changedLines = new BitSet();
        for (Range range : ranges) {
            if (!range.hasLines()) {
                if (!range.hasVcsLines()) continue;
                changedLines.set(Math.max(0, range.getLine1() - 1), range.getLine1() + 1);
                continue;
            }
            changedLines.set(range.getLine1(), range.getLine2());
        }
        return changedLines;
    }

    @Nullable
    private static List<? extends Range> getChangedRanges(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(22);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(23);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(24);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null) {
            if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
                if (ranges != null) {
                    return ContainerUtil.filter((Collection)ranges, range -> range.getChangelistId().equals(changeListId));
                }
                return null;
            }
            return tracker.getRanges();
        }
        String contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change);
        if (contentFromVcs != null) {
            return VcsFacadeImpl.getRanges(document, contentFromVcs);
        }
        return null;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document, @NotNull BitSet changedLines) {
        if (element == null) {
            VcsFacadeImpl.$$$reportNull$$$0(25);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(26);
        }
        if (changedLines == null) {
            VcsFacadeImpl.$$$reportNull$$$0(27);
        }
        TextRange textRange = element.getTextRange();
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(28);
        }
        if ((revision = change.getBeforeRevision()) == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.warn("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project, @NotNull Document document) {
        List ranges;
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(29);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(30);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null && (ranges = tracker.getRanges()) != null) {
            return VcsFacadeImpl.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    private static ChangedRangesInfo calculateChangedRangesInfo(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(31);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(32);
        }
        return VcsFacadeImpl.getChangedTextRanges(document, VcsFacadeImpl.getRanges(document, contentFromVcs));
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(33);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(34);
        }
        List list = RangesBuilder.createRanges((CharSequence)document.getImmutableCharSequence(), (CharSequence)StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n"));
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(35);
        }
        return list;
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(36);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(37);
        }
        List<Range> changedRanges = VcsFacadeImpl.getRanges(document, contentFromVcs);
        int linesChanges = 0;
        for (Range range : changedRanges) {
            int inserted = range.getLine2() - range.getLine1();
            int deleted = range.getVcsLine2() - range.getVcsLine1();
            linesChanges += Math.max(inserted, deleted);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<? extends Range> changedRanges) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(38);
        }
        if (changedRanges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(39);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<TextRange> insertedRanges = new ArrayList<TextRange>();
        for (Range range : changedRanges) {
            if (!range.hasLines()) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.hasVcsLines()) continue;
            insertedRanges.add(changedTextRange);
        }
        return new ChangedRangesInfo(ranges, insertedRanges);
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file) {
        boolean isUnderVcs;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(40);
        }
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(41);
        }
        if (!(isUnderVcs = VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file.getVirtualFile())))) {
            return true;
        }
        return ChangeListManager.getInstance((Project)project).isUnversioned(file.getVirtualFile());
    }

    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(42);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(43);
        }
        if (o == null) {
            VcsFacadeImpl.$$$reportNull$$$0(44);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }

    public void markFilesDirty(@NotNull Project project, @NotNull List<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(45);
        }
        if (virtualFiles == null) {
            VcsFacadeImpl.$$$reportNull$$$0(46);
        }
        VcsFileUtil.markFilesDirty(project, virtualFiles);
    }

    public JComponent createPatchPreviewComponent(@NotNull Project project, @NotNull ModelPatch patch) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(47);
        }
        if (patch == null) {
            VcsFacadeImpl.$$$reportNull$$$0(48);
        }
        List changes = EntryStream.of((Map)patch.getBranchChanges()).mapKeyValue((file, content2) -> {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            CurrentContentRevision current = new CurrentContentRevision(filePath);
            SimpleContentRevision changed = new SimpleContentRevision(content2.toString(), filePath, VcsBundle.message((String)"patched.version.name", (Object[])new Object[0]));
            return new Change((ContentRevision)current, (ContentRevision)changed);
        }).toList();
        return new SimpleChangesBrowser(project, changes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/VcsFacadeImpl";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 29: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConvertor";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLines";
                break;
            }
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/VcsFacadeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsIgnoreFileNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasChanges";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderVcs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVcsIgnoreFileNames";
                break;
            }
            case 7: 
            case 8: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getChangedTextRanges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFilesFromDirs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChangedElements";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChangedLines";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRanges";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isElementChanged";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionedContentFrom";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCachedChangedLines";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedRangesInfo";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyModificationTask";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createPatchPreviewComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

