/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/io/WindowsElevationStatus;", "", "()V", "isElevated", "", "TOKEN_ELEVATION", "intellij.platform.ide.util.io"})
final class WindowsElevationStatus {
    public static final WindowsElevationStatus INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isElevated() {
        WinNT.HANDLEByReference tokenHandle = new WinNT.HANDLEByReference();
        WinNT.HANDLE currentProcess = Kernel32.INSTANCE.GetCurrentProcess();
        if (!Advapi32.INSTANCE.OpenProcessToken(currentProcess, 40, tokenHandle)) {
            int lastError = Kernel32.INSTANCE.GetLastError();
            throw (Throwable)new RuntimeException("OpenProcessToken: " + lastError + " " + Kernel32Util.formatMessageFromLastErrorCode((int)lastError));
        }
        try {
            IntByReference cbNeeded = new IntByReference(0);
            TOKEN_ELEVATION token = new TOKEN_ELEVATION();
            int infoClass = 20;
            if (!Advapi32.INSTANCE.GetTokenInformation(tokenHandle.getValue(), infoClass, (Structure)token, token.size(), cbNeeded)) {
                int lastError = Kernel32.INSTANCE.GetLastError();
                throw (Throwable)new RuntimeException("GetTokenInformation: " + lastError + " " + Kernel32Util.formatMessageFromLastErrorCode((int)lastError));
            }
            boolean bl = token.TokenIsElevated.intValue() != 0;
            return bl;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(tokenHandle.getValue());
        }
    }

    private WindowsElevationStatus() {
    }

    static {
        WindowsElevationStatus windowsElevationStatus;
        INSTANCE = windowsElevationStatus = new WindowsElevationStatus();
    }

    @Structure.FieldOrder(value={"TokenIsElevated"})
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/io/WindowsElevationStatus$TOKEN_ELEVATION;", "Lcom/sun/jna/Structure;", "()V", "TokenIsElevated", "Lcom/sun/jna/platform/win32/WinDef$DWORD;", "intellij.platform.ide.util.io"})
    public static final class TOKEN_ELEVATION
    extends Structure {
        @JvmField
        @NotNull
        public WinDef.DWORD TokenIsElevated = new WinDef.DWORD(0L);
    }
}

