/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlightingLexer;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PropertiesHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    public static final TextAttributesKey PROPERTY_KEY;
    public static final TextAttributesKey PROPERTY_VALUE;
    public static final TextAttributesKey PROPERTY_COMMENT;
    public static final TextAttributesKey PROPERTY_KEY_VALUE_SEPARATOR;
    public static final TextAttributesKey PROPERTIES_VALID_STRING_ESCAPE;
    public static final TextAttributesKey PROPERTIES_INVALID_STRING_ESCAPE;
    public static final Map<TextAttributesKey, Pair<@Nls String, HighlightSeverity>> DISPLAY_NAMES;

    @NotNull
    public Lexer getHighlightingLexer() {
        return new PropertiesHighlightingLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            PropertiesHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        PROPERTY_VALUE = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        PROPERTY_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        PROPERTY_KEY_VALUE_SEPARATOR = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.KEY_VALUE_SEPARATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        PROPERTIES_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        PROPERTIES_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        keys1 = new HashMap<IElementType, TextAttributesKey>();
        keys2 = new HashMap<IElementType, TextAttributesKey>();
        keys1.put(PropertiesTokenTypes.VALUE_CHARACTERS, PROPERTY_VALUE);
        keys1.put(PropertiesTokenTypes.END_OF_LINE_COMMENT, PROPERTY_COMMENT);
        keys1.put(PropertiesTokenTypes.KEY_CHARACTERS, PROPERTY_KEY);
        keys1.put(PropertiesTokenTypes.KEY_VALUE_SEPARATOR, PROPERTY_KEY_VALUE_SEPARATOR);
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, PROPERTIES_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, PROPERTIES_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, PROPERTIES_INVALID_STRING_ESCAPE);
        DISPLAY_NAMES = ContainerUtil.immutableMapBuilder().put((Object)PROPERTY_KEY, (Object)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.property.key", new Object[0]), null)).put((Object)PROPERTY_VALUE, (Object)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.property.value", new Object[0]), null)).put((Object)PROPERTY_KEY_VALUE_SEPARATOR, (Object)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.key.value.separator", new Object[0]), null)).put((Object)PROPERTY_COMMENT, (Object)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.comment", new Object[0]), null)).put((Object)PROPERTIES_VALID_STRING_ESCAPE, (Object)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.valid.string.escape", new Object[0]), null)).put((Object)PROPERTIES_INVALID_STRING_ESCAPE, (Object)Pair.create((Object)PropertiesBundle.message("options.properties.attribute.descriptor.invalid.string.escape", new Object[0]), (Object)HighlightSeverity.WARNING)).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesHighlighter", "getTokenHighlights"));
    }
}

