/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unsorted;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unsorted.AlphaUnsortedPropertiesFileInspectionSuppressor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AlphaUnsortedPropertiesFileInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AlphaUnsortedPropertiesFileInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                PropertiesFile propertiesFile;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((propertiesFile = PropertiesImplUtil.getPropertiesFile(file)) instanceof PropertiesFileImpl)) {
                    return;
                }
                for (AlphaUnsortedPropertiesFileInspectionSuppressor filter : (AlphaUnsortedPropertiesFileInspectionSuppressor[])AlphaUnsortedPropertiesFileInspectionSuppressor.EP_NAME.getExtensions()) {
                    if (!filter.suppressInspectionFor(propertiesFile)) continue;
                    return;
                }
                ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
                String resourceBundleBaseName = resourceBundle.getBaseName();
                if (!AlphaUnsortedPropertiesFileInspection.isResourceBundleAlphaSortedExceptOneFile(resourceBundle, propertiesFile)) {
                    List<PropertiesFile> allFiles = resourceBundle.getPropertiesFiles();
                    holder.registerProblem((PsiElement)file, PropertiesBundle.message("inspection.alpha.unsorted.properties.file.description1", resourceBundleBaseName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new PropertiesSorterQuickFix(allFiles.toArray(new PropertiesFile[0]))});
                    return;
                }
                if (!propertiesFile.isAlphaSorted()) {
                    holder.registerProblem((PsiElement)file, PropertiesBundle.message("inspection.alpha.unsorted.properties.file.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new PropertiesSorterQuickFix(propertiesFile)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$1", "visitFile"));
            }
        };
    }

    private static boolean isResourceBundleAlphaSortedExceptOneFile(@NotNull ResourceBundle resourceBundle, @NotNull PropertiesFile exceptedFile) {
        if (resourceBundle == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(1);
        }
        if (exceptedFile == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(2);
        }
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (!(file instanceof PropertiesFileImpl)) {
                return true;
            }
            if (file.equals(exceptedFile) || file.isAlphaSorted()) continue;
            return false;
        }
        return true;
    }

    private static void sortPropertiesFile(PropertiesFile file) {
        ArrayList<IProperty> properties = new ArrayList<IProperty>(file.getProperties());
        properties.sort((p1, p2) -> Comparing.compare((Object)p1.getKey(), (Object)p2.getKey(), (Comparator)String.CASE_INSENSITIVE_ORDER));
        char delimiter = PropertiesCodeStyleSettings.getInstance(file.getProject()).getDelimiter();
        StringBuilder rawText = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            String key;
            IProperty property = (IProperty)properties.get(i);
            String value = property.getValue();
            String commentAboveProperty = property.getDocCommentText();
            if (commentAboveProperty != null) {
                rawText.append(commentAboveProperty).append("\n");
            }
            if ((key = property.getKey()) == null) continue;
            String propertyText = PropertiesElementFactory.getPropertyText(key, value != null ? value : "", Character.valueOf(delimiter), null, PropertyKeyValueFormat.FILE);
            rawText.append(propertyText);
            if (i == properties.size() - 1) continue;
            rawText.append("\n");
        }
        PropertiesFile fakeFile = PropertiesElementFactory.createPropertiesFile(file.getProject(), rawText.toString());
        PropertiesList propertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)file.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(propertiesList != null);
        PropertiesList fakePropertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)fakeFile.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(fakePropertiesList != null);
        propertiesList.replace((PsiElement)fakePropertiesList);
    }

    @NotNull
    public String getShortName() {
        return "AlphaUnsortedPropertiesFile";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptedFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isResourceBundleAlphaSortedExceptOneFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PropertiesSorterQuickFix
    implements LocalQuickFix {
        private final PropertiesFile[] myFilesToSort;

        private PropertiesSorterQuickFix(PropertiesFile ... toSort) {
            this.myFilesToSort = toSort;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("properties.sorter.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(2);
            }
            boolean force = this.myFilesToSort.length == 1;
            for (PropertiesFile file : this.myFilesToSort) {
                if (!force && file.isAlphaSorted()) continue;
                AlphaUnsortedPropertiesFileInspection.sortPropertiesFile(file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

