/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.history.SvnLazyPropertyContentRevision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance(SvnChangeProviderContext.class);
    @NotNull
    private final ChangelistBuilder myChangelistBuilder;
    @NotNull
    private final List<SvnChangedFile> myCopiedFiles;
    @NotNull
    private final List<SvnChangedFile> myDeletedFiles;
    @NotNull
    private final Map<String, Status> myTreeConflicted;
    @NotNull
    private final Map<FilePath, Url> myCopyFromURLs;
    @NotNull
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    @NotNull
    private final List<File> filesToRefresh;
    @Nullable
    private final ProgressIndicator myProgress;

    SvnChangeProviderContext(@NotNull SvnVcs vcs, @NotNull ChangelistBuilder changelistBuilder, @Nullable ProgressIndicator progress) {
        if (vcs == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(0);
        }
        if (changelistBuilder == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(1);
        }
        this.myCopiedFiles = new ArrayList<SvnChangedFile>();
        this.myDeletedFiles = new ArrayList<SvnChangedFile>();
        this.myTreeConflicted = new HashMap<String, Status>();
        this.myCopyFromURLs = new HashMap<FilePath, Url>();
        this.filesToRefresh = new ArrayList<File>();
        this.myVcs = vcs;
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, Status status) throws SvnBindException {
        if (status != null) {
            this.processStatusFirstPass(path, status);
        }
    }

    @Override
    public void processIgnored(@NotNull FilePath path) {
        if (path == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(2);
        }
        this.myChangelistBuilder.processIgnoredFile(path);
    }

    @Override
    public void processUnversioned(@NotNull FilePath path) {
        if (path == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(3);
        }
        this.myChangelistBuilder.processUnversionedFile(path);
    }

    @Override
    public void processCopyRoot(VirtualFile file, Url url, WorkingCopyFormat format, Url rootURL) {
    }

    @Override
    public void bewareRoot(VirtualFile vf, Url url) {
    }

    @Override
    public void finish() {
        LocalFileSystem.getInstance().refreshIoFiles(this.filesToRefresh, true, false, null);
    }

    @NotNull
    public ChangelistBuilder getBuilder() {
        ChangelistBuilder changelistBuilder = this.myChangelistBuilder;
        if (changelistBuilder == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(4);
        }
        return changelistBuilder;
    }

    public void reportTreeConflict(@NotNull Status status) {
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(5);
        }
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public Status getTreeConflictStatus(@NotNull File file) {
        if (file == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(6);
        }
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        List<SvnChangedFile> list = this.myCopiedFiles;
        if (list == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<SvnChangedFile> getDeletedFiles() {
        List<SvnChangedFile> list = this.myDeletedFiles;
        if (list == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean isDeleted(@NotNull FilePath path) {
        if (path == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(9);
        }
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    @Nullable
    public Url getParentCopyFromURL(@NotNull FilePath filePath) throws SvnBindException {
        FilePath parent;
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(10);
        }
        Url result = null;
        for (parent = filePath; parent != null && !this.myCopyFromURLs.containsKey(parent); parent = parent.getParentPath()) {
        }
        if (parent != null) {
            Url copyFromUrl = this.myCopyFromURLs.get(parent);
            result = parent == filePath ? copyFromUrl : SvnUtil.append(copyFromUrl, SvnUtil.getRelativePath(parent.getPath(), filePath.getPath()));
        }
        return result;
    }

    public void addCopiedFile(@NotNull FilePath filePath, @NotNull Status status, @NotNull Url copyFromURL) {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(11);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(12);
        }
        if (copyFromURL == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(13);
        }
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        ContainerUtil.putIfNotNull((Object)filePath, (Object)status.getCopyFromUrl(), this.myCopyFromURLs);
    }

    void processStatusFirstPass(@NotNull FilePath filePath, @NotNull Status status) throws SvnBindException {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(14);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(15);
        }
        if (status.getRemoteLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getRemoteLock().toLogicalLock(false));
        }
        if (status.getLocalLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getLocalLock().toLogicalLock(true));
        }
        if (filePath.isDirectory() && status.isWorkingCopyLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if (status.is(StatusType.STATUS_ADDED, StatusType.STATUS_MODIFIED) && status.getCopyFromUrl() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromUrl());
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            Url parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(@NotNull FilePath filePath, @NotNull Status status) {
        WorkingCopyFormat format;
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(16);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(17);
        }
        if (!WorkingCopyFormat.UNKNOWN.equals((Object)(format = this.myVcs.getWorkingCopyFormat(filePath.getIOFile()))) && format.less(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            this.loadEntriesFile(filePath);
        }
        FileStatus fStatus = Status.convertStatus(status);
        if (status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_NONE)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null) {
                this.myChangelistBuilder.processUnversionedFile(filePath);
            }
        } else if (status.is(StatusType.STATUS_MISSING)) {
            this.myChangelistBuilder.processLocallyDeletedFile((LocallyDeletedChange)new SvnLocallyDeletedChange(filePath, this.getState(status)));
        } else if (status.is(StatusType.STATUS_ADDED)) {
            this.processChangeInList(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status);
        } else if (status.is(StatusType.STATUS_CONFLICTED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED) || status.isProperty(StatusType.STATUS_MODIFIED, StatusType.STATUS_CONFLICTED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), fStatus, status);
            this.checkSwitched(filePath, status, fStatus);
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), null, fStatus, status);
        } else if (status.is(StatusType.STATUS_IGNORED)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file == null) {
                file = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath.getPath());
            }
            if (file == null) {
                LOG.error("No virtual file for ignored file: " + filePath.getPresentableUrl() + ", isNonLocal: " + filePath.isNonLocal());
            } else if (!this.myVcs.isWcRoot(filePath)) {
                this.myChangelistBuilder.processIgnoredFile(filePath);
            }
        } else if (fStatus == FileStatus.NOT_CHANGED || fStatus == FileStatus.SWITCHED) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status);
            } else if (status.getTreeConflict() != null) {
                this.myChangelistBuilder.processChange(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnVcs.getKey());
            }
            this.checkSwitched(filePath, status, fStatus);
        }
    }

    public void addModifiedNotSavedChange(@NotNull VirtualFile file) {
        if (file == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(18);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Info svnInfo = this.myVcs.getInfo(file);
        if (svnInfo != null) {
            Status.Builder svnStatus = new Status.Builder(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            svnStatus.setRevision(svnInfo.getRevision());
            svnStatus.setNodeKind(NodeKind.from(filePath.isDirectory()));
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnInfo.getRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, svnStatus.build());
        }
    }

    private void processChangeInList(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, @NotNull FileStatus fileStatus, @NotNull Status status) {
        if (fileStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(19);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(20);
        }
        Change change = this.createChange(beforeRevision, afterRevision, fileStatus, status);
        this.myChangelistBuilder.processChangeInList(change, SvnUtil.getChangelistName(status), SvnVcs.getKey());
    }

    private void checkSwitched(@NotNull FilePath filePath, @NotNull Status status, @NotNull FileStatus convertedStatus) {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(21);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(22);
        }
        if (convertedStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(23);
        }
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Url switchUrl = status.getUrl();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                this.myChangelistBuilder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl.toDecodedString() : baseUrl, true);
            }
        }
    }

    private void loadEntriesFile(@NotNull FilePath filePath) {
        FilePath parentPath;
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(24);
        }
        if ((parentPath = filePath.getParentPath()) == null) {
            return;
        }
        this.refreshDotSvnAndEntries(parentPath);
        if (filePath.isDirectory()) {
            this.refreshDotSvnAndEntries(filePath);
        }
    }

    private void refreshDotSvnAndEntries(@NotNull FilePath filePath) {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(25);
        }
        File svn = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME);
        this.filesToRefresh.add(svn);
        this.filesToRefresh.add(new File(svn, "entries"));
    }

    @NotNull
    Change createMovedChange(@NotNull ContentRevision before, @NotNull ContentRevision after, @Nullable Status copiedStatus, @NotNull Status deletedStatus) {
        if (before == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(26);
        }
        if (after == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(27);
        }
        if (deletedStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(28);
        }
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
        change.setBeforeDescription(deletedStatus.getTreeConflict());
        if (copiedStatus != null) {
            change.setAfterDescription(copiedStatus.getTreeConflict());
            this.patchWithPropertyChange(change, copiedStatus, deletedStatus);
        }
        ConflictedSvnChange conflictedSvnChange = change;
        if (conflictedSvnChange == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(29);
        }
        return conflictedSvnChange;
    }

    @NotNull
    private Change createChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull FileStatus fStatus, @NotNull Status svnStatus) {
        if (fStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(30);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(31);
        }
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, fStatus, this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
        change.setIsPhantom(svnStatus.is(StatusType.STATUS_DELETED) && !svnStatus.getRevision().isValid());
        change.setBeforeDescription(svnStatus.getTreeConflict());
        this.patchWithPropertyChange(change, svnStatus, null);
        ConflictedSvnChange conflictedSvnChange = change;
        if (conflictedSvnChange == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(32);
        }
        return conflictedSvnChange;
    }

    private void patchWithPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) {
        if (change == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(33);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(34);
        }
        if (!svnStatus.isProperty(StatusType.STATUS_CONFLICTED, StatusType.CHANGED, StatusType.STATUS_ADDED, StatusType.STATUS_DELETED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED, StatusType.MERGED)) {
            return;
        }
        PropertyRevision before = this.createBeforePropertyRevision(change, svnStatus, deletedStatus);
        PropertyRevision after = this.createAfterPropertyRevision(change, svnStatus);
        FileStatus status = deletedStatus != null ? FileStatus.MODIFIED : Status.convertPropertyStatus(svnStatus.getPropertyStatus());
        change.addAdditionalLayerElement("Property", new Change((ContentRevision)before, (ContentRevision)after, status));
    }

    @Nullable
    private PropertyRevision createBeforePropertyRevision(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) {
        if (change == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(35);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(36);
        }
        if (svnStatus.isProperty(StatusType.STATUS_ADDED) && deletedStatus == null) {
            return null;
        }
        ContentRevision before = change.getBeforeRevision();
        if (before == null) {
            return null;
        }
        FilePath path = ChangesUtil.getFilePath((Change)change);
        File file = deletedStatus != null ? deletedStatus.getFile() : path.getIOFile();
        Target target = Target.on(file, Revision.BASE);
        return new SvnLazyPropertyContentRevision(this.myVcs, path, before.getRevisionNumber(), target);
    }

    @Nullable
    private PropertyRevision createAfterPropertyRevision(@NotNull Change change, @NotNull Status svnStatus) {
        if (change == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(37);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(38);
        }
        if (svnStatus.isProperty(StatusType.STATUS_DELETED)) {
            return null;
        }
        ContentRevision after = change.getAfterRevision();
        if (after == null) {
            return null;
        }
        FilePath path = ChangesUtil.getFilePath((Change)change);
        Target target = Target.on(path.getIOFile(), Revision.WORKING);
        return new SvnLazyPropertyContentRevision(this.myVcs, path, after.getRevisionNumber(), target);
    }

    @NotNull
    private ConflictState getState(@Nullable Status svnStatus) {
        ConflictState result;
        ConflictState conflictState = result = svnStatus != null ? ConflictState.from(svnStatus) : ConflictState.none;
        if (result.isTree()) {
            this.reportTreeConflict(svnStatus);
        }
        ConflictState conflictState2 = result;
        if (conflictState2 == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(39);
        }
        return conflictState2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 29: 
            case 32: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 29: 
            case 32: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 29: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnChangeProviderContext";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromURL";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertedStatus";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedStatus";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fStatus";
                break;
            }
            case 31: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnStatus";
                break;
            }
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnChangeProviderContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopiedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createMovedChange";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIgnored";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processUnversioned";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 29: 
            case 32: 
            case 39: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportTreeConflict";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTreeConflictStatus";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDeleted";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParentCopyFromURL";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCopiedFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processStatusFirstPass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processStatus";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addModifiedNotSavedChange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processChangeInList";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitched";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadEntriesFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "refreshDotSvnAndEntries";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createMovedChange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "patchWithPropertyChange";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createBeforePropertyRevision";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createAfterPropertyRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 29: 
            case 32: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

