/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Deprecated
public interface Storage {
    public void put(String var1, String var2);

    public String get(String var1);

    public static final class MapStorage
    implements Storage {
        private final Map<String, String> myValues = new HashMap<String, String>();

        @Override
        public String get(String key) {
            return this.myValues.get(key);
        }

        @Override
        public void put(String key, String value) {
            this.myValues.put(key, value);
        }

        public Iterator<String> getKeys() {
            return Collections.unmodifiableCollection(this.myValues.keySet()).iterator();
        }
    }

    public static final class PropertiesComponentStorage
    implements Storage {
        private static final Logger LOG = Logger.getInstance(PropertiesComponentStorage.class);
        private final PropertiesComponent myPropertiesComponent;
        private final String myPrefix;

        public PropertiesComponentStorage(String prefix, PropertiesComponent propertiesComponent) {
            LOG.assertTrue(propertiesComponent != null || ApplicationManager.getApplication().isUnitTestMode());
            this.myPropertiesComponent = propertiesComponent;
            this.myPrefix = prefix;
        }

        public PropertiesComponentStorage(String prefix) {
            this(prefix, PropertiesComponent.getInstance());
        }

        @Override
        public void put(String key, String value) {
            if (this.myPropertiesComponent != null) {
                this.myPropertiesComponent.setValue(this.myPrefix + key, value);
            }
        }

        @Override
        public String get(String key) {
            return this.myPropertiesComponent != null ? this.myPropertiesComponent.getValue(this.myPrefix + key) : null;
        }

        public String toString() {
            return "PropertiesComponentStorage: " + this.myPrefix;
        }
    }
}

