/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class TabsUtil {
    public static final int NEW_TAB_VERTICAL_PADDING = JBUIScale.scale((int)2);

    private TabsUtil() {
    }

    public static int getTabsHeight() {
        return TabsUtil.getTabsHeight(NEW_TAB_VERTICAL_PADDING);
    }

    public static int getTabsHeight(int verticalPadding) {
        JLabel xxx = new JLabel("XXX");
        xxx.setFont(TabsUtil.getLabelFont());
        return xxx.getPreferredSize().height + verticalPadding * 2;
    }

    public static Font getLabelFont() {
        UISettings uiSettings = UISettings.getInstance();
        Font font = JBUI.CurrentTheme.ToolWindow.headerFont();
        if (uiSettings.getOverrideLafFonts()) {
            return font.deriveFont((float)uiSettings.getFontSize() + JBUI.CurrentTheme.ToolWindow.overrideHeaderFontSizeOffset());
        }
        return font;
    }

    public static int getDropSideFor(Point point, JComponent component) {
        double r = Math.max(0.05, Math.min(0.45, Registry.doubleValue((String)"ide.tabbedPane.dragToSplitRatio")));
        Dimension size = component.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        GeneralPath topShape = new GeneralPath();
        topShape.moveTo(0.0f, 0.0f);
        topShape.lineTo(width, 0.0);
        topShape.lineTo(width * (1.0 - r), height * r);
        topShape.lineTo(width * r, height * r);
        topShape.closePath();
        GeneralPath leftShape = new GeneralPath();
        leftShape.moveTo(0.0f, 0.0f);
        leftShape.lineTo(width * r, height * r);
        leftShape.lineTo(width * r, height * (1.0 - r));
        leftShape.lineTo(0.0, height);
        leftShape.closePath();
        GeneralPath bottomShape = new GeneralPath();
        bottomShape.moveTo(0.0, height);
        bottomShape.lineTo(width * r, height * (1.0 - r));
        bottomShape.lineTo(width * (1.0 - r), height * (1.0 - r));
        bottomShape.lineTo(width, height);
        bottomShape.closePath();
        GeneralPath rightShape = new GeneralPath();
        rightShape.moveTo(width, 0.0);
        rightShape.lineTo(width * (1.0 - r), height * r);
        rightShape.lineTo(width * (1.0 - r), height * (1.0 - r));
        rightShape.lineTo(width, height);
        rightShape.closePath();
        if (rightShape.contains(point)) {
            return 4;
        }
        if (leftShape.contains(point)) {
            return 2;
        }
        if (bottomShape.contains(point)) {
            return 3;
        }
        if (topShape.contains(point)) {
            return 1;
        }
        return component.getBounds().contains(point) ? 0 : -1;
    }

    @NotNull
    public static Rectangle getDropArea(@NotNull JBTabs tabs) {
        if (tabs == null) {
            TabsUtil.$$$reportNull$$$0(0);
        }
        Rectangle r = new Rectangle(tabs.getComponent().getBounds());
        if (tabs.getTabCount() > 0) {
            Rectangle firstTabBounds = tabs.getTabLabel(tabs.getTabAt(0)).getBounds();
            switch (tabs.getPresentation().getTabsPosition()) {
                case top: {
                    r.y += firstTabBounds.height;
                    r.height -= firstTabBounds.height;
                    break;
                }
                case left: {
                    r.x += firstTabBounds.width;
                    r.width -= firstTabBounds.width;
                    break;
                }
                case bottom: {
                    r.height -= firstTabBounds.height;
                    break;
                }
                case right: {
                    r.width -= firstTabBounds.width;
                }
            }
        }
        Rectangle rectangle = r;
        if (rectangle == null) {
            TabsUtil.$$$reportNull$$$0(1);
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/TabsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/TabsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDropArea";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

