/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.paint.RegionPainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.WavePainter2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public enum EffectPainter2D implements RegionPainter2D<Font>
{
    LINE_UNDERSCORE{

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double d, Font font) {
            if (g == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"ide.text.effect.new")) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + 1.0), (double)(x + width), (double)(y + 1.0));
            } else {
                void font2;
                void height;
                EffectPainter2D.paintUnderline(g, x, y, width, (double)height, (Font)font2, 1.0, this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/paint/EffectPainter2D$1", "paint"));
        }
    }
    ,
    BOLD_LINE_UNDERSCORE{

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double d, Font font) {
            if (g == null) {
                2.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"ide.text.effect.new")) {
                int h = JBUIScale.scale((int)Registry.intValue((String)"editor.bold.underline.height", (int)2));
                RectanglePainter2D.FILL.paint(g, x, y, width, (double)h);
            } else {
                void font2;
                void height;
                EffectPainter2D.paintUnderline(g, x, y, width, (double)height, (Font)font2, 2.0, this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/paint/EffectPainter2D$2", "paint"));
        }
    }
    ,
    BOLD_DOTTED_UNDERSCORE{

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double d, Font font) {
            void font2;
            void height;
            if (g == null) {
                3.$$$reportNull$$$0(0);
            }
            EffectPainter2D.paintUnderline(g, x, y, width, (double)height, (Font)font2, 2.0, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/paint/EffectPainter2D$3", "paint"));
        }
    }
    ,
    WAVE_UNDERSCORE{

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double d, Font font) {
            void height;
            if (g == null) {
                4.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"ide.text.effect.new")) {
                WavePainter2D.forColor((Color)g.getColor()).paint(g, x, x + width, y + height);
            } else if (Registry.is((String)"ide.text.effect.new.metrics")) {
                void font2;
                EffectPainter2D.paintUnderline(g, x, y, width, (double)height, (Font)font2, 3.0, this);
            } else if (width > 0.0 && height > 0.0) {
                Cached.WAVE_UNDERSCORE.paint(g, x, y, width, (double)height, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/paint/EffectPainter2D$4", "paint"));
        }
    }
    ,
    STRIKE_THROUGH{

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double d, Font font) {
            void height;
            if (g == null) {
                5.$$$reportNull$$$0(0);
            }
            if (width > 0.0 && height > 0.0) {
                if (!Registry.is((String)"ide.text.effect.new.metrics")) {
                    EffectPainter2D.drawLineCentered(g, x, y - height, width, (double)height, 1.0, this);
                } else {
                    Font font2;
                    if (font2 == null) {
                        font2 = g.getFont();
                    }
                    LineMetrics metrics = font2.getLineMetrics("", g.getFontRenderContext());
                    double offset = PaintUtil.alignToInt((double)(-metrics.getStrikethroughOffset()), (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
                    float strikeThroughThickness = metrics.getStrikethroughThickness();
                    double thickness = PaintUtil.alignToInt((double)EffectPainter2D.maybeScaleFontMetricsThickness(strikeThroughThickness, font2), (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
                    if (strikeThroughThickness > 0.0f && thickness <= 0.0) {
                        thickness = PaintUtil.devPixel((Graphics2D)g);
                    }
                    EffectPainter2D.drawLine(g, x, y - offset, width, thickness, this);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/paint/EffectPainter2D$5", "paint"));
        }
    };


    private static double getMaxHeight(double height) {
        return height > 7.0 && Registry.is((String)"ide.text.effect.new.scale") ? height / 2.0 : 3.0;
    }

    private static void paintUnderline(Graphics2D g, double x, double y, double width, double height, Font font, double thickness, EffectPainter2D painter) {
        if (width > 0.0 && height > 0.0) {
            if (Registry.is((String)"ide.text.effect.new.metrics")) {
                double offset;
                if (font == null) {
                    font = g.getFont();
                }
                PaintUtil.RoundingMode roundingMode = !JreHiDpiUtil.isJreHiDPIEnabled() || painter != WAVE_UNDERSCORE || font.getSize2D() / (float)UISettings.getDefFontSize() > 1.0f ? PaintUtil.RoundingMode.FLOOR : PaintUtil.RoundingMode.CEIL;
                LineMetrics metrics = font.getLineMetrics("", g.getFontRenderContext());
                double devPixel = PaintUtil.devPixel((Graphics2D)g);
                double underlineThickness = EffectPainter2D.maybeScaleFontMetricsThickness(metrics.getUnderlineThickness(), font);
                double underlineOffset = Math.max(devPixel, (double)metrics.getUnderlineOffset());
                boolean positive = thickness * underlineThickness > 0.0;
                thickness = PaintUtil.alignToInt((double)(thickness * underlineThickness), (Graphics2D)g, (PaintUtil.RoundingMode)roundingMode);
                if (positive && thickness <= 0.0) {
                    thickness = devPixel;
                }
                if ((offset = Math.min(height - thickness, underlineOffset)) < devPixel) {
                    offset = height > 3.0 * devPixel ? devPixel : 0.0;
                    thickness = PaintUtil.alignToInt((double)Math.min(thickness, height - offset), (Graphics2D)g, (PaintUtil.RoundingMode)roundingMode);
                } else {
                    offset = PaintUtil.alignToInt((double)offset, (Graphics2D)g, (PaintUtil.RoundingMode)roundingMode);
                }
                EffectPainter2D.drawLine(g, x, y + offset, width, thickness, painter);
            } else {
                if (height > 3.0) {
                    double max = EffectPainter2D.getMaxHeight(height);
                    y += height - max;
                    height = max;
                    if (thickness > 1.0 && height > 3.0) {
                        thickness = JBUIScale.scale((float)((float)thickness));
                    }
                }
                EffectPainter2D.drawLineCentered(g, x, y, width, height, thickness, painter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static double maybeScaleFontMetricsThickness_TestOnly(double fontMetricsThickness, @NotNull Font font) {
        void font2;
        if (font == null) {
            EffectPainter2D.$$$reportNull$$$0(0);
        }
        return EffectPainter2D.maybeScaleFontMetricsThickness(fontMetricsThickness, (Font)font2);
    }

    /*
     * WARNING - void declaration
     */
    private static double maybeScaleFontMetricsThickness(double fontMetricsThickness, @NotNull Font font) {
        void font2;
        if (font == null) {
            EffectPainter2D.$$$reportNull$$$0(1);
        }
        float fontScale = JBUIScale.getFontScale((float)font2.getSize2D());
        float normalizedFontScale = font2.getSize2D() / (float)UISettings.getDefFontSize();
        if (normalizedFontScale > 1.0f) {
            double k = 1.0 / (Math.pow(normalizedFontScale, 2.0) + 1.0) + 0.5;
            fontScale = (float)((double)fontScale * k);
        }
        if (!JreHiDpiUtil.isJreHiDPIEnabled()) {
            fontScale = Math.max(1, Math.round(fontScale));
        }
        return Math.max(fontMetricsThickness, (double)fontScale);
    }

    private static void drawLineCentered(Graphics2D g, double x, double y, double width, double height, double thickness, EffectPainter2D painter) {
        double offset = height - thickness;
        if (offset > 0.0) {
            y += offset / 2.0;
            height = thickness;
        }
        EffectPainter2D.drawLine(g, x, y, width, height, painter);
    }

    private static void drawLine(Graphics2D g, double x, double y, double width, double height, EffectPainter2D painter) {
        if (painter == BOLD_DOTTED_UNDERSCORE) {
            double dx;
            double w = width + (dx = (x % height + height) % height);
            double dw = (w % height + height) % height;
            Cached.BOLD_DOTTED_UNDERSCORE.paint(g, x - dx, y, dw == 0.0 ? w : w - dw + height, height, null);
        } else if (painter == WAVE_UNDERSCORE) {
            Cached.WAVE_UNDERSCORE.paint(g, x, y, width, height, null);
        } else {
            RectanglePainter2D.FILL.paint(g, x, y, width, height);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "font";
        objectArray2[1] = "com/intellij/ui/paint/EffectPainter2D";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeScaleFontMetricsThickness_TestOnly";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeScaleFontMetricsThickness";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Cached implements RegionPainter2D<Paint>
    {
        BOLD_DOTTED_UNDERSCORE{

            @Override
            double getPeriod(double height) {
                return height;
            }

            @Override
            void paintImage(Graphics2D g, double width, double height, double period) {
                Double round = period <= 2.0 && !JreHiDpiUtil.isJreHiDPI((Graphics2D)g) ? null : Double.valueOf(period);
                int dx = 0;
                while ((double)dx < width) {
                    RectanglePainter2D.FILL.paint(g, (double)dx, 0.0, period, period, round, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                    dx = (int)((double)dx + period * 2.0);
                }
            }
        }
        ,
        WAVE_UNDERSCORE{
            private final BasicStroke THIN_STROKE = new BasicStroke(0.7f);

            @Override
            double getPeriod(double height) {
                return Math.max((Registry.is((String)"ide.text.effect.new.metrics") ? height : EffectPainter2D.getMaxHeight(height)) - 1.0, 1.0);
            }

            @Override
            void paintImage(Graphics2D g, double width, double height, double period) {
                double lower = height - 1.0;
                double upper = lower - period;
                if (Registry.is((String)"ide.text.effect.new.metrics")) {
                    if (height > 3.0) {
                        double fix2 = height / 3.0;
                        g.setStroke(new BasicStroke((float)fix2));
                        if (fix2 > 1.0) {
                            fix2 = (fix2 - 1.0) / 2.0;
                            lower -= fix2;
                            upper += fix2;
                        }
                    }
                    height += 2.0;
                    if (g.getClass().getName().equals("com.intellij.util.HiDPIScaledGraphics")) {
                        lower += 0.5;
                        upper += 0.5;
                    }
                }
                Path2D.Double path2 = new Path2D.Double();
                double dx = 0.0;
                ((Path2D)path2).moveTo(dx, lower);
                if (height < 6.0) {
                    g.setStroke(this.THIN_STROKE);
                    while (dx < width) {
                        ((Path2D)path2).lineTo(dx += period, upper);
                        ((Path2D)path2).lineTo(dx += period, lower);
                    }
                } else {
                    double size = period / 2.0;
                    double prev = dx - size / 2.0;
                    double center = (upper + lower) / 2.0;
                    while (dx < width) {
                        ((Path2D)path2).quadTo(prev += size, lower, dx += size, center);
                        ((Path2D)path2).quadTo(prev += size, upper, dx += size, upper);
                        ((Path2D)path2).quadTo(prev += size, upper, dx += size, center);
                        ((Path2D)path2).quadTo(prev += size, lower, dx += size, lower);
                    }
                }
                ((Path2D)path2).lineTo(width, lower);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.draw(path2);
            }
        };

        private final ConcurrentHashMap<Integer, BufferedImage> myNormalCache = new ConcurrentHashMap();
        private final ConcurrentHashMap<Integer, BufferedImage> myHiDPICache = new ConcurrentHashMap();

        abstract double getPeriod(double var1);

        abstract void paintImage(Graphics2D var1, double var2, double var4, double var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void paintImage(Graphics2D g, Paint paint, double width, double height, double period) {
            try {
                g.setPaint(paint);
                this.paintImage(g, width, height, period);
            }
            finally {
                g.dispose();
            }
        }

        @Nullable
        BufferedImage getImage(@NotNull Graphics2D g, Color color, double height) {
            if (g == null) {
                Cached.$$$reportNull$$$0(0);
            }
            ConcurrentHashMap<Integer, BufferedImage> cache = JreHiDpiUtil.isJreHiDPI((Graphics2D)g) ? this.myHiDPICache : this.myNormalCache;
            int key = Objects.hash(color.getRGB(), Float.valueOf(JBUIScale.sysScale((Graphics2D)g)), height);
            BufferedImage image = cache.get(key);
            if (image == null && (image = this.createImage(g, color, height)) != null) {
                cache.putIfAbsent(key, image);
            }
            return image;
        }

        @Nullable
        BufferedImage createImage(@NotNull Graphics2D g, Paint paint, double height) {
            double period;
            int width;
            if (g == null) {
                Cached.$$$reportNull$$$0(1);
            }
            if ((width = (int)(period = this.getPeriod(height)) << (paint instanceof Color ? 8 : 1)) <= 0 || height <= 0.0) {
                return null;
            }
            BufferedImage image = ImageUtil.createImage((Graphics)g, (double)width, (double)height, (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            this.paintImage(image.createGraphics(), paint, width, height, period);
            return image;
        }

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double d, Paint paint) {
            BufferedImage image;
            void height;
            Paint paint2;
            if (g == null) {
                Cached.$$$reportNull$$$0(2);
            }
            if (paint2 == null) {
                paint2 = g.getPaint();
            }
            g = (Graphics2D)g.create();
            g.translate(x, y);
            g.clip(new Rectangle2D.Double(0.0, 0.0, width, (double)height));
            g.setComposite(AlphaComposite.SrcOver);
            BufferedImage bufferedImage = image = paint2 instanceof Color ? this.getImage(g, (Color)paint2, (double)height) : this.createImage(g, paint2, (double)height);
            if (image == null) {
                return;
            }
            double period = (double)ImageUtil.getRealWidth((Image)image) / ImageUtil.getImageScale((Image)image);
            double offset = (x % period + period) % period;
            g.translate(-offset, 0.0);
            for (double dx = -offset; dx < width; dx += period) {
                StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                g.translate(period, 0.0);
            }
            g.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "g";
            objectArray2[1] = "com/intellij/ui/paint/EffectPainter2D$Cached";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getImage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createImage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

