/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.util.DeprecatedMethodException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerType<C extends ServerConfiguration> {
    public static final ExtensionPointName<ServerType> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.type");
    private final String myId;

    protected ServerType(String id) {
        this.myId = id;
    }

    public final String getId() {
        return this.myId;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getPresentableName();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDeploymentConfigurationTypePresentableName() {
        String string = CloudBundle.message("server.type.deployment.configuration.typ.presentable.name.0.deployment", this.getPresentableName());
        if (string == null) {
            ServerType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDeploymentConfigurationFactoryId() {
        DeprecatedMethodException.reportDefaultImplementation(this.getClass(), (String)"getDeploymentConfigurationFactoryId", (String)"The default implementation delegates to 'getDeploymentConfigurationTypePresentableName' which is supposed to be localized but return value of this method must not be localized.");
        String string = this.getDeploymentConfigurationTypePresentableName();
        if (string == null) {
            ServerType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.settings.clouds";
    }

    @NotNull
    public abstract Icon getIcon();

    public boolean canAutoDetectConfiguration() {
        return false;
    }

    @NotNull
    public abstract C createDefaultConfiguration();

    @NotNull
    public RemoteServerConfigurable createServerConfigurable(@NotNull C configuration) {
        if (configuration == null) {
            ServerType.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @NotNull
    public UnnamedConfigurable createConfigurable(@NotNull C configuration) {
        if (configuration == null) {
            ServerType.$$$reportNull$$$0(3);
        }
        RemoteServerConfigurable remoteServerConfigurable = this.createServerConfigurable(configuration);
        if (remoteServerConfigurable == null) {
            ServerType.$$$reportNull$$$0(4);
        }
        return remoteServerConfigurable;
    }

    @NotNull
    public abstract DeploymentConfigurator<?, C> createDeploymentConfigurator(Project var1);

    public List<SingletonDeploymentSourceType> getSingletonDeploymentSourceTypes() {
        return Collections.emptyList();
    }

    public boolean mayHaveProjectSpecificDeploymentSources() {
        return true;
    }

    @NotNull
    public abstract ServerConnector<?> createConnector(@NotNull C var1, @NotNull ServerTaskExecutor var2);

    @NotNull
    public ServerConnector<?> createConnector(@NotNull RemoteServer<C> server, @NotNull ServerTaskExecutor asyncTasksExecutor) {
        if (server == null) {
            ServerType.$$$reportNull$$$0(5);
        }
        if (asyncTasksExecutor == null) {
            ServerType.$$$reportNull$$$0(6);
        }
        ServerConnector<?> serverConnector = this.createConnector(server.getConfiguration(), asyncTasksExecutor);
        if (serverConnector == null) {
            ServerType.$$$reportNull$$$0(7);
        }
        return serverConnector;
    }

    @Nullable
    public DebugConnector<?, ?> createDebugConnector() {
        return null;
    }

    @NotNull
    public Comparator<Deployment> getDeploymentComparator() {
        Comparator<Deployment> comparator = Comparator.comparing(Deployment::getName);
        if (comparator == null) {
            ServerType.$$$reportNull$$$0(8);
        }
        return comparator;
    }

    @Nullable
    public String getCustomToolWindowId() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/ServerType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncTasksExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurationTypePresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurationFactoryId";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/ServerType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentComparator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createServerConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConnector";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

