/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataNode<T>
implements UserDataHolderEx,
Serializable {
    private static final Logger LOG = Logger.getInstance(DataNode.class);
    @NotNull
    private Key<T> key;
    @Nullable
    private volatile transient UserDataHolderBase internalUserDataOrNull;
    private static final AtomicFieldUpdater<DataNode, UserDataHolderBase> userDataUpdater = AtomicFieldUpdater.forFieldOfType(DataNode.class, UserDataHolderBase.class);
    @Nullable
    private T data;
    private boolean ignored;
    private volatile transient boolean ready;
    @Nullable
    private DataNode<?> parent;
    @Nullable
    private List<DataNode<?>> children;
    @Nullable
    private transient List<DataNode<?>> childrenView;

    public DataNode(@NotNull Key<T> key, @NotNull T data, @Nullable DataNode<?> parent) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(0);
        }
        if (data == null) {
            DataNode.$$$reportNull$$$0(1);
        }
        this.internalUserDataOrNull = null;
        this.key = key;
        this.data = data;
        this.parent = parent;
    }

    public boolean isReady() {
        return this.ready;
    }

    private DataNode() {
        this.internalUserDataOrNull = null;
    }

    @Nullable
    public DataNode<?> getParent() {
        return this.parent;
    }

    @NotNull
    public <T> DataNode<T> createChild(@NotNull Key<T> key, @NotNull T data) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(2);
        }
        if (data == null) {
            DataNode.$$$reportNull$$$0(3);
        }
        DataNode<T> result = new DataNode<T>(key, data, this);
        this.doAddChild(result);
        DataNode<T> dataNode = result;
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(4);
        }
        return dataNode;
    }

    @NotNull
    public Key<T> getKey() {
        Key<T> key = this.key;
        if (key == null) {
            DataNode.$$$reportNull$$$0(5);
        }
        return key;
    }

    @NotNull
    public T getData() {
        T t = this.data;
        if (t == null) {
            DataNode.$$$reportNull$$$0(6);
        }
        return t;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public void visitData(@Nullable Function visitor) {
        if (visitor == null) {
            return;
        }
        Object newData = visitor.apply(this.getData());
        if (newData != null) {
            this.data = newData;
        }
    }

    @Nullable
    public <T> T getData(@NotNull Key<T> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(7);
        }
        if (this.key.equals(key)) {
            return this.data;
        }
        DataNode<?> p = this.parent;
        while (p != null) {
            if (p.key.equals(key)) {
                return p.data;
            }
            p = p.parent;
        }
        return null;
    }

    @Nullable
    public <T> DataNode<T> getDataNode(@NotNull Key<T> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(8);
        }
        if (this.key.equals(key)) {
            return this;
        }
        DataNode<?> p = this.parent;
        while (p != null) {
            if (p.key.equals(key)) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    @Nullable
    public <P> DataNode<P> getParent(@NotNull Class<P> dataClass) {
        if (dataClass == null) {
            DataNode.$$$reportNull$$$0(9);
        }
        if (dataClass.isInstance(this.data)) {
            return this;
        }
        DataNode<?> p = this.parent;
        while (p != null) {
            if (dataClass.isInstance(p.data)) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    public void addChild(@NotNull DataNode<?> child) {
        if (child == null) {
            DataNode.$$$reportNull$$$0(10);
        }
        child.parent = this;
        this.doAddChild(child);
    }

    private void doAddChild(@NotNull DataNode<?> child) {
        if (child == null) {
            DataNode.$$$reportNull$$$0(11);
        }
        if (this.children == null) {
            ArrayList newChildren = new ArrayList();
            newChildren.add(child);
            this.initChildren(newChildren);
        } else {
            this.children.add(child);
        }
    }

    private void initChildren(@Nullable List<DataNode<?>> children) {
        this.children = children;
        this.childrenView = null;
    }

    @NotNull
    public Collection<DataNode<?>> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            List<DataNode<?>> list = Collections.emptyList();
            if (list == null) {
                DataNode.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<DataNode<?>> result = this.childrenView;
        if (result == null) {
            this.childrenView = result = Collections.unmodifiableList(this.children);
        }
        List<DataNode<?>> list = result;
        if (list == null) {
            DataNode.$$$reportNull$$$0(13);
        }
        return list;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.getData().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNode node = (DataNode)o;
        if (!Objects.equals(this.key, node.key)) {
            return false;
        }
        if (!Objects.equals(this.getData(), node.getData())) {
            return false;
        }
        return Objects.equals(ObjectUtils.notNull(this.children, Collections.emptyList()), ObjectUtils.notNull(node.children, Collections.emptyList()));
    }

    public String toString() {
        String dataDescription;
        try {
            dataDescription = this.getData().toString();
        }
        catch (Exception e) {
            dataDescription = "failed to load";
            LOG.debug((Throwable)e);
        }
        return String.format("%s: %s", this.key, dataDescription);
    }

    public void clear(boolean removeFromGraph) {
        if (removeFromGraph && this.parent != null && this.parent.children != null) {
            Iterator<DataNode<?>> iterator = this.parent.children.iterator();
            while (iterator.hasNext()) {
                DataNode<?> dataNode = iterator.next();
                if (System.identityHashCode(dataNode) != System.identityHashCode(this)) continue;
                iterator.remove();
                if (!this.parent.children.isEmpty()) break;
                this.parent.initChildren(null);
                break;
            }
        }
        this.parent = null;
        this.initChildren(null);
    }

    @NotNull
    public DataNode<T> graphCopy() {
        return DataNode.copy(this, null);
    }

    @NotNull
    public DataNode<T> nodeCopy() {
        return DataNode.nodeCopy(this);
    }

    @Nullable
    public <U> U getUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        UserDataHolderBase holder;
        if (key == null) {
            DataNode.$$$reportNull$$$0(14);
        }
        return (U)((holder = this.getUserDataHolder()) == null ? null : holder.getUserData(key));
    }

    public <U> void putUserData(@NotNull com.intellij.openapi.util.Key<U> key, U value) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(15);
        }
        this.getOrCreateUserDataHolder().putUserData(key, value);
    }

    public <U> void removeUserData(@NotNull com.intellij.openapi.util.Key<U> key) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(16);
        }
        this.getOrCreateUserDataHolder().putUserData(key, null);
    }

    @NotNull
    public <D> D putUserDataIfAbsent(@NotNull com.intellij.openapi.util.Key<D> key, @NotNull D value) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(17);
        }
        if (value == null) {
            DataNode.$$$reportNull$$$0(18);
        }
        Object object = this.getOrCreateUserDataHolder().putUserDataIfAbsent(key, value);
        if (object == null) {
            DataNode.$$$reportNull$$$0(19);
        }
        return (D)object;
    }

    public <D> boolean replace(@NotNull com.intellij.openapi.util.Key<D> key, @Nullable D oldValue, @Nullable D newValue) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(20);
        }
        return this.getOrCreateUserDataHolder().replace(key, oldValue, newValue);
    }

    public <T> void putCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key, T value) {
        if (key == null) {
            DataNode.$$$reportNull$$$0(21);
        }
        this.getOrCreateUserDataHolder().putCopyableUserData(key, value);
    }

    public <T> T getCopyableUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        UserDataHolderBase holder;
        if (key == null) {
            DataNode.$$$reportNull$$$0(22);
        }
        return (T)((holder = this.getUserDataHolder()) == null ? null : holder.getCopyableUserData(key));
    }

    public boolean validateData() {
        if (this.data == null) {
            this.ready = false;
            this.clear(true);
        } else {
            this.ready = true;
        }
        return this.ready;
    }

    @NotNull
    public static <T> DataNode<T> nodeCopy(@NotNull DataNode<T> dataNode) {
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(23);
        }
        DataNode<T> copy = new DataNode<T>();
        copy.key = dataNode.key;
        copy.data = dataNode.data;
        copy.ignored = dataNode.ignored;
        copy.ready = dataNode.ready;
        UserDataHolderBase userData = dataNode.getUserDataHolder();
        if (userData != null) {
            userData.copyCopyableDataTo(copy.getOrCreateUserDataHolder());
        }
        DataNode<T> dataNode2 = copy;
        if (dataNode2 == null) {
            DataNode.$$$reportNull$$$0(24);
        }
        return dataNode2;
    }

    @Nullable
    private UserDataHolderBase getUserDataHolder() {
        return this.internalUserDataOrNull;
    }

    @NotNull
    private UserDataHolderBase getOrCreateUserDataHolder() {
        if (this.internalUserDataOrNull == null) {
            userDataUpdater.compareAndSet((Object)this, null, (Object)new UserDataHolderBase());
        }
        UserDataHolderBase userDataHolderBase = this.internalUserDataOrNull;
        if (userDataHolderBase == null) {
            DataNode.$$$reportNull$$$0(25);
        }
        return userDataHolderBase;
    }

    @NotNull
    private static <T> DataNode<T> copy(@NotNull DataNode<T> dataNode, @Nullable DataNode<?> newParent) {
        if (dataNode == null) {
            DataNode.$$$reportNull$$$0(26);
        }
        DataNode copy = DataNode.nodeCopy(dataNode);
        copy.parent = newParent;
        if (dataNode.children != null) {
            copy.initChildren(ContainerUtil.map(dataNode.children, child -> DataNode.copy(child, copy)));
        }
        DataNode dataNode2 = copy;
        if (dataNode2 == null) {
            DataNode.$$$reportNull$$$0(27);
        }
        return dataNode2;
    }

    public final void visit(@NotNull Consumer<? super DataNode<?>> consumer) {
        DataNode node;
        if (consumer == null) {
            DataNode.$$$reportNull$$$0(28);
        }
        ArrayDeque toProcess = new ArrayDeque();
        toProcess.add(this);
        while ((node = (DataNode)toProcess.pollFirst()) != null) {
            consumer.accept(node);
            if (node.children == null) continue;
            toProcess.addAll(node.children);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/DataNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/DataNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeCopy";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateUserDataHolder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDataNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doAddChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeUserData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "nodeCopy";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

