/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditSourceUtil {
    private EditSourceUtil() {
    }

    @Nullable
    public static Navigatable getDescriptor(@NotNull PsiElement element) {
        PsiElement original;
        if (element == null) {
            EditSourceUtil.$$$reportNull$$$0(0);
        }
        if ((original = EditSourceUtil.getNavigatableOriginalElement(element)) != null) {
            element = original;
        } else if (!EditSourceUtil.canNavigate(element)) {
            return null;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget();
        }
        PsiElement navigationElement = element.getNavigationElement();
        if (navigationElement instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)navigationElement).getTarget();
        }
        int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(navigationElement);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        OpenFileDescriptor desc = new OpenFileDescriptor(navigationElement.getProject(), virtualFile2, offset);
        desc.setUseCurrentWindow(FileEditorManager.USE_CURRENT_WINDOW.isIn((UserDataHolder)navigationElement));
        return desc;
    }

    private static PsiElement getNavigatableOriginalElement(@NotNull PsiElement element) {
        if (element == null) {
            EditSourceUtil.$$$reportNull$$$0(1);
        }
        return EditSourceUtil.processAllOriginalElements(element, original -> EditSourceUtil.canNavigate(original) ? original : null);
    }

    public static boolean canNavigate(PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile(element.getNavigationElement());
        return file != null && file.isValid() && !file.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink(file);
    }

    public static void navigate(@NotNull NavigationItem item, boolean requestFocus, boolean useCurrentWindow) {
        if (item == null) {
            EditSourceUtil.$$$reportNull$$$0(2);
        }
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)useCurrentWindow);
        }
        item.navigate(requestFocus);
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        }
    }

    private static PsiElement processAllOriginalElements(@NotNull PsiElement element, @NotNull Function<? super PsiElement, ? extends PsiElement> processor) {
        if (element == null) {
            EditSourceUtil.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            EditSourceUtil.$$$reportNull$$$0(4);
        }
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            for (PsiElement psiElement : filter.getOriginalElements(element)) {
                PsiElement apply = processor.apply(psiElement);
                if (apply == null) continue;
                return apply;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/EditSourceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNavigatableOriginalElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllOriginalElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

