/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.nls;

import com.ibm.icu.number.FormattedNumber;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import com.intellij.DynamicBundle;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NlsMessages {
    private static final MeasureUnit[] TIME_UNITS = new MeasureUnit[]{MeasureUnit.MILLISECOND, MeasureUnit.SECOND, MeasureUnit.MINUTE, MeasureUnit.HOUR, MeasureUnit.DAY};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};
    private static final int[] PADDED_FORMATS = new int[]{3, 2, 2, 2, 1};

    @NotNull
    @Nls
    public static String formatAndList(Collection<?> list) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.WIDE).format(list);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String formatNarrowAndList(Collection<?> list) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.AND, (ListFormatter.Width)ListFormatter.Width.NARROW).format(list);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String formatOrList(Collection<?> list) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.OR, (ListFormatter.Width)ListFormatter.Width.WIDE).format(list);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningAnd() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatAndList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(3);
        }
        return collector;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningNarrowAnd() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatNarrowAndList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(4);
        }
        return collector;
    }

    public static <T> @NotNull Collector<T, ?, @Nls String> joiningOr() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), NlsMessages::formatOrList);
        if (collector == null) {
            NlsMessages.$$$reportNull$$$0(5);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationApproximate(long duration) {
        return NlsMessages.formatDuration(duration, 2);
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDuration(long duration) {
        return NlsMessages.formatDuration(duration, Integer.MAX_VALUE);
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    private static String formatDuration(long duration, int maxFragments) {
        long multiplier;
        int i;
        TLongArrayList unitValues = new TLongArrayList();
        TIntArrayList unitIndices = new TIntArrayList();
        long count = duration;
        for (i = 1; i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder == 0L && unitValues.isEmpty()) continue;
            unitValues.insert(0, remainder);
            unitIndices.insert(0, i - 1);
        }
        unitValues.insert(0, count);
        unitIndices.insert(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.get(maxFragments - 1);
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.get(maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.get(maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return NlsMessages.formatDuration(duration + increment, maxFragments);
            }
        }
        MeasureFormat format = MeasureFormat.getInstance((Locale)DynamicBundle.getLocale(), (MeasureFormat.FormatWidth)MeasureFormat.FormatWidth.SHORT);
        Measure[] measures = new Measure[Math.min(unitValues.size(), maxFragments)];
        for (i = 0; i < measures.length; ++i) {
            measures[i] = new Measure((Number)unitValues.get(i), TIME_UNITS[unitIndices.get(i)]);
        }
        String string = format.formatMeasures(measures);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String formatDurationPadded(long millis) {
        long multiplier;
        int i;
        long millisIn = 1L;
        for (i = 1; i < TIME_MULTIPLIERS.length && millis >= (millisIn *= (multiplier = TIME_MULTIPLIERS[i])); ++i) {
        }
        long d = millis;
        LocalizedNumberFormatter formatter = (LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)DynamicBundle.getLocale()).unitWidth(NumberFormatter.UnitWidth.NARROW);
        ArrayList<FormattedNumber> result = new ArrayList<FormattedNumber>();
        --i;
        while (i >= 0) {
            long multiplier2 = i == TIME_MULTIPLIERS.length - 1 ? 1L : TIME_MULTIPLIERS[i + 1];
            long value = d / (millisIn /= multiplier2);
            d %= millisIn;
            IntegerWidth style = IntegerWidth.zeroFillTo((int)(result.isEmpty() ? 1 : PADDED_FORMATS[i]));
            LocalizedNumberFormatter unitFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)formatter.unit(TIME_UNITS[i])).integerWidth(style);
            result.add(unitFormatter.format(value));
            --i;
        }
        String string = ListFormatter.getInstance((Locale)Locale.getDefault(), (ListFormatter.Type)ListFormatter.Type.UNITS, (ListFormatter.Width)ListFormatter.Width.NARROW).format(result);
        if (string == null) {
            NlsMessages.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/nls/NlsMessages";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAndList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNarrowAndList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatOrList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningAnd";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningNarrowAnd";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "joiningOr";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPadded";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

