/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;

public class MultipleCheckboxOptionsPanel
extends JPanel {
    private final OptionAccessor myOptionAccessor;

    public MultipleCheckboxOptionsPanel(InspectionProfileEntry owner) {
        this(new OptionAccessor.Default(owner));
    }

    public MultipleCheckboxOptionsPanel(OptionAccessor optionAccessor) {
        super(new GridBagLayout());
        this.myOptionAccessor = optionAccessor;
    }

    public void addCheckbox(@NlsContexts.Checkbox String label, @NonNls String property) {
        this.addCheckboxEx(label, property);
    }

    public JCheckBox addCheckboxEx(@NlsContexts.Checkbox String label, @NonNls String property) {
        boolean selected = this.myOptionAccessor.getOption(property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        checkBox.addItemListener(e -> this.myOptionAccessor.setOption(property, e.getStateChange() == 1));
        this.addComponent(checkBox);
        return checkBox;
    }

    public JCheckBox addDependentCheckBox(@NlsContexts.Checkbox String label, @NonNls String property, JCheckBox controller2) {
        JCheckBox checkBox = this.addCheckboxEx(label, property);
        checkBox.setBorder(new EmptyBorder((Insets)new JBInsets(0, 30, 0, 0)));
        controller2.addItemListener(e -> checkBox.setEnabled(((JCheckBox)e.getSource()).isEnabled() && e.getStateChange() == 1));
        checkBox.setEnabled(controller2.isEnabled() && controller2.isSelected());
        return checkBox;
    }

    public void addComponent(JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        Component[] components = this.getComponents();
        this.removeAll();
        for (Component component1 : components) {
            this.add(component1, constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        this.add((Component)component, constraints);
    }
}

