/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="InlayHintsSettings", storages={@Storage(value="editor.xml")})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003012B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J9\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u0004\u0018\u00010\fJ-\u0010\u001c\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\t2\u0006\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\t2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u0002H\u0017H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0002H\u0016J\u001a\u0010#\u001a\u00020\u00152\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020\u0015J\u001a\u0010%\u001a\u00020\u00152\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0002H\u0016J\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u0015J\u0016\u0010,\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0015J3\u0010-\u001a\u00020\u000f\"\b\b\u0000\u0010\u0017*\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u0002H\u0017\u00a2\u0006\u0002\u0010/R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/codeInsight/hints/InlayHintsSettings$State;", "()V", "listener", "Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "getListener", "()Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "lock", "", "myCachedSettingsMap", "", "", "myState", "changeHintTypeStatus", "", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "language", "Lcom/intellij/lang/Language;", "enable", "", "findSettings", "T", "createSettings", "Lkotlin/Function0;", "(Lcom/intellij/codeInsight/hints/SettingsKey;Lcom/intellij/lang/Language;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getLastViewedProviderId", "getSettingCached", "id", "settings", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getSettingNotCached", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getState", "hintsEnabled", "hintsEnabledGlobally", "hintsShouldBeShown", "loadState", "state", "saveLastViewedProviderId", "providerId", "setEnabledGlobally", "enabled", "setHintsEnabledForLanguage", "storeSettings", "value", "(Lcom/intellij/codeInsight/hints/SettingsKey;Lcom/intellij/lang/Language;Ljava/lang/Object;)V", "Companion", "SettingsListener", "State", "intellij.platform.lang"})
public final class InlayHintsSettings
implements PersistentStateComponent<State> {
    private State myState = new State();
    private final Object lock = new Object();
    private final Map<String, Object> myCachedSettingsMap;
    @NotNull
    private static final Topic<SettingsListener> INLAY_SETTINGS_CHANGED;
    public static final Companion Companion;

    private final SettingsListener getListener() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        Object object = application.getMessageBus().syncPublisher(INLAY_SETTINGS_CHANGED);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026r(INLAY_SETTINGS_CHANGED)");
        return (SettingsListener)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changeHintTypeStatus(@NotNull SettingsKey<?> key, @NotNull Language language, boolean enable) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            String id = key.getFullId(language);
            bl2 = enable ? this.myState.getDisabledHintProviderIds().remove(id) : this.myState.getDisabledHintProviderIds().add(id);
        }
        this.getListener().settingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHintsEnabledForLanguage(@NotNull Language language, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.id");
            String id = string;
            bl2 = enabled ? this.myState.getDisabledLanguages().remove(id) : this.myState.getDisabledLanguages().add(id);
        }
        boolean settingsChanged = bl2;
        if (settingsChanged) {
            this.getListener().languageStatusChanged();
            this.getListener().settingsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveLastViewedProviderId(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.myState.setLastViewedProviderKeyId(providerId);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final String getLastViewedProviderId() {
        return this.myState.getLastViewedProviderKeyId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEnabledGlobally(boolean enabled) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3;
            boolean bl4 = false;
            if (this.myState.isEnabled() != enabled) {
                this.myState.setEnabled(enabled);
                this.getListener().globalEnabledStatusChanged(enabled);
                bl3 = true;
            } else {
                bl3 = false;
            }
            bl2 = bl3;
        }
        boolean settingsChanged = bl2;
        if (settingsChanged) {
            this.getListener().settingsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsEnabledGlobally() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = this.myState.isEnabled();
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T findSettings(@NotNull SettingsKey<T> key, @NotNull Language language, @NotNull Function0<? extends T> createSettings) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(createSettings, (String)"createSettings");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            String fullId = key.getFullId(language);
            T t = this.getSettingCached(fullId, createSettings);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void storeSettings(@NotNull SettingsKey<T> key, @NotNull Language language, @NotNull T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            String fullId = key.getFullId(language);
            this.myCachedSettingsMap.put(fullId, value);
            Element element = this.myState.getSettingsMapElement().clone();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"myState.settingsMapElement.clone()");
            Element element2 = element;
            element2.removeChild(fullId);
            Element serialized = XmlSerializer.serialize$default(value, null, false, 6, null);
            if (serialized != null) {
                Element storeElement = new Element(fullId);
                Element wrappedSettingsElement = storeElement.addContent(serialized);
                Element element3 = element2.addContent(wrappedSettingsElement);
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"element.addContent(wrappedSettingsElement)");
                this.myState.setSettingsMapElement(element3);
                boolean bl4 = false;
                element2.sortAttributes(new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Attribute it = (Attribute)a;
                        boolean bl2 = false;
                        Attribute attribute = it;
                        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"it");
                        it = (Attribute)b;
                        Comparable comparable = (Comparable)((Object)attribute.getName());
                        bl2 = false;
                        Attribute attribute2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"it");
                        Comparable comparable2 = (Comparable)((Object)attribute2.getName());
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)comparable2);
                    }
                });
            } else {
                this.myState.setSettingsMapElement(element2);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.getListener().settingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsEnabled(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = !this.myState.getDisabledLanguages().contains(language.getID());
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsShouldBeShown(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block4: {
                boolean bl3 = false;
                if (this.hintsEnabledGlobally()) break block4;
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = this.hintsEnabled(language);
            return bl5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean hintsEnabled(@NotNull SettingsKey<?> key, @NotNull Language language) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Language lang = language;
            while (lang != null) {
                if (this.myState.getDisabledHintProviderIds().contains(key.getFullId(lang))) {
                    return false;
                }
                lang = lang.getBaseLanguage();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hintsShouldBeShown(@NotNull SettingsKey<?> key, @NotNull Language language) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl3 = false;
                    if (this.hintsEnabledGlobally()) break block5;
                    boolean bl4 = false;
                    return bl4;
                }
                if (this.hintsEnabled(language)) break block6;
                boolean bl5 = false;
                return bl5;
            }
            boolean bl6 = this.hintsEnabled(key, language);
            return bl6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public State getState() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            State state = this.myState;
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean elementChanged = Intrinsics.areEqual((Object)this.myState.getSettingsMapElement(), (Object)state.getSettingsMapElement()) ^ true;
            if (elementChanged) {
                this.myCachedSettingsMap.clear();
            }
            this.myState = state;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> T getSettingCached(String id, Function0<? extends T> settings) {
        Object cachedValue = this.myCachedSettingsMap.get(id);
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        return (T)this.getSettingNotCached(id, settings.invoke());
    }

    private final <T> T getSettingNotCached(String id, T settings) {
        Element state = this.myState.getSettingsMapElement();
        Element element = state.getChild(id);
        if (element == null) {
            return settings;
        }
        Element settingsElement = element;
        List settingsElementChildren = settingsElement.getChildren();
        if (settingsElementChildren.isEmpty()) {
            return settings;
        }
        List list = settingsElementChildren;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"settingsElementChildren");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settingsElementChildren.first()");
        XmlSerializer.deserializeInto((Element)object, settings);
        this.myCachedSettingsMap.put(id, settings);
        return settings;
    }

    public InlayHintsSettings() {
        boolean bl = false;
        this.myCachedSettingsMap = new HashMap();
    }

    static {
        Companion = new Companion(null);
        INLAY_SETTINGS_CHANGED = new Topic(SettingsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    }

    @JvmStatic
    @NotNull
    public static final InlayHintsSettings instance() {
        return Companion.instance();
    }

    @NotNull
    public static final Topic<SettingsListener> getINLAY_SETTINGS_CHANGED() {
        Companion companion = Companion;
        return INLAY_SETTINGS_CHANGED;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings$State;", "", "()V", "disabledHintProviderIds", "Ljava/util/TreeSet;", "", "getDisabledHintProviderIds", "()Ljava/util/TreeSet;", "setDisabledHintProviderIds", "(Ljava/util/TreeSet;)V", "disabledLanguages", "getDisabledLanguages", "setDisabledLanguages", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "lastViewedProviderKeyId", "getLastViewedProviderKeyId", "()Ljava/lang/String;", "setLastViewedProviderKeyId", "(Ljava/lang/String;)V", "settingsMapElement", "Lorg/jdom/Element;", "getSettingsMapElement", "()Lorg/jdom/Element;", "setSettingsMapElement", "(Lorg/jdom/Element;)V", "intellij.platform.lang"})
    public static final class State {
        @NotNull
        private TreeSet<String> disabledHintProviderIds = SetsKt.sortedSetOf((Object[])new String[0]);
        @NotNull
        private Element settingsMapElement = new Element("settingsMapElement");
        @Nullable
        private String lastViewedProviderKeyId;
        private boolean isEnabled = true;
        @NotNull
        private TreeSet<String> disabledLanguages = SetsKt.sortedSetOf((Object[])new String[0]);

        @NotNull
        public final TreeSet<String> getDisabledHintProviderIds() {
            return this.disabledHintProviderIds;
        }

        public final void setDisabledHintProviderIds(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.disabledHintProviderIds = treeSet;
        }

        @NotNull
        public final Element getSettingsMapElement() {
            return this.settingsMapElement;
        }

        public final void setSettingsMapElement(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"<set-?>");
            this.settingsMapElement = element;
        }

        @Nullable
        public final String getLastViewedProviderKeyId() {
            return this.lastViewedProviderKeyId;
        }

        public final void setLastViewedProviderKeyId(@Nullable String string) {
            this.lastViewedProviderKeyId = string;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        @NotNull
        public final TreeSet<String> getDisabledLanguages() {
            return this.disabledLanguages;
        }

        public final void setDisabledLanguages(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.disabledLanguages = treeSet;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "", "globalEnabledStatusChanged", "", "newEnabled", "", "languageStatusChanged", "settingsChanged", "intellij.platform.lang"})
    public static interface SettingsListener {
        public void globalEnabledStatusChanged(boolean var1);

        public void languageStatusChanged();

        public void settingsChanged();

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void globalEnabledStatusChanged(@NotNull SettingsListener $this, boolean newEnabled) {
            }

            public static void languageStatusChanged(@NotNull SettingsListener $this) {
            }

            public static void settingsChanged(@NotNull SettingsListener $this) {
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSettings$Companion;", "", "()V", "INLAY_SETTINGS_CHANGED", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/codeInsight/hints/InlayHintsSettings$SettingsListener;", "getINLAY_SETTINGS_CHANGED$annotations", "getINLAY_SETTINGS_CHANGED", "()Lcom/intellij/util/messages/Topic;", "instance", "Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final InlayHintsSettings instance() {
            Object object = ApplicationManager.getApplication().getService(InlayHintsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026intsSettings::class.java)");
            return (InlayHintsSettings)object;
        }

        @JvmStatic
        public static /* synthetic */ void getINLAY_SETTINGS_CHANGED$annotations() {
        }

        @NotNull
        public final Topic<SettingsListener> getINLAY_SETTINGS_CHANGED() {
            return INLAY_SETTINGS_CHANGED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

