/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHRepositoryOwnerName;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermission;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLPagedRequestResponse;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.api.data.request.search.GithubIssueSearchType;
import org.jetbrains.plugins.github.api.util.GithubApiSearchQueryBuilder;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHGQLPagedListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository$acquireContext$;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderRepositoryImpl;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManagerImpl;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListETagUpdateChecker;
import org.jetbrains.plugins.github.pullrequest.data.GHPRSearchQuery;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCommentServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateServiceImpl;
import org.jetbrains.plugins.github.pullrequest.search.GHPRSearchQueryHolderImpl;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J0\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000eH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "repositories", "", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "acquireContext", "Ljava/util/concurrent/CompletableFuture;", "repository", "remote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "clearContext", "", "findContext", "repositoryCoordinates", "loadContext", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "parsedRepositoryCoordinates", "remoteCoordinates", "Companion", "intellij.vcs.github"})
public final class GHPRDataContextRepository {
    private final Map<GHRepositoryCoordinates, LazyCancellableBackgroundProcessValue<GHPRDataContext>> repositories;
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    @RequiresEdt
    @NotNull
    public final CompletableFuture<GHPRDataContext> acquireContext(@NotNull GHRepositoryCoordinates repository, @NotNull GitRemoteUrlCoordinates remote, @NotNull GithubAccount account, @NotNull GithubApiRequestExecutor requestExecutor) {
        LazyCancellableBackgroundProcessValue<GHPRDataContext> lazyCancellableBackgroundProcessValue;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Map<GHRepositoryCoordinates, LazyCancellableBackgroundProcessValue<GHPRDataContext>> $this$getOrPut$iv = this.repositories;
        boolean $i$f$getOrPut = false;
        LazyCancellableBackgroundProcessValue<GHPRDataContext> value$iv = $this$getOrPut$iv.get(repository);
        if (value$iv == null) {
            boolean bl = false;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
            Disposable contextDisposable = disposable;
            LazyCancellableBackgroundProcessValue lazyCancellableBackgroundProcessValue2 = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GHPRDataContext>>(contextDisposable, this, account, requestExecutor, repository, remote){
                final /* synthetic */ Disposable $contextDisposable;
                final /* synthetic */ GHPRDataContextRepository this$0;
                final /* synthetic */ GithubAccount $account$inlined;
                final /* synthetic */ GithubApiRequestExecutor $requestExecutor$inlined;
                final /* synthetic */ GHRepositoryCoordinates $repository$inlined;
                final /* synthetic */ GitRemoteUrlCoordinates $remote$inlined;
                {
                    this.$contextDisposable = disposable;
                    this.this$0 = gHPRDataContextRepository;
                    this.$account$inlined = githubAccount;
                    this.$requestExecutor$inlined = githubApiRequestExecutor;
                    this.$repository$inlined = gHRepositoryCoordinates;
                    this.$remote$inlined = gitRemoteUrlCoordinates;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<GHPRDataContext> invoke(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                    return GithubAsyncUtilKt.successOnEdt$default(GithubAsyncUtilKt.submitIOTask(progressManager, indicator, (Function1)new Function1<ProgressIndicator, GHPRDataContext>(this, indicator){
                        final /* synthetic */ acquireContext$$inlined$getOrPut$lambda$1 this$0;
                        final /* synthetic */ ProgressIndicator $indicator;
                        {
                            this.this$0 = var1_1;
                            this.$indicator = progressIndicator;
                            super(1);
                        }

                        @NotNull
                        public final GHPRDataContext invoke(@NotNull ProgressIndicator it) {
                            GHPRDataContext gHPRDataContext;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            try {
                                gHPRDataContext = GHPRDataContextRepository.access$loadContext(this.this$0.this$0, this.$indicator, this.this$0.$account$inlined, this.this$0.$requestExecutor$inlined, this.this$0.$repository$inlined, this.this$0.$remote$inlined);
                            }
                            catch (Exception e) {
                                if (!(e instanceof ProcessCanceledException)) {
                                    GHPRDataContextRepository.access$getLOG$cp().info("Error occurred while creating data context", (Throwable)e);
                                }
                                throw (Throwable)e;
                            }
                            return gHPRDataContext;
                        }
                    }), null, (Function1)new Function1<GHPRDataContext, GHPRDataContext>(this){
                        final /* synthetic */ acquireContext$$inlined$getOrPut$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        @NotNull
                        public final GHPRDataContext invoke(@NotNull GHPRDataContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            if (Disposer.isDisposed((Disposable)this.this$0.$contextDisposable)) {
                                Disposer.dispose((Disposable)ctx);
                            } else {
                                Disposer.register((Disposable)this.this$0.$contextDisposable, (Disposable)ctx);
                            }
                            return ctx;
                        }
                    }, 1, null);
                }
            });
            boolean bl2 = false;
            boolean bl3 = false;
            LazyCancellableBackgroundProcessValue it = lazyCancellableBackgroundProcessValue2;
            boolean bl4 = false;
            it.addDropEventListener((Function0<Unit>)((Function0)new Function0<Unit>(contextDisposable){
                final /* synthetic */ Disposable $contextDisposable$inlined;
                {
                    this.$contextDisposable$inlined = disposable;
                    super(0);
                }

                public final void invoke() {
                    Disposer.dispose((Disposable)this.$contextDisposable$inlined);
                }
            }));
            LazyCancellableBackgroundProcessValue answer$iv = lazyCancellableBackgroundProcessValue2;
            $this$getOrPut$iv.put(repository, answer$iv);
            lazyCancellableBackgroundProcessValue = answer$iv;
        } else {
            lazyCancellableBackgroundProcessValue = value$iv;
        }
        CompletableFuture completableFuture = (CompletableFuture)lazyCancellableBackgroundProcessValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"repositories.getOrPut(re\u2026    }\n      }\n    }.value");
        return completableFuture;
    }

    @RequiresEdt
    public final void clearContext(@NotNull GHRepositoryCoordinates repository) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            LazyCancellableBackgroundProcessValue<GHPRDataContext> lazyCancellableBackgroundProcessValue = this.repositories.remove(repository);
            if (lazyCancellableBackgroundProcessValue == null) break block0;
            lazyCancellableBackgroundProcessValue.drop();
        }
    }

    @RequiresBackgroundThread
    private final GHPRDataContext loadContext(ProgressIndicator indicator, GithubAccount account, GithubApiRequestExecutor requestExecutor, GHRepositoryCoordinates parsedRepositoryCoordinates, GitRemoteUrlCoordinates remoteCoordinates) throws IOException {
        indicator.setText(GithubBundle.message("pull.request.loading.account.info", new Object[0]));
        GithubAuthenticatedUser accountDetails2 = GithubAccountInformationProvider.Companion.getInstance().getInformation(requestExecutor, indicator, account);
        indicator.checkCanceled();
        indicator.setText(GithubBundle.message("pull.request.loading.repo.info", new Object[0]));
        GithubServerPath githubServerPath = account.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
        GHRepositoryPermission gHRepositoryPermission = (GHRepositoryPermission)requestExecutor.execute(indicator, (GithubApiRequest)GHGQLRequests.Repo.INSTANCE.findPermission(new GHRepositoryCoordinates(githubServerPath, parsedRepositoryCoordinates.getRepositoryPath())));
        if (gHRepositoryPermission == null) {
            throw (Throwable)new IllegalArgumentException("Repository " + parsedRepositoryCoordinates.getRepositoryPath() + " does not exist at " + account.getServer() + " or you don't have access.");
        }
        GHRepositoryPermission repoWithPermissions = gHRepositoryPermission;
        String string = accountDetails2.getNodeId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"accountDetails.nodeId");
        String string2 = accountDetails2.getLogin();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"accountDetails.login");
        String string3 = accountDetails2.getHtmlUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"accountDetails.htmlUrl");
        String string4 = accountDetails2.getAvatarUrl();
        Intrinsics.checkNotNull((Object)string4);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"accountDetails.avatarUrl!!");
        GHUser currentUser = new GHUser(string, string2, string3, string4, accountDetails2.getName());
        indicator.setText(GithubBundle.message("pull.request.loading.user.teams.info", new Object[0]));
        GHRepositoryOwnerName repoOwner = repoWithPermissions.getOwner();
        List<GHTeam> currentUserTeams2 = repoOwner instanceof GHRepositoryOwnerName.Organization ? new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GHGQLPagedRequestResponse<? extends GHTeam>>>(account, repoOwner, currentUser){
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GHRepositoryOwnerName $repoOwner;
            final /* synthetic */ GHUser $currentUser;

            @NotNull
            public final GithubApiRequest.Post<GHGQLPagedRequestResponse<GHTeam>> invoke(@NotNull GHGQLRequestPagination it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                return GHGQLRequests.Organization.Team.INSTANCE.findByUserLogins(githubServerPath, this.$repoOwner.getLogin(), CollectionsKt.listOf((Object)this.$currentUser.getLogin()), it);
            }
            {
                this.$account = githubAccount;
                this.$repoOwner = gHRepositoryOwnerName;
                this.$currentUser = gHUser;
                super(1);
            }
        }, false, 0, 12, null).loadAll(indicator) : CollectionsKt.emptyList();
        indicator.checkCanceled();
        GHRepositoryPath apiRepositoryPath = repoWithPermissions.getPath();
        GithubServerPath githubServerPath2 = account.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath2, (String)"account.server");
        GHRepositoryCoordinates apiRepositoryCoordinates = new GHRepositoryCoordinates(githubServerPath2, apiRepositoryPath);
        GHPRSecurityServiceImpl securityService = new GHPRSecurityServiceImpl(GithubSharedProjectSettings.Companion.getInstance(this.project), account, currentUser, currentUserTeams2, repoWithPermissions);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        GHPRDetailsServiceImpl detailsService = new GHPRDetailsServiceImpl(progressManager, requestExecutor, apiRepositoryCoordinates);
        ProgressManager progressManager2 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager2, (String)"ProgressManager.getInstance()");
        GHPRSecurityService gHPRSecurityService = securityService;
        GithubServerPath githubServerPath3 = account.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath3, (String)"account.server");
        GHPRStateServiceImpl stateService = new GHPRStateServiceImpl(progressManager2, gHPRSecurityService, requestExecutor, githubServerPath3, apiRepositoryPath);
        ProgressManager progressManager3 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager3, (String)"ProgressManager.getInstance()");
        GHPRCommentServiceImpl commentService = new GHPRCommentServiceImpl(progressManager3, requestExecutor, apiRepositoryCoordinates);
        ProgressManager progressManager4 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager4, (String)"ProgressManager.getInstance()");
        GHPRChangesServiceImpl changesService = new GHPRChangesServiceImpl(progressManager4, this.project, requestExecutor, remoteCoordinates, apiRepositoryCoordinates);
        ProgressManager progressManager5 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager5, (String)"ProgressManager.getInstance()");
        GHPRReviewServiceImpl reviewService = new GHPRReviewServiceImpl(progressManager5, securityService, requestExecutor, apiRepositoryCoordinates);
        GHPRSearchQueryHolderImpl gHPRSearchQueryHolderImpl = new GHPRSearchQueryHolderImpl();
        boolean bl = false;
        boolean bl2 = false;
        GHPRSearchQueryHolderImpl $this$apply = gHPRSearchQueryHolderImpl;
        boolean bl3 = false;
        $this$apply.setQuery(GHPRSearchQuery.Companion.getDEFAULT());
        GHPRSearchQueryHolderImpl searchHolder = gHPRSearchQueryHolderImpl;
        ProgressManager progressManager6 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager6, (String)"ProgressManager.getInstance()");
        GHGQLPagedListLoader listLoader2 = new GHGQLPagedListLoader(progressManager6, new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GHGQLPagedRequestResponse<? extends GHPullRequestShort>>>(account, apiRepositoryPath, searchHolder){
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GHRepositoryPath $apiRepositoryPath;
            final /* synthetic */ GHPRSearchQueryHolderImpl $searchHolder;

            @NotNull
            public final GithubApiRequest.Post<GHGQLPagedRequestResponse<GHPullRequestShort>> invoke(@NotNull GHGQLRequestPagination p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                return GHGQLRequests.PullRequest.INSTANCE.search(githubServerPath, org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository$Companion.access$buildQuery(GHPRDataContextRepository.Companion, this.$apiRepositoryPath, this.$searchHolder.getQuery()), p);
            }
            {
                this.$account = githubAccount;
                this.$apiRepositoryPath = gHRepositoryPath;
                this.$searchHolder = gHPRSearchQueryHolderImpl;
                super(1);
            }
        }, false, 0, 12, null));
        ProgressManager progressManager7 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager7, (String)"ProgressManager.getInstance()");
        GithubServerPath githubServerPath4 = account.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath4, (String)"account.server");
        GHPRListETagUpdateChecker listUpdatesChecker = new GHPRListETagUpdateChecker(progressManager7, requestExecutor, githubServerPath4, apiRepositoryPath);
        GHPRDataProviderRepositoryImpl dataProviderRepository2 = new GHPRDataProviderRepositoryImpl(detailsService, stateService, reviewService, commentService, changesService, (Function1<? super GHPRIdentifier, ? extends GHListLoader<GHPRTimelineItem>>)((Function1)new Function1<GHPRIdentifier, GHListLoader<GHPRTimelineItem>>(requestExecutor, account, apiRepositoryPath){
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GHRepositoryPath $apiRepositoryPath;

            @NotNull
            public final GHListLoader<GHPRTimelineItem> invoke(@NotNull GHPRIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                return new GHGQLPagedListLoader<T>(progressManager, new SimpleGHGQLPagesLoader<T>(this.$requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GHGQLPagedRequestResponse<? extends GHPRTimelineItem>>>(this, id){
                    final /* synthetic */ loadContext.dataProviderRepository.1 this$0;
                    final /* synthetic */ GHPRIdentifier $id;

                    @NotNull
                    public final GithubApiRequest.Post<GHGQLPagedRequestResponse<GHPRTimelineItem>> invoke(@NotNull GHGQLRequestPagination p) {
                        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                        GithubServerPath githubServerPath = this.this$0.$account.getServer();
                        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                        return GHGQLRequests.PullRequest.Timeline.INSTANCE.items(githubServerPath, this.this$0.$apiRepositoryPath.getOwner(), this.this$0.$apiRepositoryPath.getRepository(), this.$id.getNumber(), p);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$id = gHPRIdentifier;
                        super(1);
                    }
                }, true, 0, 8, null));
            }
            {
                this.$requestExecutor = githubApiRequestExecutor;
                this.$account = githubAccount;
                this.$apiRepositoryPath = gHRepositoryPath;
                super(1);
            }
        }));
        ProgressManager progressManager8 = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager8, (String)"ProgressManager.getInstance()");
        GithubServerPath githubServerPath5 = account.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath5, (String)"account.server");
        GHPRRepositoryDataServiceImpl repoDataService = new GHPRRepositoryDataServiceImpl(progressManager8, requestExecutor, githubServerPath5, apiRepositoryPath, repoOwner);
        CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory = new CachingGithubAvatarIconsProvider.Factory(CachingGithubUserAvatarLoader.Companion.getInstance(), GithubImageResizer.Companion.getInstance(), requestExecutor);
        GHPRFilesManagerImpl filesManager = new GHPRFilesManagerImpl(this.project, parsedRepositoryCoordinates);
        indicator.checkCanceled();
        return new GHPRDataContext(parsedRepositoryCoordinates, remoteCoordinates, searchHolder, listLoader2, listUpdatesChecker, dataProviderRepository2, securityService, repoDataService, avatarIconsProviderFactory, filesManager);
    }

    @RequiresEdt
    @Nullable
    public final GHPRDataContext findContext(@NotNull GHRepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        LazyCancellableBackgroundProcessValue<GHPRDataContext> lazyCancellableBackgroundProcessValue = this.repositories.get(repositoryCoordinates);
        return lazyCancellableBackgroundProcessValue != null ? lazyCancellableBackgroundProcessValue.getLastLoadedValue() : null;
    }

    public GHPRDataContextRepository(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        this.repositories = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRDataContextRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ GHPRDataContext access$loadContext(GHPRDataContextRepository $this, ProgressIndicator indicator, GithubAccount account, GithubApiRequestExecutor requestExecutor, GHRepositoryCoordinates parsedRepositoryCoordinates, GitRemoteUrlCoordinates remoteCoordinates) {
        return $this.loadContext(indicator, account, requestExecutor, parsedRepositoryCoordinates, remoteCoordinates);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildQuery", "", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "searchQuery", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery;", "getInstance", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHPRDataContextRepository getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GHPRDataContextRepository.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (GHPRDataContextRepository)object;
        }

        private final String buildQuery(GHRepositoryPath repoPath, GHPRSearchQuery searchQuery) {
            return GithubApiSearchQueryBuilder.Companion.searchQuery((Function1<? super GithubApiSearchQueryBuilder, Unit>)((Function1)new Function1<GithubApiSearchQueryBuilder, Unit>(repoPath, searchQuery){
                final /* synthetic */ GHRepositoryPath $repoPath;
                final /* synthetic */ GHPRSearchQuery $searchQuery;

                public final void invoke(@NotNull GithubApiSearchQueryBuilder $this$searchQuery) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)$this$searchQuery, (String)"$receiver");
                        $this$searchQuery.qualifier("type", GithubIssueSearchType.pr.name());
                        $this$searchQuery.qualifier("repo", this.$repoPath.toString());
                        GHPRSearchQuery gHPRSearchQuery = this.$searchQuery;
                        if (gHPRSearchQuery == null) break block0;
                        gHPRSearchQuery.buildApiSearchQuery($this$searchQuery);
                    }
                }
                {
                    this.$repoPath = gHRepositoryPath;
                    this.$searchQuery = gHPRSearchQuery;
                    super(1);
                }
            }));
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$buildQuery(Companion $this, GHRepositoryPath repoPath, GHPRSearchQuery searchQuery) {
            return $this.buildQuery(repoPath, searchQuery);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

