/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"loadAssociatedRepos", "", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadWatchedReposSkipErrors", "intellij.vcs.github"})
public final class GHRepositoryHostingServiceKt {
    private static final List<GithubRepo> loadAssociatedRepos(GithubAccount $this$loadAssociatedRepos, GithubApiRequestExecutor executor, ProgressIndicator indicator) {
        GithubServerPath githubServerPath = $this$loadAssociatedRepos.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"server");
        return GithubApiPagesLoader.loadAll(executor, indicator, GithubApiRequests.CurrentUser.Repos.pages$default(githubServerPath, null, null, null, null, 30, null));
    }

    private static final List<GithubRepo> loadWatchedReposSkipErrors(GithubAccount $this$loadWatchedReposSkipErrors, GithubApiRequestExecutor executor, ProgressIndicator indicator) {
        List<GithubRepo> list2;
        try {
            GithubServerPath githubServerPath = $this$loadWatchedReposSkipErrors.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"server");
            list2 = GithubApiPagesLoader.loadAll(executor, indicator, GithubApiRequests.CurrentUser.RepoSubs.pages(githubServerPath));
        }
        catch (GithubAuthenticationException e) {
            list2 = CollectionsKt.emptyList();
        }
        catch (GithubStatusCodeException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static final /* synthetic */ List access$loadAssociatedRepos(GithubAccount $this$access_u24loadAssociatedRepos, GithubApiRequestExecutor executor, ProgressIndicator indicator) {
        return GHRepositoryHostingServiceKt.loadAssociatedRepos($this$access_u24loadAssociatedRepos, executor, indicator);
    }

    public static final /* synthetic */ List access$loadWatchedReposSkipErrors(GithubAccount $this$access_u24loadWatchedReposSkipErrors, GithubApiRequestExecutor executor, ProgressIndicator indicator) {
        return GHRepositoryHostingServiceKt.loadWatchedReposSkipErrors($this$access_u24loadWatchedReposSkipErrors, executor, indicator);
    }
}

