/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.io.Flushable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class Flushables {
    private static Logger logger = Logger.getLogger(Flushables.class.getCanonicalName());

    private Flushables() {
    }

    public static void flushQuietly(Flushable ... flushables) {
        for (Flushable f : flushables) {
            Flushables.flush(f);
        }
    }

    private static void flush(@Nullable Flushable f) {
        if (f == null) {
            return;
        }
        try {
            f.flush();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Error occurred while flushing " + f, t);
        }
    }
}

