/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.internal.filter.eval.ExpressionEvaluator;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArrayEvalFilter
extends PathTokenFilter {
    private static final Pattern PATTERN = Pattern.compile("(.*?)\\s?([=<>]+)\\s?(.*)");

    public ArrayEvalFilter(String condition) {
        super(condition);
    }

    @Override
    public Object filter(Object obj, JsonProvider jsonProvider) {
        List<Object> src = jsonProvider.toList(obj);
        List<Object> result = jsonProvider.createList();
        String trimmedCondition = this.condition;
        if (this.condition.contains("['")) {
            trimmedCondition = trimmedCondition.replace("['", ".");
            trimmedCondition = trimmedCondition.replace("']", "");
        }
        trimmedCondition = this.trim(trimmedCondition, 5, 2);
        ConditionStatement conditionStatement = this.createConditionStatement(trimmedCondition);
        for (Object item : src) {
            if (!this.isMatch(item, conditionStatement, jsonProvider)) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public Object getRef(Object obj, JsonProvider jsonProvider) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }

    private boolean isMatch(Object check, ConditionStatement conditionStatement, JsonProvider jsonProvider) {
        if (!jsonProvider.isMap(check)) {
            return false;
        }
        Map<String, Object> obj = jsonProvider.toMap(check);
        if (!obj.containsKey(conditionStatement.getField())) {
            return false;
        }
        Object propertyValue = obj.get(conditionStatement.getField());
        if (jsonProvider.isContainer(propertyValue)) {
            return false;
        }
        return ExpressionEvaluator.eval(propertyValue, conditionStatement.getOperator(), conditionStatement.getExpected());
    }

    private ConditionStatement createConditionStatement(String str) {
        Matcher matcher = PATTERN.matcher(str);
        if (matcher.matches()) {
            String property = matcher.group(1);
            String operator = matcher.group(2);
            String expected = matcher.group(3);
            return new ConditionStatement(property, operator, expected);
        }
        throw new InvalidPathException("Invalid match " + str);
    }

    private class ConditionStatement {
        private final String field;
        private final String operator;
        private String expected;

        private ConditionStatement(String field, String operator, String expected) {
            this.field = field;
            this.operator = operator.trim();
            this.expected = expected;
            if (this.expected.startsWith("'")) {
                this.expected = ArrayEvalFilter.this.trim(this.expected, 1, 1);
            }
        }

        public String getField() {
            return this.field;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getExpected() {
            return this.expected;
        }
    }
}

