/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.ShTypes;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.psi.ShBlock;
import com.intellij.sh.psi.ShDoBlock;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.psi.ShHeredoc;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShFoldingBuilder
extends CustomFoldingBuilder {
    private static final String DOT_DOT_DOT = "...";
    private static final String BRACE_DOTS = "{...}";
    @NlsSafe
    private static final String DO_DOTS_DONE = "do...done";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            ShFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            ShFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ShFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (!(root instanceof ShFile)) {
            return;
        }
        Collection psiElements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)root, (Class[])new Class[]{ShBlock.class, ShDoBlock.class, ShHeredoc.class, PsiComment.class});
        ShFoldingBuilder.foldHeredoc(descriptors, psiElements, document);
        ShFoldingBuilder.foldComment(descriptors, psiElements, document);
        ShFoldingBuilder.foldBlock(descriptors, psiElements);
    }

    private static void foldHeredoc(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements, @NotNull Document document) {
        if (descriptors == null) {
            ShFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (psiElements == null) {
            ShFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (document == null) {
            ShFoldingBuilder.$$$reportNull$$$0(5);
        }
        psiElements.forEach(element -> {
            if (element instanceof ShHeredoc) {
                PsiElement heredocContent = ((ShHeredoc)element).getHeredocContent();
                if (heredocContent == null) {
                    return;
                }
                TextRange textRange = heredocContent.getTextRange();
                int lineNumber = document.getLineNumber(textRange.getEndOffset());
                int endOffset = document.getLineEndOffset(lineNumber - 1);
                if (textRange.getStartOffset() >= endOffset) {
                    return;
                }
                descriptors.add(new FoldingDescriptor(element.getNode(), TextRange.create((int)textRange.getStartOffset(), (int)endOffset), null, ShFoldingBuilder.getHeredocPlaceholder(heredocContent, document)));
            }
        });
    }

    private static void foldComment(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements, @NotNull Document document) {
        if (descriptors == null) {
            ShFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (psiElements == null) {
            ShFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (document == null) {
            ShFoldingBuilder.$$$reportNull$$$0(8);
        }
        HashSet handledComments = new HashSet();
        psiElements.forEach(element -> {
            if (element instanceof PsiComment && !handledComments.contains(element)) {
                PsiElement nextSibling;
                IElementType elementType;
                PsiElement lastComment = element;
                PsiElement currentElement = element;
                handledComments.add(element);
                while (currentElement.getNextSibling() != null && ((elementType = (nextSibling = currentElement.getNextSibling()).getNode().getElementType()) == ShTypes.LINEFEED || elementType == ShTokenTypes.WHITESPACE || nextSibling instanceof PsiComment)) {
                    if (nextSibling instanceof PsiComment) {
                        handledComments.add(nextSibling);
                        lastComment = nextSibling;
                    }
                    currentElement = nextSibling;
                }
                if (element == lastComment) {
                    return;
                }
                int startOffset = element.getTextRange().getStartOffset();
                int endOffset = lastComment.getTextRange().getEndOffset();
                descriptors.add(new FoldingDescriptor((ASTNode)element.getContainingFile().getNode(), TextRange.create((int)startOffset, (int)endOffset), null, ShFoldingBuilder.getCommentPlaceholder(element, document)));
            }
        });
    }

    private static void foldBlock(@NotNull List<FoldingDescriptor> descriptors, @NotNull Collection<PsiElement> psiElements) {
        if (descriptors == null) {
            ShFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (psiElements == null) {
            ShFoldingBuilder.$$$reportNull$$$0(10);
        }
        psiElements.forEach(element -> {
            if (element instanceof ShBlock || element instanceof ShDoBlock) {
                descriptors.add(new FoldingDescriptor(element, element.getTextRange()));
            }
        });
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType elementType;
        if (node == null) {
            ShFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (range == null) {
            ShFoldingBuilder.$$$reportNull$$$0(12);
        }
        if ((elementType = node.getElementType()) == ShTypes.BLOCK) {
            return BRACE_DOTS;
        }
        if (elementType == ShTypes.DO_BLOCK) {
            return DO_DOTS_DONE;
        }
        return DOT_DOT_DOT;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            ShFoldingBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    private static String getHeredocPlaceholder(@NotNull PsiElement heredocContent, @NotNull Document document) {
        if (heredocContent == null) {
            ShFoldingBuilder.$$$reportNull$$$0(14);
        }
        if (document == null) {
            ShFoldingBuilder.$$$reportNull$$$0(15);
        }
        TextRange textRange = heredocContent.getTextRange();
        int lineNumber = document.getLineNumber(textRange.getStartOffset());
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        return document.getText(TextRange.create((int)startOffset, (int)endOffset)).trim() + DOT_DOT_DOT;
    }

    private static String getCommentPlaceholder(@NotNull PsiElement comment, @NotNull Document document) {
        if (comment == null) {
            ShFoldingBuilder.$$$reportNull$$$0(16);
        }
        if (document == null) {
            ShFoldingBuilder.$$$reportNull$$$0(17);
        }
        TextRange textRange = comment.getTextRange();
        return document.getText(TextRange.create((int)(textRange.getStartOffset() + 1), (int)textRange.getEndOffset())).trim() + DOT_DOT_DOT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocContent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/editor/ShFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "foldHeredoc";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "foldComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "foldBlock";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeredocPlaceholder";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentPlaceholder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

