/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNode;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineWatchNodeImpl
extends WatchNodeImpl
implements InlineWatchNode {
    private final InlineWatch myWatch;
    private final List<Inlay<InlineDebugRenderer>> myInlays;

    public InlineWatchNodeImpl(@NotNull XDebuggerTree tree, @NotNull XDebuggerTreeNode parent, @NotNull InlineWatch watch, @Nullable XStackFrame stackFrame) {
        if (tree == null) {
            InlineWatchNodeImpl.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            InlineWatchNodeImpl.$$$reportNull$$$0(1);
        }
        if (watch == null) {
            InlineWatchNodeImpl.$$$reportNull$$$0(2);
        }
        super(tree, parent, watch.getExpression(), new XInlineWatchValue(watch.getExpression(), tree, stackFrame, watch.getPosition()));
        this.myInlays = new ArrayList<Inlay<InlineDebugRenderer>>();
        this.myWatch = watch;
    }

    @Override
    @NotNull
    public XValue getValueContainer() {
        XValue xValue = (XValue)this.myValueContainer;
        if (xValue == null) {
            InlineWatchNodeImpl.$$$reportNull$$$0(3);
        }
        return xValue;
    }

    @Override
    @NotNull
    public XSourcePosition getPosition() {
        XSourcePosition xSourcePosition = this.myWatch.getPosition();
        if (xSourcePosition == null) {
            InlineWatchNodeImpl.$$$reportNull$$$0(4);
        }
        return xSourcePosition;
    }

    @Override
    @NotNull
    public InlineWatch getWatch() {
        InlineWatch inlineWatch = this.myWatch;
        if (inlineWatch == null) {
            InlineWatchNodeImpl.$$$reportNull$$$0(5);
        }
        return inlineWatch;
    }

    void inlayCreated(Inlay<InlineDebugRenderer> inlay) {
        this.myInlays.add(inlay);
    }

    public void nodeRemoved() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myInlays.forEach(Disposer::dispose);
            this.myInlays.clear();
        });
    }

    @Override
    @Nullable
    public XDebuggerTreeNodeHyperlink getLink() {
        return new XDebuggerTreeNodeHyperlink(" " + this.myWatch.getPosition().getFile().getName() + ":" + (this.myWatch.getPosition().getLine() + 1)){

            public boolean alwaysOnScreen() {
                return true;
            }

            public void onClick(MouseEvent event) {
                InlineWatchNodeImpl.this.myWatch.getPosition().createNavigatable(InlineWatchNodeImpl.this.myTree.getProject()).navigate(true);
                event.consume();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watch";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineWatchNodeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchNodeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XInlineWatchValue
    extends XNamedValue {
        private final XExpression myExpression;
        private final XDebuggerTree myTree;
        private final XStackFrame myStackFrame;
        private final XSourcePosition myPosition;
        private volatile XValue myValue;
        private static final XValuePresentation EMPTY_PRESENTATION = new XValuePresentation(){

            @NotNull
            public String getSeparator() {
                return "";
            }

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer2) {
                if (renderer2 == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/xdebugger/impl/inline/InlineWatchNodeImpl$XInlineWatchValue$1", "renderValue"));
            }
        };

        XInlineWatchValue(XExpression expression, XDebuggerTree tree, XStackFrame frame, XSourcePosition position) {
            super(expression.getExpression());
            this.myExpression = expression;
            this.myTree = tree;
            this.myStackFrame = frame;
            this.myPosition = position;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                XInlineWatchValue.$$$reportNull$$$0(0);
            }
            if (this.myValue != null) {
                this.myValue.computeChildren(node);
            }
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                XInlineWatchValue.$$$reportNull$$$0(1);
            }
            if (place == null) {
                XInlineWatchValue.$$$reportNull$$$0(2);
            }
            if (this.myStackFrame != null) {
                if (this.sessionIsInOtherFileThanNode()) {
                    node.setPresentation(AllIcons.Debugger.Db_watch, EMPTY_PRESENTATION, false);
                    return;
                }
                XDebuggerEvaluator evaluator = this.myStackFrame.getEvaluator();
                if (evaluator != null) {
                    evaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(node, place), this.myStackFrame.getSourcePosition());
                    return;
                }
            }
            node.setPresentation(AllIcons.Debugger.Db_watch, EMPTY_PRESENTATION, false);
        }

        private boolean sessionIsInOtherFileThanNode() {
            XSourcePosition sessionCurrentPosition;
            XDebugSession session2 = XDebugView.getSession((Component)((Object)this.myTree));
            return session2 != null && (sessionCurrentPosition = session2.getCurrentPosition()) != null && !sessionCurrentPosition.getFile().equals(this.myPosition.getFile());
        }

        public void computeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                XInlineWatchValue.$$$reportNull$$$0(3);
            }
            navigatable.setSourcePosition(this.myPosition);
        }

        @NotNull
        public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback2) {
            if (callback2 == null) {
                XInlineWatchValue.$$$reportNull$$$0(4);
            }
            callback2.computed(this.myPosition);
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                XInlineWatchValue.$$$reportNull$$$0(5);
            }
            return threeState;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigatable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineWatchNodeImpl$XInlineWatchValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchNodeImpl$XInlineWatchValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInlineDebuggerData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "computePresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeSourcePosition";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computeInlineDebuggerData";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyEvaluationCallback
        extends XEvaluationCallbackBase
        implements Obsolescent {
            @NotNull
            private final XValueNode myNode;
            @NotNull
            private final XValuePlace myPlace;

            MyEvaluationCallback(@NotNull XValueNode node, XValuePlace place) {
                if (node == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(1);
                }
                this.myNode = node;
                this.myPlace = place;
            }

            public boolean isObsolete() {
                return this.myNode.isObsolete();
            }

            public void evaluated(@NotNull XValue result2) {
                if (result2 == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(2);
                }
                XInlineWatchValue.this.myValue = result2;
                result2.computePresentation(this.myNode, this.myPlace);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(3);
                }
                this.myNode.setPresentation(XDebuggerUIConstants.ERROR_MESSAGE_ICON, (XValuePresentation)new XErrorValuePresentation(errorMessage), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineWatchNodeImpl$XInlineWatchValue$MyEvaluationCallback";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

