/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.TimeStats;
import com.intellij.util.indexing.diagnostic.TooLargeForIndexingFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020*J\u0016\u00108\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00109\u001a\u00020&J\u0010\u0010:\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d0\u001cj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R-\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0\u001cj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001e\u0010)\u001a\u00060*j\u0002`+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006="}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics;", "", "project", "Lcom/intellij/openapi/project/Project;", "fileSetName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getFileSetName", "()Ljava/lang/String;", "indexedFiles", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "Lkotlin/collections/ArrayList;", "getIndexedFiles", "()Ljava/util/ArrayList;", "numberOfFilesFullyIndexedByExtensions", "", "getNumberOfFilesFullyIndexedByExtensions", "()I", "setNumberOfFilesFullyIndexedByExtensions", "(I)V", "numberOfIndexedFiles", "getNumberOfIndexedFiles", "setNumberOfIndexedFiles", "numberOfTooLargeForIndexingFiles", "getNumberOfTooLargeForIndexingFiles", "setNumberOfTooLargeForIndexingFiles", "statsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerFileType;", "Lkotlin/collections/HashMap;", "getStatsPerFileType", "()Ljava/util/HashMap;", "statsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerIndexer;", "getStatsPerIndexer", "tooLargeForIndexingFiles", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/TooLargeForIndexingFile;", "getTooLargeForIndexingFiles", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "totalIndexingTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getTotalIndexingTime", "()J", "setTotalIndexingTime", "(J)V", "addFileStatistics", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatistics", "Lcom/intellij/util/indexing/diagnostic/FileIndexingStatistics;", "contentLoadingTime", "fileSize", "addTooLargeForIndexingFile", "tooLargeForIndexingFile", "getIndexedFilePath", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
public final class IndexingJobStatistics {
    private long totalIndexingTime;
    private int numberOfIndexedFiles;
    private int numberOfFilesFullyIndexedByExtensions;
    private int numberOfTooLargeForIndexingFiles;
    @NotNull
    private final HashMap<String, StatsPerIndexer> statsPerIndexer;
    @NotNull
    private final HashMap<String, StatsPerFileType> statsPerFileType;
    @NotNull
    private final LimitedPriorityQueue<TooLargeForIndexingFile> tooLargeForIndexingFiles;
    @NotNull
    private final ArrayList<PortableFilePath> indexedFiles;
    private final Project project;
    @NotNull
    private final String fileSetName;

    public final long getTotalIndexingTime() {
        return this.totalIndexingTime;
    }

    public final void setTotalIndexingTime(long l) {
        this.totalIndexingTime = l;
    }

    public final int getNumberOfIndexedFiles() {
        return this.numberOfIndexedFiles;
    }

    public final void setNumberOfIndexedFiles(int n) {
        this.numberOfIndexedFiles = n;
    }

    public final int getNumberOfFilesFullyIndexedByExtensions() {
        return this.numberOfFilesFullyIndexedByExtensions;
    }

    public final void setNumberOfFilesFullyIndexedByExtensions(int n) {
        this.numberOfFilesFullyIndexedByExtensions = n;
    }

    public final int getNumberOfTooLargeForIndexingFiles() {
        return this.numberOfTooLargeForIndexingFiles;
    }

    public final void setNumberOfTooLargeForIndexingFiles(int n) {
        this.numberOfTooLargeForIndexingFiles = n;
    }

    @NotNull
    public final HashMap<String, StatsPerIndexer> getStatsPerIndexer() {
        return this.statsPerIndexer;
    }

    @NotNull
    public final HashMap<String, StatsPerFileType> getStatsPerFileType() {
        return this.statsPerFileType;
    }

    @NotNull
    public final LimitedPriorityQueue<TooLargeForIndexingFile> getTooLargeForIndexingFiles() {
        return this.tooLargeForIndexingFiles;
    }

    @NotNull
    public final ArrayList<PortableFilePath> getIndexedFiles() {
        return this.indexedFiles;
    }

    /*
     * WARNING - void declaration
     */
    public final void addFileStatistics(@NotNull VirtualFile file2, @NotNull FileIndexingStatistics fileStatistics, long contentLoadingTime, long fileSize) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileStatistics, (String)"fileStatistics");
        int n = this.numberOfIndexedFiles;
        this.numberOfIndexedFiles = n + 1;
        if (fileStatistics.getWasFullyIndexedByExtensions()) {
            n = this.numberOfFilesFullyIndexedByExtensions;
            this.numberOfFilesFullyIndexedByExtensions = n + 1;
        }
        Map<ID<?, ?>, Long> $this$forEach$iv = fileStatistics.getPerIndexerTimes();
        boolean $i$f$forEach = false;
        Map<ID<?, ?>, Long> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<ID<?, ?>, Long>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            String key$iv;
            void $this$getOrPut$iv;
            void indexId;
            Map.Entry<ID<?, ?>, Long> element$iv;
            Map.Entry<ID<?, ?>, Long> $dstr$indexId$time = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<ID<?, ?>, Long> entry = $dstr$indexId$time;
            int n2 = 0;
            ID<?, ?> iD = entry.getKey();
            entry = $dstr$indexId$time;
            n2 = 0;
            long time = ((Number)entry.getValue()).longValue();
            Map map3 = this.statsPerIndexer;
            Intrinsics.checkNotNullExpressionValue((Object)indexId.getName(), (String)"indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                StatsPerIndexer answer$iv = new StatsPerIndexer(new TimeStats(), 0, 0, 0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            StatsPerIndexer stats = (StatsPerIndexer)object2;
            stats.getIndexingTime().addTime(time);
            StatsPerIndexer statsPerIndexer = stats;
            n2 = statsPerIndexer.getNumberOfFiles();
            statsPerIndexer.setNumberOfFiles(n2 + 1);
            if (fileStatistics.getIndexesProvidedByExtensions().contains(indexId)) {
                StatsPerIndexer statsPerIndexer2 = stats;
                n2 = statsPerIndexer2.getNumberOfFilesIndexedByExtensions();
                statsPerIndexer2.setNumberOfFilesIndexedByExtensions(n2 + 1);
            }
            StatsPerIndexer statsPerIndexer3 = stats;
            statsPerIndexer3.setTotalBytes(statsPerIndexer3.getTotalBytes() + fileSize);
        }
        String string = fileStatistics.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileStatistics.fileType.name");
        String fileTypeName = string;
        Map $this$getOrPut$iv = this.statsPerFileType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(fileTypeName);
        if (value$iv == null) {
            boolean bl4 = false;
            StatsPerFileType answer$iv = new StatsPerFileType(new TimeStats(), new TimeStats(), 0, 0L);
            $this$getOrPut$iv.put(fileTypeName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        StatsPerFileType stats = (StatsPerFileType)object;
        stats.getContentLoadingTime().addTime(contentLoadingTime);
        stats.getIndexingTime().addTime(fileStatistics.getIndexingTime());
        StatsPerFileType statsPerFileType = stats;
        statsPerFileType.setTotalBytes(statsPerFileType.getTotalBytes() + fileSize);
        StatsPerFileType statsPerFileType2 = stats;
        int n3 = statsPerFileType2.getNumberOfFiles();
        statsPerFileType2.setNumberOfFiles(n3 + 1);
        if (IndexDiagnosticDumper.getShouldDumpPathsOfIndexedFiles()) {
            Collection collection = this.indexedFiles;
            PortableFilePath portableFilePath = this.getIndexedFilePath(file2);
            boolean bl5 = false;
            collection.add(portableFilePath);
        }
    }

    public final void addTooLargeForIndexingFile(@NotNull VirtualFile file2, @NotNull TooLargeForIndexingFile tooLargeForIndexingFile) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)tooLargeForIndexingFile, (String)"tooLargeForIndexingFile");
        int n = this.numberOfIndexedFiles;
        this.numberOfIndexedFiles = n + 1;
        n = this.numberOfTooLargeForIndexingFiles;
        this.numberOfTooLargeForIndexingFiles = n + 1;
        this.tooLargeForIndexingFiles.addElement(tooLargeForIndexingFile);
        if (IndexDiagnosticDumper.getShouldDumpPathsOfIndexedFiles()) {
            Collection collection = this.indexedFiles;
            PortableFilePath portableFilePath = this.getIndexedFilePath(file2);
            boolean bl = false;
            collection.add(portableFilePath);
        }
    }

    private final PortableFilePath getIndexedFilePath(VirtualFile file2) {
        PortableFilePath portableFilePath;
        try {
            portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(file2, this.project);
        }
        catch (Exception e) {
            String string = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
            portableFilePath = new PortableFilePath.AbsolutePath(string);
        }
        return portableFilePath;
    }

    @NotNull
    public final String getFileSetName() {
        return this.fileSetName;
    }

    public IndexingJobStatistics(@NotNull Project project, @NotNull String fileSetName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileSetName, (String)"fileSetName");
        this.project = project;
        this.fileSetName = fileSetName;
        boolean bl = false;
        this.statsPerIndexer = new HashMap();
        bl = false;
        this.statsPerFileType = new HashMap();
        bl = false;
        this.tooLargeForIndexingFiles = new LimitedPriorityQueue(5, new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TooLargeForIndexingFile it = (TooLargeForIndexingFile)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getFileSize());
                it = (TooLargeForIndexingFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Long.valueOf(it.getFileSize());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
        bl = false;
        this.indexedFiles = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u001a\u001a\u00060\bj\u0002`\tH\u00c6\u0003J5\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerIndexer;", "", "indexingTime", "Lcom/intellij/util/indexing/diagnostic/TimeStats;", "numberOfFiles", "", "numberOfFilesIndexedByExtensions", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(Lcom/intellij/util/indexing/diagnostic/TimeStats;IIJ)V", "getIndexingTime", "()Lcom/intellij/util/indexing/diagnostic/TimeStats;", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getNumberOfFilesIndexedByExtensions", "setNumberOfFilesIndexedByExtensions", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        @NotNull
        private final TimeStats indexingTime;
        private int numberOfFiles;
        private int numberOfFilesIndexedByExtensions;
        private long totalBytes;

        @NotNull
        public final TimeStats getIndexingTime() {
            return this.indexingTime;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final int getNumberOfFilesIndexedByExtensions() {
            return this.numberOfFilesIndexedByExtensions;
        }

        public final void setNumberOfFilesIndexedByExtensions(int n) {
            this.numberOfFilesIndexedByExtensions = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public StatsPerIndexer(@NotNull TimeStats indexingTime, int numberOfFiles, int numberOfFilesIndexedByExtensions, long totalBytes) {
            Intrinsics.checkNotNullParameter((Object)indexingTime, (String)"indexingTime");
            this.indexingTime = indexingTime;
            this.numberOfFiles = numberOfFiles;
            this.numberOfFilesIndexedByExtensions = numberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
        }

        @NotNull
        public final TimeStats component1() {
            return this.indexingTime;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final int component3() {
            return this.numberOfFilesIndexedByExtensions;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerIndexer copy(@NotNull TimeStats indexingTime, int numberOfFiles, int numberOfFilesIndexedByExtensions, long totalBytes) {
            Intrinsics.checkNotNullParameter((Object)indexingTime, (String)"indexingTime");
            return new StatsPerIndexer(indexingTime, numberOfFiles, numberOfFilesIndexedByExtensions, totalBytes);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, TimeStats timeStats, int n, int n2, long l, int n3, Object object) {
            if ((n3 & 1) != 0) {
                timeStats = statsPerIndexer.indexingTime;
            }
            if ((n3 & 2) != 0) {
                n = statsPerIndexer.numberOfFiles;
            }
            if ((n3 & 4) != 0) {
                n2 = statsPerIndexer.numberOfFilesIndexedByExtensions;
            }
            if ((n3 & 8) != 0) {
                l = statsPerIndexer.totalBytes;
            }
            return statsPerIndexer.copy(timeStats, n, n2, l);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(indexingTime=" + this.indexingTime + ", numberOfFiles=" + this.numberOfFiles + ", numberOfFilesIndexedByExtensions=" + this.numberOfFilesIndexedByExtensions + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            TimeStats timeStats = this.indexingTime;
            return (((timeStats != null ? timeStats.hashCode() : 0) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Integer.hashCode(this.numberOfFilesIndexedByExtensions)) * 31 + Long.hashCode(this.totalBytes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexer)) break block3;
                    StatsPerIndexer statsPerIndexer = (StatsPerIndexer)object;
                    if (!Intrinsics.areEqual((Object)this.indexingTime, (Object)statsPerIndexer.indexingTime) || this.numberOfFiles != statsPerIndexer.numberOfFiles || this.numberOfFilesIndexedByExtensions != statsPerIndexer.numberOfFilesIndexedByExtensions || this.totalBytes != statsPerIndexer.totalBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\r\u0010\u0019\u001a\u00060\bj\u0002`\tH\u00c6\u0003J5\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics$StatsPerFileType;", "", "indexingTime", "Lcom/intellij/util/indexing/diagnostic/TimeStats;", "contentLoadingTime", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(Lcom/intellij/util/indexing/diagnostic/TimeStats;Lcom/intellij/util/indexing/diagnostic/TimeStats;IJ)V", "getContentLoadingTime", "()Lcom/intellij/util/indexing/diagnostic/TimeStats;", "getIndexingTime", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        @NotNull
        private final TimeStats indexingTime;
        @NotNull
        private final TimeStats contentLoadingTime;
        private int numberOfFiles;
        private long totalBytes;

        @NotNull
        public final TimeStats getIndexingTime() {
            return this.indexingTime;
        }

        @NotNull
        public final TimeStats getContentLoadingTime() {
            return this.contentLoadingTime;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public StatsPerFileType(@NotNull TimeStats indexingTime, @NotNull TimeStats contentLoadingTime, int numberOfFiles, long totalBytes) {
            Intrinsics.checkNotNullParameter((Object)indexingTime, (String)"indexingTime");
            Intrinsics.checkNotNullParameter((Object)contentLoadingTime, (String)"contentLoadingTime");
            this.indexingTime = indexingTime;
            this.contentLoadingTime = contentLoadingTime;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
        }

        @NotNull
        public final TimeStats component1() {
            return this.indexingTime;
        }

        @NotNull
        public final TimeStats component2() {
            return this.contentLoadingTime;
        }

        public final int component3() {
            return this.numberOfFiles;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerFileType copy(@NotNull TimeStats indexingTime, @NotNull TimeStats contentLoadingTime, int numberOfFiles, long totalBytes) {
            Intrinsics.checkNotNullParameter((Object)indexingTime, (String)"indexingTime");
            Intrinsics.checkNotNullParameter((Object)contentLoadingTime, (String)"contentLoadingTime");
            return new StatsPerFileType(indexingTime, contentLoadingTime, numberOfFiles, totalBytes);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, TimeStats timeStats, TimeStats timeStats2, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                timeStats = statsPerFileType.indexingTime;
            }
            if ((n2 & 2) != 0) {
                timeStats2 = statsPerFileType.contentLoadingTime;
            }
            if ((n2 & 4) != 0) {
                n = statsPerFileType.numberOfFiles;
            }
            if ((n2 & 8) != 0) {
                l = statsPerFileType.totalBytes;
            }
            return statsPerFileType.copy(timeStats, timeStats2, n, l);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(indexingTime=" + this.indexingTime + ", contentLoadingTime=" + this.contentLoadingTime + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            TimeStats timeStats = this.indexingTime;
            TimeStats timeStats2 = this.contentLoadingTime;
            return (((timeStats != null ? timeStats.hashCode() : 0) * 31 + (timeStats2 != null ? timeStats2.hashCode() : 0)) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileType)) break block3;
                    StatsPerFileType statsPerFileType = (StatsPerFileType)object;
                    if (!Intrinsics.areEqual((Object)this.indexingTime, (Object)statsPerFileType.indexingTime) || !Intrinsics.areEqual((Object)this.contentLoadingTime, (Object)statsPerFileType.contentLoadingTime) || this.numberOfFiles != statsPerFileType.numberOfFiles || this.totalBytes != statsPerFileType.totalBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

