/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

abstract class UpdateTask<Type> {
    private final Semaphore myUpdateSemaphore = new Semaphore();
    private final Set<Type> myItemsBeingIndexed = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final boolean DEBUG = false;

    UpdateTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean processAll(Collection<? extends Type> itemsToProcess, Project project) {
        boolean hasMoreToProcess;
        boolean allItemsProcessed = true;
        do {
            hasMoreToProcess = false;
            for (Type item : itemsToProcess) {
                this.myUpdateSemaphore.down();
                try {
                    boolean processed2 = this.process(item, project);
                    if (!processed2) {
                        hasMoreToProcess = true;
                        allItemsProcessed = false;
                    }
                }
                finally {
                    this.myUpdateSemaphore.up();
                }
                ProgressManager.checkCanceled();
            }
            do {
                ProgressManager.checkCanceled();
            } while (!this.myUpdateSemaphore.waitFor(500L));
        } while (hasMoreToProcess);
        boolean bl = allItemsProcessed;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Type item, Project project) {
        if (this.myItemsBeingIndexed.add(item)) {
            try {
                this.doProcess(item, project);
                boolean bl = true;
                return bl;
            }
            finally {
                this.myItemsBeingIndexed.remove(item);
            }
        }
        return false;
    }

    abstract void doProcess(Type var1, Project var2);

    protected static void trace(String s) {
        System.out.println(Thread.currentThread() + " " + s);
    }
}

