/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.indexing.IdFilter;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;

public final class ProjectIndexableFilesFilter
extends IdFilter {
    private static final int SHIFT = 6;
    private static final int MASK = 63;
    private final long[] myBitMask;
    private final int myModificationCount;
    private final int myMinId;
    private final int myMaxId;

    ProjectIndexableFilesFilter(@NotNull IntList set2, int modificationCount) {
        int value2;
        int i2;
        if (set2 == null) {
            ProjectIndexableFilesFilter.$$$reportNull$$$0(0);
        }
        this.myModificationCount = modificationCount;
        int[] minMax = new int[2];
        if (!set2.isEmpty()) {
            minMax[0] = minMax[1] = set2.getInt(0);
        }
        int n = set2.size();
        for (i2 = 0; i2 < n; ++i2) {
            value2 = set2.getInt(i2);
            minMax[0] = Math.min(minMax[0], value2);
            minMax[1] = Math.max(minMax[1], value2);
        }
        this.myMaxId = minMax[1];
        this.myMinId = minMax[0];
        this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
        n = set2.size();
        for (i2 = 0; i2 < n; ++i2) {
            value2 = set2.getInt(i2) - this.myMinId;
            int n2 = value2 >> 6;
            this.myBitMask[n2] = this.myBitMask[n2] | 1L << (value2 & 0x3F);
        }
    }

    public boolean containsFileId(int id2) {
        if (id2 < this.myMinId) {
            return false;
        }
        if (id2 > this.myMaxId) {
            return false;
        }
        return (this.myBitMask[(id2 -= this.myMinId) >> 6] & 1L << (id2 & 0x3F)) != 0L;
    }

    public int getModificationCount() {
        return this.myModificationCount;
    }

    @NotNull
    public IdFilter.FilterScopeType getFilteringScopeType() {
        IdFilter.FilterScopeType filterScopeType = IdFilter.FilterScopeType.PROJECT_AND_LIBRARIES;
        if (filterScopeType == null) {
            ProjectIndexableFilesFilter.$$$reportNull$$$0(1);
        }
        return filterScopeType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ProjectIndexableFilesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ProjectIndexableFilesFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteringScopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

